/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing;

import java.io.Reader;
import java.io.StringReader;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.AbstractUndoableEdit;
import oracle.bali.xml.dom.parser.TextSynchronizer;

public class DocumentSynchronizer
implements TextSynchronizer {
    private final Document _document;
    private String _systemId;
    private int _changeCount = 0;

    public DocumentSynchronizer(Document document, String systemId) {
        this._document = document;
        this._systemId = systemId;
        Listener listener = new Listener();
        this._document.addUndoableEditListener(listener);
        this._document.addDocumentListener(listener);
    }

    public int getChangeId() {
        return this._changeCount;
    }

    public Reader getReader() {
        try {
            String text = this._document.getText(0, this._document.getLength());
            return new StringReader(text);
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
    }

    public void contentUpdated(Reader reader, String systemId) {
        StringBuffer buf = new StringBuffer();
        try {
            int next;
            while ((next = reader.read()) != -1) {
                buf.append((char)next);
            }
            this._setContent(buf.toString());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setSystemId(systemId);
    }

    public String getSystemId() {
        return this._systemId;
    }

    public void setSystemId(String systemId) {
        this._systemId = systemId;
    }

    private void _setContent(String s) throws Exception {
        int docLength = this._document.getLength();
        if (this._document instanceof AbstractDocument) {
            ((AbstractDocument)this._document).replace(0, docLength, s, null);
        } else {
            this._document.remove(0, docLength);
            this._document.insertString(0, s, null);
        }
    }

    private class CountChangerEdit
    extends AbstractUndoableEdit {
        private final int _oldValue;
        private int _beforeUndoValue;

        public CountChangerEdit() {
            this._oldValue = DocumentSynchronizer.this._changeCount;
        }

        @Override
        public void undo() {
            this._beforeUndoValue = DocumentSynchronizer.this._changeCount;
            DocumentSynchronizer.this._changeCount = this._oldValue;
        }

        @Override
        public void redo() {
            DocumentSynchronizer.this._changeCount = this._beforeUndoValue;
        }
    }

    private class Listener
    implements UndoableEditListener,
    DocumentListener {
        private Listener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            e.getEdit().addEdit(new CountChangerEdit());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DocumentSynchronizer.this._changeCount++;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DocumentSynchronizer.this._changeCount++;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DocumentSynchronizer.this._changeCount++;
        }
    }
}

