/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight.parser;

import java.util.Collections;
import oracle.bali.xml.dom.buffer.DocumentScannerFactory;
import oracle.bali.xml.dom.buffer.locator.DeclarationLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.LocatorManager;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.DocumentHandler;
import oracle.bali.xml.dom.buffer.parser.DocumentScanner;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.insight.parser.DocumentTypeInfo;
import oracle.bali.xml.editor.insight.parser.InsightLocation;
import oracle.bali.xml.editor.insight.parser.TextInfo;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;

public class InsightParser
implements DocumentHandler {
    private DocumentScannerFactory _docScannerFactory = null;
    private InsightLocation _insightLocation = null;
    private int _caretPosition = -1;

    public InsightParser(DocumentScannerFactory docScannerFactory) {
        this._docScannerFactory = docScannerFactory;
    }

    public InsightLocation determineInsightLocation(TextBuffer buffer, int caretPosition) {
        this._caretPosition = caretPosition;
        this._insightLocation = new InsightLocation(buffer, caretPosition);
        DocumentScanner scanner = this._docScannerFactory.createDocumentScanner();
        scanner.setReuseAttributeDeclarations(false);
        scanner.scanDocument((ReadTextBuffer)buffer, (DocumentHandler)this, this._insightLocation.getLocatorManager(), this._insightLocation.getNamespaceDeclarations(), caretPosition);
        return this._insightLocation;
    }

    public void handleStartElement(ResolvedName name, AttributeDeclarations attributes, ElementLocator locator) {
        if (this._caretPosition > locator.getStartOffset()) {
            ElementDeclaration elementDecl = new ElementDeclaration(attributes);
            elementDecl.setResolvedName(name);
            elementDecl.setElementLocator(locator);
            elementDecl.setStartTag(true);
            elementDecl.setEndTag(false);
            this._insightLocation.append(elementDecl);
        }
        this._considerAddingFakeTextInfo((Locator)locator, locator.isStartTagComplete());
    }

    public void handleEmptyElement(ResolvedName name, AttributeDeclarations attributes, ElementLocator locator) {
        if (this._caretInsideElement((Locator)locator, locator.isStartTagComplete())) {
            ElementDeclaration elementDecl = new ElementDeclaration(attributes);
            elementDecl.setResolvedName(name);
            elementDecl.setElementLocator(locator);
            elementDecl.setStartTag(true);
            elementDecl.setEndTag(true);
            this._insightLocation.append(elementDecl);
        }
        this._considerAddingFakeTextInfo((Locator)locator, locator.isStartTagComplete());
    }

    public void handleEndElement(ResolvedName name, SimpleLocator locator, boolean complete) {
        if (this._caretPosition > locator.getStartOffset()) {
            if (this._caretInsideElement((Locator)locator, complete)) {
                ElementDeclaration elementDecl = new ElementDeclaration();
                elementDecl.setResolvedName(name);
                ElementLocator elementLocator = this._insightLocation.getLocatorManager().createElementLocator(locator);
                elementLocator.setStartTagComplete(complete);
                elementDecl.setElementLocator(elementLocator);
                elementDecl.setStartTag(false);
                elementDecl.setEndTag(true);
                this._insightLocation.append(elementDecl);
            } else {
                this._insightLocation.remove(name);
            }
        }
        this._considerAddingFakeTextInfo((Locator)locator, complete);
    }

    public void handleText(String characters, TextLocator locator) {
        if (this._caretPosition >= locator.getStartOffset() && this._caretPosition <= locator.getEndOffset()) {
            TextInfo textInfo = new TextInfo(characters, locator);
            this._insightLocation.setCurrentTextInfo(textInfo);
        }
    }

    public void handleDocumentType(ResolvedName name, String publicID, String systemID, SimpleLocator locator) {
        if (this._insightLocation.getDocumentType() == null) {
            DocumentTypeInfo info = new DocumentTypeInfo(name, publicID, systemID, locator);
            this._insightLocation.setDocumentType(info);
        }
    }

    public void handleCDATASection(String characters, SimpleLocator locator) {
        this._considerAddingFakeTextInfo((Locator)locator, true);
    }

    public void handleProcessingInstruction(String target, String data, SimpleLocator locator) {
        this._considerAddingFakeTextInfo((Locator)locator, true);
    }

    public void handleXMLDeclaration(String version, String encoding, String standalone, DeclarationLocator locator) {
    }

    public void handleComment(String text, SimpleLocator locator) {
        this._considerAddingFakeTextInfo((Locator)locator, true);
    }

    private boolean _caretInsideElement(Locator locator, boolean complete) {
        if (this._caretPosition > locator.getStartOffset()) {
            int endOffset = locator.getEndOffset();
            if (complete ? this._caretPosition < endOffset : this._caretPosition <= endOffset) {
                return true;
            }
        }
        return false;
    }

    private void _considerAddingFakeTextInfo(Locator locator, boolean complete) {
        if (complete && locator.getEndOffset() == this._caretPosition && this._insightLocation.getElementDeclarations().size() > 0) {
            LocatorManager manager = this._insightLocation.getLocatorManager();
            SimpleLocator fake = manager.createSimpleLocator(this._caretPosition, this._caretPosition);
            TextLocator textLocator = manager.createTextLocator(Collections.singletonList(fake));
            TextInfo fakeTextInfo = new TextInfo("", textLocator);
            this._insightLocation.setCurrentTextInfo(fakeTextInfo);
        }
    }
}

