/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.parser.AttributeDeclarations;
import oracle.bali.xml.dom.buffer.parser.ElementDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclaration;
import oracle.bali.xml.dom.buffer.parser.NamespaceDeclarations;
import oracle.bali.xml.dom.buffer.parser.ResolvedName;
import oracle.bali.xml.editor.insight.data.TextItem;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.util.AttributeValueUtils;
import oracle.javatools.buffer.ReadTextBuffer;

public final class InsightUtils {
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    public static ElementDef getElementDef(GrammarProvider provider, List declarations, int index) {
        ElementDef previousElementDef = null;
        for (int i = 0; i <= index; ++i) {
            ElementDef newElementDef = null;
            ElementDeclaration decl = (ElementDeclaration)declarations.get(i);
            ResolvedName elementName = decl.getResolvedName();
            if (elementName != null) {
                String namespace = elementName.getNamespace();
                String localName = elementName.getLocalName();
                if (localName != null) {
                    Grammar g;
                    if (previousElementDef != null) {
                        newElementDef = previousElementDef.getElementDefByName(namespace, localName);
                    }
                    if (newElementDef == null && (g = provider.getGrammarForNamespace(namespace)) != null) {
                        newElementDef = g.getElementDefByName(localName);
                    }
                }
            }
            previousElementDef = newElementDef;
        }
        return previousElementDef;
    }

    public static String getPrefix(NamespaceDeclarations namespaceDecls, String namespace) {
        String prefix = null;
        if (namespace != null) {
            Collection prefixDeclarations = namespaceDecls.getPrefixDeclarations();
            for (NamespaceDeclaration decl : prefixDeclarations) {
                if (!namespace.equals(decl.getNamespace())) continue;
                prefix = decl.getPrefix();
                break;
            }
        }
        return prefix;
    }

    public static int getAttributeAtCaretPosition(AttributeDeclarations attributes, int caretPosition) {
        int attrIndex = -1;
        AttributeLocator attrLocator = null;
        int numAttrs = attributes.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            attrLocator = attributes.getLocator(i);
            if (caretPosition < attrLocator.getStartOffset() || caretPosition > attrLocator.getEndOffset()) continue;
            attrIndex = i;
            break;
        }
        return attrIndex;
    }

    public static Set getExistingAttributes(ElementDeclaration elementDecl, int caretPosition) {
        HashSet<QualifiedName> existingAttrs = new HashSet<QualifiedName>(11);
        AttributeDeclarations attributes = elementDecl.getAttributeDeclarations();
        int numAttrs = attributes.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            ResolvedName attrName;
            AttributeLocator locator = attributes.getLocator(i);
            if (caretPosition >= locator.getStartOffset() && caretPosition <= locator.getEndOffset() || (attrName = attributes.getResolvedName(i)) == null) continue;
            String namespace = attrName.getNamespace();
            String localName = attrName.getLocalName();
            if (localName == null || localName.length() <= 0) continue;
            QualifiedName qName = QualifiedName.getQualifiedName((String)namespace, (String)localName);
            existingAttrs.add(qName);
        }
        return existingAttrs;
    }

    public static ArrayList getRequiredAttributeDefs(Collection attributeDefs) {
        ArrayList<AttributeDef> requiredAttributeDefs = new ArrayList<AttributeDef>(1);
        if (attributeDefs != null) {
            ArrayList attArray = new ArrayList(attributeDefs);
            for (int i = 0; i < attArray.size(); ++i) {
                AttributeDef anAttributeDef = (AttributeDef)attArray.get(i);
                if (!anAttributeDef.isRequired()) continue;
                requiredAttributeDefs.add(anAttributeDef);
            }
        }
        return requiredAttributeDefs;
    }

    public static String getCommonPrefix(String s1, String s2) {
        int commonLength = Math.min(s1.length(), s2.length());
        for (int i = 0; i < commonLength; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return s1.substring(0, i);
        }
        return s1.substring(0, commonLength);
    }

    public static String getBufferText(ReadTextBuffer textBuffer, int startOffset, int endOffset) {
        String bufferText = "";
        int length = endOffset - startOffset;
        char[] bufferChars = textBuffer.getChars(startOffset, length);
        if (bufferChars != null && bufferChars.length > 0) {
            bufferText = new String(bufferChars);
        }
        return bufferText;
    }

    public static void getAttributeValues(AttributeDef attributeDef, TreeSet map) {
        Set enumValues = AttributeValueUtils.getAttributeValues((AttributeDef)attributeDef);
        for (String value : enumValues) {
            TextItem valueItem = new TextItem(value);
            map.add(valueItem);
        }
    }

    private InsightUtils() {
    }
}

