/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor;

import java.util.Locale;
import java.util.Vector;
import oracle.bali.xml.editor.XMLLanguageSupport;
import oracle.bali.xml.editor.renderer.XMLBlockRenderer;
import oracle.bali.xml.editor.renderer.XMLStyles;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

public final class XMLLanguageModule
extends LanguageModule {
    public static final String PROPERTY_KEY_END_TAG_COMPLETION = "XMLLanguageModule.END_TAG";
    public static final String PROPERTY_KEY_REQUIRED_ATTRIBUTE_INSERTION = "XMLLanguageModule.REQUIRED_ATTRIBUTE_INSERTION";
    public static final String PROPERTY_KEY_SMART_INDENT = "XMLLanguageModule.SMART_INDENT";
    private static final Vector _supportedFileTypes = new Vector(7);

    public static void registerFileType(String fileType) {
        if (fileType != null && !_supportedFileTypes.contains(fileType = XMLLanguageModule.getFileType((String)fileType))) {
            _supportedFileTypes.addElement(fileType);
        }
    }

    public String getPresentationName() {
        BundleHelper resources = EditorProperties.getEditorBundle();
        return resources.getString("XML_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return XMLStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version = '1.0' encoding = 'UTF-8'?>\n");
        buffer.append("<!DOCTYPE department PUBLIC \"department.dtd\"  >\n");
        buffer.append("<!-- Employee roster for Sales department -->\n");
        buffer.append("<Department>\n");
        buffer.append("  <Name>Sales</Name>\n");
        buffer.append("  <Location>San Francisco</Location>\n");
        buffer.append("  <EmployeeList>\n");
        buffer.append("    <Employee>\n");
        buffer.append("      <Name>John Smith</Name>\n");
        buffer.append("      <ID>1219</ID>\n");
        buffer.append("    </Employee>\n");
        buffer.append("    <Employee>\n");
        buffer.append("      <Name>Douglas Johnson</Name>\n");
        buffer.append("      <ID>1232</ID>\n");
        buffer.append("    </Employee>\n");
        buffer.append("    <Employee>\n");
        buffer.append("      <Name>Mark Monroe</Name>\n");
        buffer.append("      <ID>1259</ID>\n");
        buffer.append("    </Employee>\n");
        buffer.append("  </EmployeeList>\n");
        buffer.append("</Department>\n");
        return buffer.toString();
    }

    public String[] getSupportedFileTypes() {
        String[] files = new String[_supportedFileTypes.size()];
        _supportedFileTypes.toArray(files);
        return files;
    }

    public void registerStyles(StyleRegistry registry) {
        new XMLStyles(registry);
    }

    public LanguageSupport createLanguageSupport() {
        return new XMLLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new XMLBlockRenderer(buffer);
    }

    public static String getXMLEditorResource(String key) {
        BundleHelper bundle = new BundleHelper("oracle.bali.xml.editor.resource.XMLEditorBundle", Locale.getDefault());
        return bundle.getString(key);
    }

    static {
        XMLLanguageModule.registerFileType("xml");
        XMLLanguageModule.registerFileType("dtd");
        XMLLanguageModule.registerFileType("xsl");
        XMLLanguageModule.registerFileType("xsd");
        XMLLanguageModule.registerFileType("xss");
        XMLLanguageModule.registerFileType("imx");
        XMLLanguageModule.registerFileType("hs");
    }
}

