/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.comp;

import java.io.IOException;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.comp.CXMLStream;
import oracle.xml.comp.CXMLWriter;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DefaultXMLDocumentHandler;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLDocumentHandler;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.util.QxName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class CXMLHandlerBase
extends DefaultXMLDocumentHandler
implements ContentHandler,
CXMLConstants,
LexicalHandler {
    XMLParser parser;
    Locator locator;
    CXMLStream out;
    CXMLWriter writer;
    boolean xmldecl_set = false;
    String version;
    String encoding;
    String standalone;
    XSDValidator validator;
    HashMap typeNames;
    int typeIndex;
    CXMLContext cxmlContext;
    String compressed_stream_version = "2.0";
    char[] chars = new char[1024];
    int charSize = 1024;
    int charLen = 0;
    boolean seenChars;
    boolean retainCDATA = false;
    boolean psvi = false;
    int cDATASectionDepth = 0;

    public CXMLHandlerBase(ObjectOutput objectOutput) throws IOException {
        this.cxmlContext = new CXMLContext();
        this.out = new CXMLStream(this.cxmlContext);
        this.out.setObjectOutput(objectOutput);
        this.writer = (CXMLWriter)this.out.getInfosetWriter();
        this.writer.init();
    }

    public CXMLHandlerBase(CXMLStream cXMLStream) {
        this.out = cXMLStream;
        this.cxmlContext = this.out.cxmlContext;
        this.writer = (CXMLWriter)this.out.getInfosetWriter();
        this.writer.init();
    }

    public CXMLHandlerBase() {
        this.cxmlContext = new CXMLContext();
    }

    public Object getProperty(String string) {
        if (string.equals("oracle.xml.comp.version")) {
            return this.compressed_stream_version;
        }
        return null;
    }

    public void setProperty(String string, Object object) {
        if (string.equals("oracle.xml.version")) {
            this.xmldecl_set = true;
            this.version = object.toString();
        } else if (string.equals("oracle.xml.comp.standalone") && object != null) {
            this.standalone = object.toString();
        } else if (string.equals("oracle.xml.comp.encoding") && object != null) {
            this.encoding = object.toString();
        } else if (string.equals("oracle.xml.comp.version") && object != null) {
            this.compressed_stream_version = object.toString();
        } else if (string.equals("oracle.xml.parser.DOMParser.Parser")) {
            this.parser = (XMLParser)object;
        } else if (string.equals("oracle.xml.parser.XMLParser.ParserCData") && object == Boolean.TRUE) {
            this.retainCDATA = true;
        }
    }

    public void setXSDValidator(XSDValidator xSDValidator) {
        this.validator = xSDValidator;
    }

    public void setPSVI(boolean bl) {
        this.psvi = bl;
        this.typeNames = new HashMap();
        this.typeIndex = 0;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        try {
            if (this.xmldecl_set) {
                this.out.setVersion(this.version);
                this.out.setEncoding(this.encoding);
                this.out.setStandalone(this.standalone);
            }
            this.writer.writeDocument();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.writeByte(37);
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.flushChars();
        try {
            this.writer.writeQName(string3, string, true);
            this.writeElemTypeInfo();
            if (attributes.getLength() != 0) {
                this.writeAttribute(attributes);
            }
            this.writer.startElementContent();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) {
        this.flushChars();
        try {
            this.writer.endElementContent();
            this.writer.writeByte(22);
        }
        catch (IOException iOException) {
            System.out.println("IOException in endElement: ");
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.seenChars = true;
        this.ensureCharCapacity(n2);
        System.arraycopy(cArray, n, this.chars, this.charLen, n2);
        this.charLen += n2;
    }

    void flushChars() {
        if (!this.seenChars) {
            return;
        }
        this.seenChars = false;
        try {
            if (this.retainCDATA && this.cDATASectionDepth > 0) {
                this.writer.writeByte(21);
            } else {
                this.writer.writeByte(23);
            }
            if (this.charLen > 0) {
                this.writer.writeUTF(this.chars, 0, this.charLen);
            } else {
                this.writer.writeUTF("null");
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException in characters");
        }
        this.charLen = 0;
    }

    void ensureCharCapacity(int n) {
        int n2 = this.charLen + n;
        if (n2 < this.charSize) {
            return;
        }
        while (n2 >= this.charSize) {
            this.charSize <<= 1;
        }
        char[] cArray = new char[this.charSize];
        System.arraycopy(this.chars, 0, cArray, 0, this.charLen);
        this.chars = cArray;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushChars();
        try {
            this.writer.writeByte(20);
            this.writer.writeUTF(string);
            if (string2 != null && !string2.equals("")) {
                this.writer.writeUTF(string2);
            } else {
                this.writer.writeUTF("null");
            }
            this.writer.writeBoolean(false);
        }
        catch (IOException iOException) {
            System.out.println("IOExcepition in processingInstruction:");
        }
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
        if (this.parser != null) {
            DTD dTD = (DTD)this.parser.getAttribute("oracle.xml.parser.XMLParser.ParserDTD");
            this.writer.createEvent(11);
            this.writer.setDoctype(dTD);
            this.writer.save();
        }
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        if (this.cDATASectionDepth == 0) {
            this.flushChars();
        }
        ++this.cDATASectionDepth;
    }

    public void endCDATA() throws SAXException {
        if (this.cDATASectionDepth == 1) {
            this.flushChars();
        }
        --this.cDATASectionDepth;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.flushChars();
        String string = new String(cArray, n, n2);
        try {
            this.writer.writeByte(29);
            if (string != null && !string.equals("")) {
                this.writer.writeUTF(string);
            } else {
                this.writer.writeUTF("null");
            }
            this.writer.writeBoolean(false);
        }
        catch (IOException iOException) {
            System.out.println("IOException in compression. " + iOException.toString());
        }
    }

    public void startElement(NSName nSName, SAXAttrList sAXAttrList) throws SAXException {
        this.startElement(nSName.getNamespace(), nSName.getLocalName(), nSName.getQualifiedName(), sAXAttrList);
    }

    public void endElement(NSName nSName) throws SAXException {
        this.endElement(nSName.getNamespace(), nSName.getLocalName(), nSName.getQualifiedName());
    }

    public void setTextDecl(String string, String string2) throws SAXException {
    }

    public void comment(String string) throws SAXException {
        this.flushChars();
        try {
            this.writer.writeByte(29);
            if (string != null && !string.equals("")) {
                this.writer.writeUTF(string);
            } else {
                this.writer.writeUTF("null");
            }
            this.writer.writeBoolean(false);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void setHandler(XMLDocumentHandler xMLDocumentHandler) throws SAXException {
    }

    public XMLDocumentHandler getHandler() {
        return null;
    }

    public void setError(XMLError xMLError) throws SAXException {
    }

    public void setXMLSchema(Object object) throws SAXException {
    }

    public void setDoctype(DTD dTD) throws SAXException {
        this.writer.setDoctype(dTD);
    }

    public void endDoctype() throws SAXException {
    }

    private void writeAttribute(Attributes attributes) throws SAXException, IOException {
        ArrayList arrayList = null;
        if (this.psvi && this.validator != null) {
            arrayList = this.validator.getAttrTypes();
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Object object;
            this.writer.writeQName(attributes.getQName(i), attributes.getURI(i), false);
            if (this.psvi && arrayList != null && arrayList.size() != 0) {
                object = (XSDSimpleType)arrayList.get(i);
                if (object != null) {
                    object = (XSDSimpleType)((XSDSimpleType)object).getNamedBaseType();
                }
                if (object != null) {
                    QName qName = ((XSDNode)object).getQName();
                    byte by = 0;
                    byte by2 = -1;
                    by2 = (byte)((XSDSimpleType)object).getBuiltInId();
                    if (by2 != -1) {
                        by = 4;
                    }
                    if (qName != null) {
                        this.writeTypeInfo(by, by2, qName);
                    }
                }
            }
            if ((object = attributes.getValue(i)) != null && !((String)object).equals("")) {
                this.writer.writeUTF((String)object);
            } else {
                this.writer.writeUTF("null");
            }
            if (attributes instanceof SAXAttrList) {
                this.writer.writeBoolean(((SAXAttrList)attributes).isSpecified(i));
                continue;
            }
            this.writer.writeBoolean(false);
        }
    }

    private void writeElemTypeInfo() throws IOException {
        if (this.psvi && this.validator != null && this.validator.getCurrentMode() == "strict") {
            XSDNode xSDNode;
            XSDSimpleType xSDSimpleType;
            byte by = 0;
            byte by2 = -1;
            XSDElement xSDElement = this.validator.getElementDeclaration();
            if (xSDElement != null) {
                if (xSDElement.isElementGlobal()) {
                    by = (byte)(by | 1);
                }
                if (this.validator.elementNilled()) {
                    by = (byte)(by | 2);
                }
            }
            if ((xSDSimpleType = (xSDNode = this.validator.getTypeDefinition()).getNodeType() == 2 ? (XSDSimpleType)xSDNode : ((XSDComplexType)xSDNode).getSimpleType()) != null) {
                by = (byte)(by | 4);
                by2 = (byte)xSDSimpleType.getBuiltInId();
            }
            QName qName = xSDNode.getNamedBaseType().getQName();
            this.writeTypeInfo(by, by2, qName);
        }
    }

    private void writeTypeInfo(byte by, byte by2, QName qName) throws IOException {
        int n = this.getTypeIndex(qName);
        if (n > 65535) {
            by = (byte)(by | 8);
        }
        if (n == this.typeIndex - 1) {
            this.writer.writeByte(35);
        } else {
            this.writer.writeByte(36);
        }
        this.writer.writeByte(by);
        if (by2 != -1) {
            this.writer.writeByte(by2);
        }
        if (n > 65535) {
            this.writer.writeInt(n);
        } else {
            this.writer.writeShort(n);
        }
        if (n == this.typeIndex - 1) {
            this.writer.writeUTF(qName.getNamespaceURI());
            this.writer.writeUTF(((QxName)qName).getQName());
        }
    }

    private int getTypeIndex(QName qName) {
        Integer n = (Integer)this.typeNames.get(qName);
        if (n == null) {
            n = new Integer(this.typeIndex++);
            this.typeNames.put(qName, n);
        }
        return n;
    }
}

