/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import oracle.xml.binxml.BinXMLDecoder;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLSAXSerializer;
import oracle.xml.util.XMLUtil;

public class BinXMLUtil {
    private static final String base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private static final String hexChars = "0123456789ABCDEF";

    public static byte[] convBase64StringToBytes(String string) {
        int n = 32;
        int n2 = 32;
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < string.length(); ++i) {
            n2 = n;
            n = stringBuffer.charAt(i);
            if (n2 == 13 && n == 10) {
                stringBuffer.deleteCharAt(i);
                stringBuffer.deleteCharAt(i - 1);
                i -= 2;
                continue;
            }
            if (n == 9) {
                stringBuffer.deleteCharAt(i);
                --i;
                continue;
            }
            if (n != 32) continue;
            --i;
        }
        if (string.length() % 4 != 0) {
            return null;
        }
        int n3 = string.length() / 4 * 3;
        if (string.endsWith("==")) {
            n3 -= 2;
        } else if (string.endsWith("=")) {
            --n3;
        }
        byte[] byArray = new byte[n3];
        for (int i = string.length() / 4 - 1; i >= 0; --i) {
            int n4 = (base64Chars.indexOf(string.charAt(i * 4)) & 0x3F) << 18 | (base64Chars.indexOf(string.charAt(i * 4 + 1)) & 0x3F) << 12 | (base64Chars.indexOf(string.charAt(i * 4 + 2)) & 0x3F) << 6 | base64Chars.indexOf(string.charAt(i * 4 + 3)) & 0x3F;
            byArray[i * 3] = (byte)(n4 >> 16 & 0xFF);
            if (string.charAt(i * 4 + 2) == '=') continue;
            byArray[i * 3 + 1] = (byte)(n4 >> 8 & 0xFF);
            if (string.charAt(i * 4 + 3) == '=') continue;
            byArray[i * 3 + 2] = (byte)(n4 & 0xFF);
        }
        return byArray;
    }

    public static String convBytesToBase64String(byte[] byArray) {
        byte by;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (n = 0; n < byArray.length - byArray.length % 3; n += 3) {
            by = (byte)(byArray[n] >> 2 & 0x3F);
            stringBuffer.append(base64Chars.charAt(by));
            by = (byte)(((byArray[n] & 3) << 4) + (byArray[n + 1] >> 4 & 0xF));
            stringBuffer.append(base64Chars.charAt(by));
            by = (byte)(((byArray[n + 1] & 0xF) << 2) + (byArray[n + 2] >> 6 & 3));
            stringBuffer.append(base64Chars.charAt(by));
            by = (byte)(byArray[n + 2] & 0x3F);
            stringBuffer.append(base64Chars.charAt(by));
        }
        if (byArray.length % 3 != 0) {
            if (byArray.length % 3 == 2) {
                by = (byte)(byArray[n] >> 2 & 0x3F);
                stringBuffer.append(base64Chars.charAt(by));
                by = (byte)(((byArray[n] & 3) << 4) + (byArray[n + 1] >> 4 & 0xF));
                stringBuffer.append(base64Chars.charAt(by));
                by = (byte)((byArray[n + 1] & 0xF) << 2);
                stringBuffer.append(base64Chars.charAt(by));
                stringBuffer.append("=");
            } else if (byArray.length % 3 == 1) {
                by = (byte)(byArray[n] >> 2 & 0x3F);
                stringBuffer.append(base64Chars.charAt(by));
                by = (byte)((byArray[n] & 3) << 4);
                stringBuffer.append(base64Chars.charAt(by));
                stringBuffer.append("==");
            }
        }
        return stringBuffer.toString();
    }

    static byte[] convHexStringToBytes(String string) {
        int n = string.length();
        byte[] byArray = string.getBytes();
        for (int i = 0; i < n; ++i) {
            char c = (char)byArray[i];
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue;
            if (c >= 'a' && c < 'f') {
                byArray[i] = (byte)Character.toUpperCase(c);
                continue;
            }
            return null;
        }
        return byArray;
    }

    static String convBytesToHexString(byte[] byArray) {
        byte by = 0;
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            by = (byte)(byArray[i] & 0xF0);
            by = (byte)(by >>> 4);
            by = (byte)(by & 0xF);
            stringBuffer.append(hexChars.charAt(by));
            by = (byte)(byArray[i] & 0xF);
            stringBuffer.append(hexChars.charAt(by));
        }
        return stringBuffer.toString();
    }

    InputStream convertBinXMLStream2InputStream(BinXMLStream binXMLStream) throws BinXMLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLSAXSerializer xMLSAXSerializer = new XMLSAXSerializer(byteArrayOutputStream);
        BinXMLDecoder binXMLDecoder = binXMLStream.getDecoder();
        binXMLDecoder.decode(xMLSAXSerializer, xMLSAXSerializer);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }

    public static XMLDocument switchRoot(XSDNode xSDNode, XMLDocument xMLDocument) {
        XMLElement xMLElement = xSDNode.getDomNode();
        XMLDocument xMLDocument2 = xMLElement.getDocument();
        if (xMLDocument2 != null && xMLDocument2 != xMLDocument) {
            return xMLDocument2;
        }
        return xMLDocument;
    }

    public static String[] getTokens(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 3) {
            String[] stringArray = new String[]{string.trim()};
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public static long hex2dec(String string) {
        return Long.parseLong(string, 16);
    }

    public static boolean isPureWhiteSpace(char[] cArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            if (cArray[i] == ' ' || cArray[i] == '\n' || cArray[i] == '\r' || cArray[i] == '\t') continue;
            return false;
        }
        return true;
    }

    public static URL createURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                String string2 = file.getAbsolutePath();
                String string3 = XMLUtil.getProperty("file.separator");
                if (string3.length() == 1) {
                    char c = string3.charAt(0);
                    if (c != '/') {
                        string2 = string2.replace(c, '/');
                    }
                    if (string2.charAt(0) != '/') {
                        string2 = '/' + string2;
                    }
                }
                string2 = "file://" + string2;
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("Cannot create url for: " + string);
                System.exit(0);
            }
        }
        return uRL;
    }
}

