/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Iterator;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.BaseObject;
import oracle.AWXML.Hierarchy;
import oracle.AWXML.Level;
import oracle.AWXML.RestrictedSourceExpression;
import oracle.AWXML.SourceColumn;

public class DimensionKeySourceExpression
extends RestrictedSourceExpression {
    private Level m_level;
    private Hierarchy m_hierarchy;

    protected DimensionKeySourceExpression() {
    }

    public DimensionKeySourceExpression(BaseObject baseObject) {
        super(baseObject);
    }

    public void setLevel(Level level) {
        if (this.m_hierarchy != null && !this.getNamePart(1, this.m_hierarchy.getId()).equalsIgnoreCase(this.getNamePart(1, level.getId()))) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.m_hierarchy.getId(), level.getId()});
        }
        if (!this.getNamePart(1, this.getId()).equalsIgnoreCase(this.getNamePart(1, level.getId()))) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.getId(), level.getId()});
        }
        this.m_level = level;
    }

    public Level getLevel() {
        return this.m_level;
    }

    public void setHierarchy(Hierarchy hierarchy) {
        if (this.m_level != null && !this.getNamePart(1, this.m_level.getId()).equalsIgnoreCase(this.getNamePart(1, hierarchy.getId()))) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.m_level.getId(), hierarchy.getId()});
        }
        if (!this.getNamePart(1, this.getId()).equalsIgnoreCase(this.getNamePart(1, hierarchy.getId()))) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.getId(), hierarchy.getId()});
        }
        this.m_hierarchy = hierarchy;
    }

    public Hierarchy getHierarchy() {
        return this.m_hierarchy;
    }

    public String WriteToXML() {
        String string = null;
        string = DimensionKeySourceExpression.TAB() + this.WriteElementStart("DimensionKeySourceExpression");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + DimensionKeySourceExpression.TAB() + this.WriteElementEndTag("DimensionKeySourceExpression") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        return string;
    }

    public String WriteContentsToXML() {
        String string = super.WriteContentsToXML();
        if (this.m_level != null) {
            string = string == null ? this.WriteAsIDRef("Level", this.m_level) : string + this.WriteAsIDRef("Level", this.m_level);
        }
        if (this.m_hierarchy != null) {
            string = string == null ? this.WriteAsIDRef("Hierarchy", this.m_hierarchy) : string + this.WriteAsIDRef("Hierarchy", this.m_hierarchy);
        }
        return string;
    }

    public String Create(AWConnection aWConnection) {
        String string = "Success";
        String string2 = this.getId();
        String string3 = string2.substring(string2.lastIndexOf("."));
        string2 = string2.substring(0, string2.lastIndexOf("."));
        string2 = string2.substring(0, string2.lastIndexOf(".")) + ".DIMENSIONMAPGROUP";
        String string4 = null;
        Iterator iterator = this.getSourceColumns().iterator();
        while (iterator.hasNext()) {
            SourceColumn sourceColumn = (SourceColumn)iterator.next();
            if (string4 == null) {
                string4 = sourceColumn.getColumn();
                continue;
            }
            string4 = string4 + "," + sourceColumn.getColumn();
        }
        if (this.m_restriction != null && this.m_restriction.getWhereClause().length() > 0) {
            string4 = string4 + "?" + this.m_restriction.getWhereClause();
        }
        aWConnection.executeCommand("call set_dimension_key_expression(" + this.quoteValue(string2) + "," + this.quoteValue(string4) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-400002", new Object[]{this.getId(), this.m_commandResultText});
        }
        return string;
    }

    public String Alter(AWConnection aWConnection) {
        String string = "Success";
        String string2 = this.getId();
        String string3 = string2.substring(string2.lastIndexOf("."));
        string2 = string2.substring(0, string2.lastIndexOf("."));
        string2 = string2.substring(0, string2.lastIndexOf(".")) + ".DIMENSIONMAPGROUP";
        String string4 = null;
        Iterator iterator = this.getSourceColumns().iterator();
        while (iterator.hasNext()) {
            SourceColumn sourceColumn = (SourceColumn)iterator.next();
            if (string4 == null) {
                string4 = sourceColumn.getColumn();
                continue;
            }
            string4 = string4 + "," + sourceColumn.getColumn();
        }
        if (this.m_restriction != null && this.m_restriction.getWhereClause().length() > 0) {
            string4 = string4 + "?" + this.m_restriction.getWhereClause();
        }
        aWConnection.executeCommand("call set_dimension_key_expression(" + this.quoteValue(string2) + "," + this.quoteValue(string4) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0 && new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-400003", new Object[]{this.getId(), this.m_commandResultText});
        }
        return string;
    }

    public String Delete(AWConnection aWConnection) {
        String string = "Success";
        String string2 = this.getId();
        String string3 = string2.substring(string2.lastIndexOf("."));
        string2 = string2.substring(0, string2.lastIndexOf("."));
        string2 = string2.substring(0, string2.lastIndexOf(".")) + ".DIMENSIONMAPGROUP";
        aWConnection.executeCommand("call set_dimension_key_expression(" + this.quoteValue(string2) + "," + AWNULL + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0 && new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-400004", new Object[]{this.getId(), this.m_commandResultText});
        }
        return string;
    }
}

