/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.sqlcodeadvisor;

import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.sqlcodeadvisor.Advice;
import oracle.dbtools.worksheet.sqlcodeadvisor.AdviceInfo;
import oracle.dbtools.worksheet.sqlcodeadvisor.CodeAdvisor;
import oracle.ide.model.IdeSubject;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.db.ConnectionException;

public class CodeAdvisorCache
extends IdeSubject {
    private boolean m_flushable;
    private URL m_codeURL;
    private Map<String, String> m_sqlToSqlId = new HashMap<String, String>();
    private Map<String, AdviceInfo> m_sqlIdToAdviceInfo = new HashMap<String, AdviceInfo>();
    static CodeAdvisorCache s_instance;
    static Map<URL, CodeAdvisorCache> s_sqlAtURL;
    private static Map<String, Connection> connCache;
    private static final String ASHBASIC = "ash_basic";
    private static final String SQLAREABASIC = "sqlarea_basic";
    private static final String DBENVBASIC = "dbenv_basic";
    private static final String ACTIVESESSIONHISTORY = "ASH";
    private static final String AUTOMATEDWORKLOADREPOS = "AWR";
    private static final String DATABASEENVIRONMENT = "ENV";
    private static HashMap m_queryGroupMap;

    public static CodeAdvisorCache initialize(URL uRL) {
        CodeAdvisorCache codeAdvisorCache = new CodeAdvisorCache();
        codeAdvisorCache.m_codeURL = uRL;
        codeAdvisorCache.m_flushable = false;
        s_sqlAtURL.put(uRL, codeAdvisorCache);
        return codeAdvisorCache;
    }

    URL getURL() {
        return this.m_codeURL;
    }

    boolean isFlushable() {
        return this.m_flushable;
    }

    void setFlushable(boolean bl) {
        this.m_flushable = bl;
    }

    public Set<String> getSqlIds(List<AdviceInfo> list) {
        HashSet<String> hashSet = new HashSet<String>();
        if (list != null) {
            for (AdviceInfo adviceInfo : list) {
                String string = adviceInfo.getSqlId();
                if (string != null) {
                    hashSet.add(string);
                    continue;
                }
                String string2 = adviceInfo.getSql();
                if (string2 == null || (string = this.m_sqlToSqlId.get(string2)) == null) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    public String getSqlId(String string) {
        return this.m_sqlToSqlId.get(string);
    }

    public Collection<AdviceInfo> getAdviceInfos() {
        Collection<AdviceInfo> collection = this.m_sqlIdToAdviceInfo.values();
        return collection;
    }

    public AdviceInfo getAdviceInfo(String string, boolean bl) {
        if (bl) {
            return this.m_sqlIdToAdviceInfo.get(string);
        }
        return this.m_sqlIdToAdviceInfo.get(this.getSqlId(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupCache(List<AdviceInfo> list) {
        Set<String> set = this.getSqlIds(list);
        Set<String> set2 = this.m_sqlIdToAdviceInfo.keySet();
        for (String string : set2) {
            AdviceInfo adviceInfo;
            if (set.contains(string)) {
                adviceInfo = this.m_sqlIdToAdviceInfo.get(string);
                CodeAdvisor.displayWarning(0, 0, 0, "contentsOfCache: url=" + this.getURL() + ", sqlid=" + string + ", sql=" + adviceInfo.getSql() + "\n");
                continue;
            }
            adviceInfo = this.m_sqlIdToAdviceInfo.get(string);
            CodeAdvisorCache codeAdvisorCache = this;
            synchronized (codeAdvisorCache) {
                this.m_sqlIdToAdviceInfo.remove(string);
                this.m_sqlToSqlId.remove(adviceInfo.getSql());
            }
            CodeAdvisor.displayWarning(0, 0, 0, "cleanupCache: url=" + this.getURL() + ", sqlid=" + string + ", sql=" + adviceInfo.getSql() + "\n");
        }
        CodeAdvisor.displayWarning(0, 0, 0, "cleanupCache: url=" + this.getURL() + " leaves sqlToSqlId size=" + this.m_sqlToSqlId.size() + " and sqlIdToAdviceInfo size=" + this.m_sqlIdToAdviceInfo.size() + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdviceInfo register(AdviceInfo adviceInfo, String string) {
        AdviceInfo adviceInfo2 = null;
        if (this.m_sqlToSqlId.containsKey(adviceInfo.getSql())) {
            adviceInfo2 = this.getAdviceInfo(this.getSqlId(adviceInfo.getSql()), true);
            adviceInfo2.syncPositionalInfo(adviceInfo);
            adviceInfo.syncAdviceInfo(adviceInfo2);
            return adviceInfo2;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ReentrantLock reentrantLock = null;
        try {
            connection = CodeAdvisorCache.getConnection(string, false);
            reentrantLock = Connections.getInstance().getLock(connection);
            if (!reentrantLock.tryLock(10000L, TimeUnit.MILLISECONDS)) {
                AdviceInfo adviceInfo3 = adviceInfo2;
                return adviceInfo3;
            }
            statement = connection.prepareStatement("select sys.dbms_sqltune_util0.sqltext_to_sqlid(?), sys.dbms_sqltune_util0.sqltext_to_signature(?,1) from dual");
            statement.setString(1, adviceInfo.getSql() + '\u0000');
            statement.setString(2, adviceInfo.getSql() + '\u0000');
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                BigInteger bigInteger = resultSet.getBigDecimal(2).toBigInteger();
                adviceInfo.setSqlId(string2);
                adviceInfo.setForceMatchingSignature(bigInteger);
                CodeAdvisorCache codeAdvisorCache = this;
                synchronized (codeAdvisorCache) {
                    this.m_sqlToSqlId.put(adviceInfo.getSql(), string2);
                    this.m_sqlIdToAdviceInfo.put(string2, adviceInfo);
                }
                adviceInfo2 = adviceInfo;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (reentrantLock != null && reentrantLock.isHeldByCurrentThread()) {
                reentrantLock.unlock();
            }
        }
        return adviceInfo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(AdviceInfo adviceInfo, String string) {
        boolean bl = false;
        if (this.m_sqlToSqlId.containsKey(adviceInfo.getSql())) {
            AdviceInfo adviceInfo2 = this.getAdviceInfo(this.getSqlId(adviceInfo.getSql()), true);
            if (adviceInfo2.getAdvice().size() > 0) {
                if (adviceInfo2.isRefreshRequested()) {
                    adviceInfo2.removeAdvice();
                } else {
                    return bl;
                }
            }
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            ReentrantLock reentrantLock = null;
            try {
                connection = CodeAdvisorCache.getConnection(string, false);
                reentrantLock = Connections.getInstance().getLock(connection);
                if (!reentrantLock.tryLock(10000L, TimeUnit.MILLISECONDS)) {
                    boolean bl2 = bl;
                    return bl2;
                }
                ArrayList<Advice> arrayList = adviceInfo2.getAdvice();
                Set set = m_queryGroupMap.keySet();
                for (String string2 : set) {
                    String string3 = this.getQuery(connection, string2);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.clear();
                    hashMap.put("SQLID", adviceInfo2.getSqlId());
                    hashMap.put("SIGNATURE", adviceInfo2.getForceMatchingSignature().toString());
                    statement = connection.prepareStatement(string3);
                    DBUtil.bind((String)string3, (PreparedStatement)statement, hashMap);
                    resultSet = statement.executeQuery();
                    String string4 = "";
                    while (resultSet.next()) {
                        string4 = string4 + "AdviceInputFound";
                        arrayList.add(new Advice(string4, 0, 0));
                    }
                }
                if (arrayList.size() == 0) {
                    arrayList.add(new Advice("No information found for this SQL statement", 0, 0));
                    adviceInfo2.setRefreshRequested(true);
                } else {
                    adviceInfo2.setRefreshRequested(false);
                }
                adviceInfo2.setAdvice(arrayList);
                bl = true;
            }
            catch (Exception exception) {
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (reentrantLock != null && reentrantLock.isHeldByCurrentThread()) {
                    reentrantLock.unlock();
                }
            }
        }
        return bl;
    }

    public String getQueryFile() {
        return "/oracle/dbtools/worksheet/sqlcodeadvisor/CodeAdvisorQueries.xml";
    }

    public final String getQuery(Connection connection, String string) {
        Query query = this.getQueryFromFile(connection, string, this.getQueryFile());
        if (query == null) {
            return null;
        }
        return query.getSql();
    }

    public Query getQueryFromFile(Connection connection, String string, String string2) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)string2);
        Query query = queryXMLSupport.getQuery(string, connection);
        return query;
    }

    public String toString() {
        return this.getURL().toString();
    }

    static Connection getConnection(String string, boolean bl) throws DBException, ClassNotFoundException, SQLException, ConnectionException {
        Connection connection;
        if (!string.startsWith("jdbc:oracle:thin:@")) {
            connection = bl ? Connections.getInstance().cloneConnection(string) : Connections.getInstance().getConnection(string, false);
            if (connection == null) {
                throw new SQLException("Failed to obtain database connection");
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (!connCache.containsKey(string2 + "," + string3) || bl) {
                String string4 = stringTokenizer.nextToken();
                Class.forName("oracle.jdbc.OracleDriver");
                connection = DriverManager.getConnection(string2, string3, string4);
                if (!bl) {
                    connCache.put(string2 + "," + string3, connection);
                }
            } else {
                connection = connCache.get(string2 + "," + string3);
            }
        }
        return connection;
    }

    static {
        s_sqlAtURL = new HashMap<URL, CodeAdvisorCache>();
        connCache = new HashMap<String, Connection>();
        m_queryGroupMap = new HashMap(7);
        m_queryGroupMap.put(ASHBASIC, ACTIVESESSIONHISTORY);
        m_queryGroupMap.put(SQLAREABASIC, AUTOMATEDWORKLOADREPOS);
    }
}

