/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.extension;

import java.awt.Component;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.ISQLEditor;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.IGetScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.SqlParserProvider;
import oracle.dbtools.raptor.newscriptrunner.commands.RePopulateNLSMap;
import oracle.dbtools.raptor.templates.TemplateVariableHandler;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.TNSPing;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.commands.CreateConnCmd;
import oracle.dbtools.worksheet.commands.HistoryActionProvider;
import oracle.dbtools.worksheet.commands.SetServerOutputForDBMSTab;
import oracle.dbtools.worksheet.commands.SetWorkSheetTab;
import oracle.dbtools.worksheet.commands.scriptrunner.extension.ScriptRunnerHook;
import oracle.dbtools.worksheet.editor.CodeTemplatesMenu;
import oracle.dbtools.worksheet.editor.OpenWorksheetWizard;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.editor.WorksheetOpenController;
import oracle.dbtools.worksheet.extension.ConnectionVarHandler;
import oracle.dbtools.worksheet.extension.WorksheetConnectionListener;
import oracle.dbtools.worksheet.extension.WorksheetNode;
import oracle.dbtools.worksheet.extension.WorksheetURLFileSystemHelper;
import oracle.dbtools.worksheet.sqlhistory.SqlHistoryDockableFactory;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.model.SqlNode;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableFactory;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.DeployableTextNode;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PrintManager;
import oracle.ide.util.MenuSpec;
import oracle.ide.view.View;
import oracle.ideimpl.editor.EditorManagerImpl;

public class WorksheetAddin
extends EditorAddin {
    public void initialize() {
        Recognizer.registerConversion(SqlNode.class, DeployableTextNode.class);
        Recognizer.registerConversion(SqlNode.class, PlSqlNode.class);
        URLFileSystem.registerHelper((String)"ide.worksheet", (URLFileSystemHelper)new WorksheetURLFileSystemHelper());
        Connections.getInstance().addConnectionListener((ConnectionListener)new WorksheetConnectionListener());
        EditorManager.getEditorManager().register((EditorAddin)this, new Class[]{SqlNode.class, WorksheetNode.class});
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        HistoryActionProvider.initMenu();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), "/oracle/dbtools/worksheet/editor/accelerators.xml");
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), "/oracle/dbtools/worksheet/commands/sqltuningadvisor/accelerators.xml");
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), "/oracle/dbtools/worksheet/accelerators.xml");
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener(CodeTemplatesMenu.getInstance());
        IdeAction ideAction = IdeAction.find((String)"Worksheet.New");
        JMenuItem jMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_TOOLS_MENU);
        Ide.getMenubar().add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
        this.disableSplitDocumentAction();
        PrintManager.getPrintManager().registerDocumentPrintFactory(Worksheet.class, DocumentPrintFactory.class);
        CommandRegistry.addListener(SetWorkSheetTab.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_SET_WORKSHEETNAME);
        CommandRegistry.addListener(DataMover.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_FORALLEVENTS_STMTSUBTYPE);
        CommandRegistry.addListener(TNSPing.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_FORALLEVENTS_STMTSUBTYPE);
        CommandRegistry.addListener(RePopulateNLSMap.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_FORALLEVENTS_STMTSUBTYPE);
        CommandRegistry.addListener(SetServerOutputForDBMSTab.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_BEFOREAFTER_SCRIPT);
        CommandRegistry.addListener(CreateConnCmd.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_CREATE_CONN);
        WorksheetOpenController.init();
        try {
            DockStation dockStation = DockStation.getDockStation();
            dockStation.registerDockableFactory("SQLHISTORY_VIEW_TYPE", (DockableFactory)new SqlHistoryDockableFactory());
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        TemplateVariableHandler.getVariablesMap().put("#user#", ConnectionVarHandler.class);
        RaptorDBAddin.registerSqlOpener((ISQLEditor)new ISQLEditor(){

            public View openNewEditor(String string, String string2) {
                return OpenWorksheetWizard.openNewTempWorksheet(string2, string);
            }

            public View openNewEditor(URL uRL, String string) {
                return OpenWorksheetWizard.openNewWorksheet(string, uRL);
            }
        });
        SqlParserProvider.addGetScriptProvider((IGetScriptParser)new IGetScriptParser(){

            public Iterator<ISQLCommand> getScriptParserIterator(ScriptRunnerContext scriptRunnerContext, Reader reader) {
                return ScriptRunnerHook.getScriptParser(scriptRunnerContext, reader);
            }
        });
    }

    private void disableSplitDocumentAction() {
        IdeAction ideAction = IdeAction.get((int)EditorManagerImpl.SPLIT_DOCUMENT_CMD_ID);
        ideAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                return false;
            }

            public boolean update(IdeAction ideAction, Context context) {
                View view = context.getView();
                if (view != null && view instanceof Worksheet) {
                    ideAction.setEnabled(false);
                    return true;
                }
                return false;
            }
        });
    }

    public Class<Worksheet> getEditorClass() {
        return Worksheet.class;
    }

    public MenuSpec getMenuSpecification() {
        return new MenuSpec(StringUtils.stripMnemonic((String)WorksheetResources.getString("WORKSHEET_NEW")), null, null);
    }
}

