/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor;

import java.awt.Component;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.templates.CodeTemplateUtil;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.model.SqlNode;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;

public class CodeTemplatesMenu
implements ContextMenuListener,
Controller {
    static final String ACCELERATOR_FILE = "oracle/dbtools/worksheet/extension/accelerators2.xml";
    public static int CODE_TEMPLATE = Ide.findOrCreateCmdID((String)"code_template");
    private IdeAction codeTemplate;
    private static CodeTemplatesMenu _instance;

    private CodeTemplatesMenu() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), ACCELERATOR_FILE);
        this.createAction();
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (this.canShow(context) && context.getEvent().getSource() instanceof JTextComponent) {
            if (this.codeTemplate == null) {
                this.createAction();
            }
            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.codeTemplate));
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == CODE_TEMPLATE) {
            if (this.canShow(context)) {
                CodeTemplateUtil.insertTemplate((BasicEditorPane)((FindableEditor)context.getView()).getFocusedEditorPane());
            }
            return true;
        }
        return false;
    }

    private boolean canShow(Context context) {
        Node node = context.getNode();
        if (node != null) {
            View view = context.getView();
            return node instanceof DatabaseSourceNode && view instanceof FindableEditor || node instanceof SqlNode && view instanceof Worksheet;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public static ContextMenuListener getInstance() {
        if (_instance == null) {
            _instance = new CodeTemplatesMenu();
        }
        return _instance;
    }

    private void createAction() {
        if (this.codeTemplate == null) {
            this.codeTemplate = IdeAction.get((int)CODE_TEMPLATE, null, (String)Messages.getString("CodeTemplatesMenu.3"), null, null, null, null, (boolean)true);
            this.codeTemplate.addController((Controller)this);
        }
    }
}

