/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.sqltuningadvisor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisorArb;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisorPanel;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAnalyzeAction;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningCommon;
import oracle.dbtools.worksheet.editor.OpenWorksheetWizard;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.icons.OracleIcons;

public class OverviewPanel
extends JPanel {
    private JPanel m_overviewPanelContainer;
    private JPanel m_overviewPanel;
    private JPanel m_overviewGeneralInfoPanel;
    private JPanel m_overviewSQLPanel;
    private BasicEditorPane m_sqlScriptCodeArea;
    private JTable m_overviewReportTable;
    private Object[][] m_overviewRowData;
    private DefaultTableModel m_defaultTableModel;
    private SqlTuningAdvisorPanel m_staPanel;
    private Toolbar _toolbar;
    public static final String ACCEL_FILE = "/oracle/dbtools/worksheet/commands/sqltuningadvisor/accelerators.xml";
    private JLabel m_sqlid_label;
    private JLabel m_start_label;
    private JLabel m_sqlOrSqlset_label;
    private IdeAction m_runAction = null;
    private static final int RUN_CMD_ID = Ide.findOrCreateCmdID((String)"SqlTuningAdvisor.Run");
    private IdeAction m_runScriptAction = null;
    private static final int RUN_SCRIPT_CMD_ID = Ide.findOrCreateCmdID((String)"SqlTuningAdvisor.RunScripts");
    private ChangeListener myKeystrokeChangeListener;
    private boolean updatingKeyMap;
    public static final Object[] columnNames;

    public OverviewPanel(SqlTuningAdvisorPanel sqlTuningAdvisorPanel) {
        this.m_staPanel = sqlTuningAdvisorPanel;
        this.m_overviewPanelContainer = new JPanel();
        this.m_overviewPanelContainer.setLayout(new BorderLayout());
        this.createOverviewPanel();
        final KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        this.myKeystrokeChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() == keyStrokeOptions) {
                    OverviewPanel.this.updateKeyMap(keyStrokeOptions);
                }
            }
        };
        keyStrokeOptions.addChangeListener(this.myKeystrokeChangeListener);
        this.updateKeyMap(keyStrokeOptions);
    }

    public void createOverviewPanel() {
        this.m_overviewPanel = new JPanel();
        this.initToolbar();
        this.m_overviewPanelContainer.add((Component)this._toolbar, "First");
        this.m_overviewPanel.setLayout(new GridBagLayout());
        Object[][] objectArray = new Object[][]{{"", "", ""}};
        this.m_defaultTableModel = new DefaultTableModel(objectArray, columnNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.m_overviewReportTable = new JTable(this.m_defaultTableModel);
        this.m_overviewGeneralInfoPanel = this.getOverviewPanel();
        this.m_overviewPanel.add((Component)this.m_overviewGeneralInfoPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.m_overviewPanel.add((Component)new JLabel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.1, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.m_overviewSQLPanel = this.getSqlPanel();
        this.m_overviewSQLPanel.setSize(this.m_overviewGeneralInfoPanel.getSize());
        this.m_overviewSQLPanel.setPreferredSize(this.m_overviewGeneralInfoPanel.getPreferredSize());
        this.m_overviewPanel.add((Component)this.m_overviewSQLPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.1, 17, 1, new Insets(0, 10, 0, 10), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.m_overviewReportTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setSize(50, 100);
        this.m_overviewPanel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.m_overviewPanel.validate();
        JScrollPane jScrollPane2 = new JScrollPane(this.m_overviewPanel, 22, 32);
        this.m_overviewPanelContainer.add(jScrollPane2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.m_overviewPanelContainer, gridBagConstraints);
    }

    private JPanel getOverviewPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), " ");
        titledBorder.setTitlePosition(1);
        jPanel.setBorder(titledBorder);
        jPanel.add((Component)new JLabel(" "), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel = new JLabel(" ");
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlTuningAdvisorArb.getString("LABEL_TUNING_TASK_NAME")), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_sqlid_label = new JLabel(SqlTuningCommon.m_STA_Name);
        font = this.m_sqlid_label.getFont();
        this.m_sqlid_label.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)this.m_sqlid_label, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlTuningAdvisorArb.getString("LABEL_TUNING_TASK_OWNER")), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_start_label = new JLabel(SqlTuningCommon.m_owner);
        font = this.m_start_label.getFont();
        this.m_start_label.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)this.m_start_label, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlTuningAdvisorArb.getString("LABEL_WORKLOAD_TYPE")), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_sqlOrSqlset_label = !SqlTuningCommon.m_isSQLSetCreation ? new JLabel(SqlTuningAdvisorArb.getString("LABEL_SQL_STATEMENT")) : new JLabel(SqlTuningAdvisorArb.getString("LABEL_SQL_SET_STATEMENT"));
        font = this.m_sqlOrSqlset_label.getFont();
        this.m_sqlOrSqlset_label.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)this.m_sqlOrSqlset_label, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlTuningAdvisorArb.getString("LABEL_SCOPE")), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel(SqlTuningAdvisorArb.getString("LABEL_COMPREHENSIVE"));
        font = jLabel2.getFont();
        jLabel2.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel2, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(SqlTuningAdvisorArb.getString("LABEL_COMPLETION_STATUS")), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel3 = new JLabel(SqlTuningAdvisorArb.getString("LABEL_COMPLETED"));
        font = jLabel3.getFont();
        jLabel3.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel3, new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(" "), new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel4 = new JLabel(" ");
        font = jLabel4.getFont();
        jLabel4.setFont(font.deriveFont(font.getStyle() | 1));
        jPanel.add((Component)jLabel4, new GridBagConstraints(1, 7, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel getSqlPanel() {
        JPanel jPanel = new JPanel();
        this.m_sqlScriptCodeArea = EditorFactory.createIdeEditorPane();
        this.m_sqlScriptCodeArea.setText("");
        this.m_sqlScriptCodeArea.setAutoscrolls(true);
        this.m_sqlScriptCodeArea.setDocument((Document)new BasicDocument("foo.plsql"));
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin();
        this.m_sqlScriptCodeArea.installPlugin((EditorPlugin)lineGutterPlugin);
        this.m_sqlScriptCodeArea.installPlugin((EditorPlugin)highlightEditorPlugin);
        this.m_sqlScriptCodeArea.setText("");
        JScrollPane jScrollPane = new JScrollPane((Component)this.m_sqlScriptCodeArea, 22, 32);
        jScrollPane.setRowHeaderView((Component)lineGutterPlugin);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    private void initToolbar() {
        this._toolbar = new Toolbar();
        ToolButton toolButton = this._toolbar.add((ToggleAction)this.getRunAction());
        toolButton.setName(this.m_runAction.getValue("Name").toString());
        ToolButton toolButton2 = this._toolbar.add((ToggleAction)this.getRunScriptAction());
        toolButton2.setName(this.m_runScriptAction.getValue("Name").toString());
        this._toolbar.addSeparator();
        this._toolbar.add(Box.createHorizontalStrut(5));
    }

    private IdeAction getRunAction() {
        if (this.m_runAction == null) {
            this.m_runAction = IdeAction.getEnabled((int)RUN_CMD_ID, (String)this.getRunLabel(), (Icon)OracleIcons.getIcon((String)"run.png"));
            this.setupAcceleratorToolTip(this.m_runAction);
            this.m_runAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (RUN_CMD_ID == n) {
                        OverviewPanel.this.runAction();
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    return RUN_CMD_ID == n;
                }
            });
        }
        return this.m_runAction;
    }

    protected String getRunLabel() {
        return SqlTuningAdvisorArb.getString("LABEL_RUN_SCRIPT");
    }

    private void runAction() {
        String string = ScriptUtils.runSqlReturnResult((String)this.getSqlScriptCode(), (Connection)this.m_staPanel.m_sqlTuningAdvisor.getSqlTuningCommon().getConnection());
        string = string + "\n\n" + SqlTuningAdvisorArb.getString("SQL_EXECUTION_COMPLETED");
        if (this.getSqlScriptCode() != null) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)SqlTuningAdvisorArb.getString("TITLE_SQL_RESULT"), null);
        }
    }

    private IdeAction getRunScriptAction() {
        if (this.m_runScriptAction == null) {
            this.m_runScriptAction = IdeAction.getEnabled((int)RUN_SCRIPT_CMD_ID, (String)this.getRunScriptLabel(), (Icon)WorksheetResources.getIcon("RUN_SCRIPT_ICON"));
            this.setupAcceleratorToolTip(this.m_runScriptAction);
            this.m_runScriptAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    if (RUN_SCRIPT_CMD_ID == n) {
                        OverviewPanel.this.runScriptAction();
                        return true;
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    int n = ideAction.getCommandId();
                    return RUN_SCRIPT_CMD_ID == n;
                }
            });
        }
        return this.m_runScriptAction;
    }

    protected String getRunScriptLabel() {
        return SqlTuningAdvisorArb.getString("LABEL_OPEN_WORKSHEET");
    }

    private void runScriptAction() {
        String string = SqlTuningAnalyzeAction.connectionName;
        if (this.getSqlScriptCode() != null) {
            OpenWorksheetWizard.openNewTempWorksheet(string, this.getSqlScriptCode());
        }
    }

    private void updateKeyMap(KeyStrokeOptions keyStrokeOptions) {
        this.updateKeyMap(this, keyStrokeOptions);
    }

    private void updateKeyMap(JComponent jComponent, KeyStrokeOptions keyStrokeOptions) {
        if (!this.updatingKeyMap) {
            this.updatingKeyMap = true;
            MultiInputMap multiInputMap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)keyStrokeOptions, (KeyStrokeContext)OverviewPanel.getKeyStrokeContext());
            jComponent.setInputMap(1, (InputMap)multiInputMap);
            this.updatingKeyMap = false;
        }
    }

    private void setupAcceleratorToolTip(IdeAction ideAction) {
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(OverviewPanel.getKeyStrokeContext());
        List list = keyStrokeMap.getKeyStrokesFor(ideAction.getCommandId());
        if (list != null && list.size() > 0) {
            KeyStrokes keyStrokes = (KeyStrokes)list.get(0);
            StringBuffer stringBuffer = new StringBuffer(20);
            stringBuffer.append(" (");
            for (int i = 0; i < keyStrokes.getLength(); ++i) {
                KeyStroke keyStroke = keyStrokes.getKeyStroke(i);
                if (keyStroke == null) continue;
                String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
                if (string != null && string.length() > 0) {
                    stringBuffer.append(string);
                    stringBuffer.append("+");
                }
                stringBuffer.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
                ideAction.putValueDirectly("AcceleratorKey", (Object)keyStroke);
            }
            stringBuffer.append(")");
            ideAction.putValueDirectly("last-tooltip-suffix", (Object)stringBuffer.toString());
            this.getActionMap().put(ideAction.getCommandId(), (Action)ideAction);
        }
    }

    private static KeyStrokeContext getKeyStrokeContext() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext(ACCEL_FILE);
        return keyStrokeContext;
    }

    private static void registerKeyStrokeContext(KeyStrokeOptions keyStrokeOptions) {
        KeyStrokeContext keyStrokeContext = OverviewPanel.getKeyStrokeContext();
        keyStrokeOptions.removeContext(keyStrokeContext);
        keyStrokeOptions.addContext(keyStrokeContext);
        keyStrokeOptions.solvePostponedMaps();
    }

    public JPanel getOverviewGeneralInfoPanel() {
        return this.m_overviewGeneralInfoPanel;
    }

    public JPanel getOverviewSQLPanel() {
        return this.m_overviewSQLPanel;
    }

    public JTable getOverviewReportTable() {
        return this.m_overviewReportTable;
    }

    public BasicEditorPane getSqlScriptCodeArea() {
        return this.m_sqlScriptCodeArea;
    }

    public String getSqlScriptCode() {
        return this.m_staPanel.getCurrentNodeSqlScript();
    }

    public void setIconsVisible(boolean bl) {
        this.m_runAction.setEnabled(bl);
        this.m_runScriptAction.setEnabled(bl);
    }

    public void refresh() {
        this.m_sqlid_label.setText(SqlTuningCommon.m_STA_Name);
        this.m_start_label.setText(SqlTuningCommon.m_owner);
        if (!SqlTuningCommon.m_isSQLSetCreation) {
            this.m_sqlOrSqlset_label.setText(SqlTuningAdvisorArb.getString("LABEL_SQL_STATEMENT"));
        } else {
            this.m_sqlOrSqlset_label.setText(SqlTuningAdvisorArb.getString("LABEL_SQL_SET_STATEMENT"));
        }
        this.m_sqlScriptCodeArea.setEditable(false);
        this.m_sqlScriptCodeArea.revalidate();
        this.m_sqlScriptCodeArea.repaint();
    }

    public void setOverviewRowData(Object[][] objectArray) {
        this.m_overviewRowData = objectArray;
        this.m_defaultTableModel.setDataVector(this.m_overviewRowData, columnNames);
        TableColumnModel tableColumnModel = this.m_overviewReportTable.getColumnModel();
        TextAreaRenderer textAreaRenderer = new TextAreaRenderer();
        tableColumnModel.getColumn(0).setCellRenderer(textAreaRenderer);
        tableColumnModel.getColumn(1).setCellRenderer(textAreaRenderer);
        tableColumnModel.getColumn(2).setCellRenderer(textAreaRenderer);
    }

    static {
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        OverviewPanel.registerKeyStrokeContext(keyStrokeOptions);
        columnNames = new Object[]{SqlTuningCommon.FINDINGS, SqlTuningCommon.RECOMMENDATIONS, SqlTuningCommon.RATIONALE};
    }

    public class TextAreaRenderer
    extends JTextArea
    implements TableCellRenderer {
        private DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        private final Map<JTable, Map<Object, Map<Object, Integer>>> tablecellSizes = new HashMap<JTable, Map<Object, Map<Object, Integer>>>();

        public TextAreaRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setForeground(this.renderer.getForeground());
            this.setBackground(this.renderer.getBackground());
            this.setBorder(this.renderer.getBorder());
            this.setFont(this.renderer.getFont());
            this.setText(this.renderer.getText());
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            if (tableColumnModel.getColumn(n2) == null || tableColumnModel.getColumnCount() == 0) {
                return this;
            }
            if (tableColumnModel.getColumn(n2).getModelIndex() == 0) {
                return this;
            }
            if (n2 < 0 || n2 > 2) {
                return this;
            }
            this.setSize(tableColumnModel.getColumn(n2).getWidth(), 0);
            int n3 = (int)this.getPreferredSize().getHeight();
            this.addSize(jTable, n, n2, n3);
            n3 = this.findTotalMaximumRowSize(jTable, n);
            if (n3 > 0 && n3 != jTable.getRowHeight(n)) {
                jTable.setRowHeight(n, n3);
            }
            return this;
        }

        private void addSize(JTable jTable, int n, int n2, int n3) {
            Map<Object, Integer> map;
            Map<Object, Map<Object, Integer>> map2 = this.tablecellSizes.get(jTable);
            if (map2 == null) {
                map2 = new HashMap<Object, Map<Object, Integer>>();
                this.tablecellSizes.put(jTable, map2);
            }
            if ((map = map2.get(n)) == null) {
                map = new HashMap<Object, Integer>();
                map2.put(n, map);
            }
            map.put(n2, n3);
        }

        private int findTotalMaximumRowSize(JTable jTable, int n) {
            int n2 = 0;
            Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (!(tableCellRenderer instanceof TextAreaRenderer)) continue;
                TextAreaRenderer textAreaRenderer = (TextAreaRenderer)tableCellRenderer;
                n2 = Math.max(n2, textAreaRenderer.findMaximumRowSize(jTable, n));
            }
            return n2;
        }

        private int findMaximumRowSize(JTable jTable, int n) {
            Map<Object, Map<Object, Integer>> map = this.tablecellSizes.get(jTable);
            if (map == null) {
                return 0;
            }
            Map<Object, Integer> map2 = map.get(n);
            if (map2 == null) {
                return 0;
            }
            int n2 = 0;
            for (Map.Entry<Object, Integer> entry : map2.entrySet()) {
                int n3 = entry.getValue();
                n2 = Math.max(n2, n3);
            }
            return n2;
        }
    }
}

