/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.owaoutput;

import java.sql.Connection;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.commands.dbmsoutput.AbstractOutputPane;
import oracle.dbtools.worksheet.commands.dbmsoutput.OutputController;
import oracle.dbtools.worksheet.commands.owaoutput.OWAOutputDockable;
import oracle.dbtools.worksheet.commands.owaoutput.OWAOutputPane;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;

public final class OWAOutputController
extends OutputController {
    @Override
    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        OWAOutputPane oWAOutputPane = (OWAOutputPane)this.getPane(context);
        if (oWAOutputPane != null && ideAction.getCommandId() == OWAOutputPane.TOGGLE_CMD_ID) {
            RaptorTaskManager.getInstance().addTask((RaptorTask)new EnableOWAOutputTask(oWAOutputPane.getCurrentConnection(), oWAOutputPane, Messages.getString("OWAOutputPane.11").trim(), IRaptorTaskRunMode.MODAL_OPTIONAL, false, true, ideAction.getState(), true));
            return true;
        }
        return bl;
    }

    @Override
    public AbstractOutputPane getPane(Context context) {
        View view = context.getView();
        if (view instanceof OWAOutputDockable) {
            OWAOutputDockable oWAOutputDockable = (OWAOutputDockable)context.getView();
            OWAOutputPane oWAOutputPane = (OWAOutputPane)oWAOutputDockable.getPane();
            return oWAOutputPane;
        }
        return null;
    }

    private static class EnableOWAOutputTask
    extends DatabaseQueryTask {
        private AbstractOutputPane m_pane;
        private Connection m_conn;
        private String m_connectionName;
        private boolean m_shouldEnable = false;
        boolean m_shouldPrint = false;

        public EnableOWAOutputTask(Connection connection, AbstractOutputPane abstractOutputPane, String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(string, iRaptorTaskRunMode, bl, bl2);
            this.m_pane = abstractOutputPane;
            this.m_connectionName = Connections.getInstance().getConnectionName(connection);
            this.m_shouldEnable = bl3;
            this.m_shouldPrint = bl4;
        }

        public EnableOWAOutputTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, boolean bl, boolean bl2) {
            super(string, iRaptorTaskRunMode, bl, bl2);
        }

        public String getConnectionName() {
            return this.m_connectionName;
        }

        public String getQuery() {
            return "";
        }

        protected Object doWork() throws TaskException {
            if (this.m_shouldEnable) {
                this.m_pane.enableOutput(this.m_conn, this.m_shouldPrint);
            } else {
                this.m_pane.disableOutput(this.m_conn);
            }
            return null;
        }
    }
}

