/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetCallback;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.commands.autotrace.AnalyzeAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.dbtools.worksheet.editor.WorksheetTabbedPane;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class ExplainPlanAction
extends AnalyzeAction {
    private Logger logger = Logger.getLogger(AutotracePanel.class.getName());

    public ExplainPlanAction(String string, WorksheetContext worksheetContext) {
        super(Messages.getString("WorksheetTaskUI.9"), string, worksheetContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doWork() throws TaskException {
        if (this.init()) {
            try {
                this.showResultPanel();
                this.explainPlan(this.extractSql(""), this.conn);
                this.autoTracePanel.tbl.revalidate();
                SerializedData.initColumnWidths(this.autoTracePanel.tbl);
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, Messages.getString("ExplainPlanAction.2"), exception);
            }
            finally {
                this.resetCursor();
            }
        }
        return null;
    }

    private final String explainPlan(String string, Connection connection) {
        if (!Connections.getInstance().isTimesTen(connection) && RaptorExtensionConstants.isStandAlone() && DBUtil.hasTransaction((Connection)connection)) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)Messages.getString("Confirm_Commit"), (String)Messages.getString("Uncommitted_transaction"), null)) {
                return null;
            }
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        String string2 = "" + System.currentTimeMillis();
        this.autoTracePanel.explainPlan(string, string2, connection);
        this.autoTracePanel.fetchPlan(string, string2, connection);
        if (!Connections.getInstance().isTimesTen(connection)) {
            try {
                connection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        JFrame jFrame = new JFrame("Result set Panels");
        jFrame.setDefaultCloseOperation(3);
        WorksheetContext worksheetContext = new WorksheetContext();
        ExplainPlanAction explainPlanAction = new ExplainPlanAction(null, worksheetContext);
        explainPlanAction.setAutoTracePanel(new AutotracePanel(null, true, null));
        explainPlanAction.setConnection(DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521:xe", "scott", "tiger"));
        explainPlanAction.explainPlan("select /*+leading(e) use_nl(d) */ * from emp e, dept d where e.deptno = d.deptno ", explainPlanAction.conn);
        explainPlanAction.getAutoTracePanel().setTabLabel("Explain plan 1");
        explainPlanAction.getAutoTracePanel().setContext(worksheetContext);
        ExplainPlanAction explainPlanAction2 = new ExplainPlanAction(null, worksheetContext);
        explainPlanAction2.setAutoTracePanel(new AutotracePanel(null, true, null));
        explainPlanAction2.explainPlan("select * from emp e, dept d where e.deptno = d.deptno", explainPlanAction2.conn);
        explainPlanAction2.setConnection(DriverManager.getConnection("jdbc:oracle:thin:@localhost:1521:xe", "scott", "tiger"));
        explainPlanAction2.getAutoTracePanel().setTabLabel("Explain plan 2");
        explainPlanAction2.getAutoTracePanel().setContext(worksheetContext);
        final WorksheetTabbedPane worksheetTabbedPane = new WorksheetTabbedPane();
        final ITabCloseListner iTabCloseListner = new ITabCloseListner(){

            public void tabClosed() {
            }
        };
        worksheetContext.setCallback(new WorksheetCallback(){

            @Override
            public void focusPanel(WorksheetResultPanel worksheetResultPanel) {
            }

            @Override
            public void setEnabled(boolean bl) {
            }

            @Override
            public void showResultPanel(WorksheetResultPanel worksheetResultPanel) {
                ArrayList<ITabCloseListner> arrayList = new ArrayList<ITabCloseListner>();
                arrayList.add(iTabCloseListner);
                worksheetTabbedPane.addTab(null, "Cmp Tab", worksheetResultPanel.getGUI(), arrayList);
            }

            public void setStatusMessage(String string, Exception exception) {
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.BLUE);
        jPanel.add((Component)new JTextField("tab1"), "Center");
        worksheetTabbedPane.addTab(null, "Tab 1", jPanel, Collections.singletonList(iTabCloseListner));
        worksheetTabbedPane.addTab(null, "Explain plan 1", explainPlanAction.getAutoTracePanel(), Collections.singletonList(iTabCloseListner));
        worksheetTabbedPane.addTab(null, "Explain plan 2", explainPlanAction2.getAutoTracePanel(), Collections.singletonList(iTabCloseListner));
        jFrame.add((Component)((Object)worksheetTabbedPane));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

