/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.commands.autotrace.RowSrcNode;

class AutotraceTreeNode
extends RowSrcNode {
    String m_id = null;
    AutotraceTreeNode parent = null;
    String operation = null;
    String objectName = null;
    String qBlockName = null;
    String options = null;
    String cardinality = null;
    String cost = null;
    String rows = null;
    String gets = null;
    String starts = null;
    String time = null;
    String accessPredicates = null;
    String filterPredicates = null;
    String partitionStart = null;
    String partitionStop = null;
    Color color = new Color(0);
    private AutotraceTreeNode orig = null;
    boolean isSpanned = false;
    String predicates = null;
    Icon overlay = null;
    DBConfig conf = null;
    boolean ignorePredicates;

    public AutotraceTreeNode clone(AutotraceTreeNode autotraceTreeNode) {
        AutotraceTreeNode autotraceTreeNode2 = new AutotraceTreeNode(this.operation);
        autotraceTreeNode2.orig = this;
        autotraceTreeNode2.m_id = this.m_id;
        autotraceTreeNode2.parent = this.parent;
        autotraceTreeNode2.objectName = this.objectName;
        autotraceTreeNode2.qBlockName = this.qBlockName;
        autotraceTreeNode2.options = this.options;
        autotraceTreeNode2.cardinality = this.cardinality;
        autotraceTreeNode2.cost = this.cost;
        autotraceTreeNode2.rows = this.rows;
        autotraceTreeNode2.gets = this.gets;
        autotraceTreeNode2.starts = this.starts;
        autotraceTreeNode2.time = this.time;
        autotraceTreeNode2.accessPredicates = this.accessPredicates;
        autotraceTreeNode2.filterPredicates = this.filterPredicates;
        autotraceTreeNode2.partitionStart = this.partitionStart;
        autotraceTreeNode2.partitionStop = this.partitionStop;
        autotraceTreeNode2.color = this.color;
        autotraceTreeNode2.isSpanned = this.isSpanned;
        autotraceTreeNode2.predicates = this.predicates;
        autotraceTreeNode2.overlay = this.overlay;
        autotraceTreeNode2.ignorePredicates = ((AutotraceTreeNode)this.getRoot()).ignorePredicates;
        autotraceTreeNode2.cascadeDiff = ((AutotraceTreeNode)this.getRoot()).cascadeDiff;
        for (int i = 0; i < this.getChildCount(); ++i) {
            autotraceTreeNode2.add(((AutotraceTreeNode)this.getChildAt(i)).clone(autotraceTreeNode));
        }
        if (autotraceTreeNode != null && !this.matchExists(autotraceTreeNode)) {
            autotraceTreeNode2.overlay = RaptorImagesArb.getIcon((String)"EXCLAMATION");
        }
        return autotraceTreeNode2;
    }

    public AutotraceTreeNode(String string) {
        try {
            this.conf = DBConfig.getInstance();
        }
        catch (Throwable throwable) {
            this.conf = new DBConfig();
        }
        this.ignorePredicates = false;
        this.operation = string;
    }

    @Override
    public Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        return super.getColor();
    }

    @Override
    public String tooltip() {
        if (this.qBlockName != null) {
            return this.operation + " @" + this.qBlockName;
        }
        if (this.operation.endsWith("Predicates")) {
            return this.predicates;
        }
        return this.operation;
    }

    @Override
    public String toString() {
        String string = "";
        if (this.options != null && (this.isExplainPlan() && this.conf.getBoolean("EXPL_OPTIONS") == false || !this.isExplainPlan() && this.conf.getBoolean("AUTO_OPTIONS") == false || this.orig != null)) {
            string = " (" + this.options + ") ";
        }
        String string2 = "";
        if (this.objectName != null && (this.isExplainPlan() && this.conf.getBoolean("EXPL_OBJECT_NAME") == false || !this.isExplainPlan() && this.conf.getBoolean("AUTO_OBJECT_NAME") == false || this.orig != null)) {
            string2 = this.objectName;
        }
        return this.operation + string + string2;
    }

    private boolean isExplainPlan() {
        return this.gets == null || "N/A".equals(this.gets);
    }

    @Override
    public String getValue(String string) {
        if ("OPERATION".equals(string)) {
            return this.operation;
        }
        if ("OBJECT_NAME".equals(string)) {
            return this.objectName;
        }
        if ("OPTIONS".equals(string)) {
            return this.options;
        }
        if ("CARDINALITY".equals(string)) {
            return this.cardinality;
        }
        if ("COST".equals(string)) {
            return this.cost;
        }
        if ("LAST_OUTPUT_ROWS".equals(string)) {
            return this.rows;
        }
        if ("LAST_CR_BUFFER_GETS".equals(string)) {
            return this.gets;
        }
        if ("LAST_ELAPSED_TIME".equals(string)) {
            return this.time;
        }
        if ("LAST_STARTS".equals(string)) {
            return this.starts;
        }
        if ("PARTITION_START".equals(string)) {
            return this.partitionStart;
        }
        if ("PARTITION_STOP".equals(string)) {
            return this.partitionStop;
        }
        if ("ACCESS_PREDICATES".equals(string)) {
            return this.accessPredicates;
        }
        if ("FILTER_PREDICATES".equals(string)) {
            return this.filterPredicates;
        }
        return "???";
    }

    @Override
    public Icon getIcon() {
        Icon icon = null;
        icon = "Access Predicates".equals(this.operation) ? WorksheetResources.getIcon("SIGMAKEYS_ICON") : ("Filter Predicates".equals(this.operation) ? WorksheetResources.getIcon("SIGMAFILTER_ICON") : ("NESTED LOOPS".equals(this.operation) || "MERGE JOIN".equals(this.operation) || "HASH JOIN".equals(this.operation) ? WorksheetResources.getIcon("JOIN_ICON") : ("UNION-ALL".equals(this.operation) ? WorksheetResources.getIcon("UNION_ICON") : (this.operation != null && this.operation.contains("TABLE") ? WorksheetResources.getIcon("TABLE_ICON") : ("VIEW".equals(this.operation) ? WorksheetResources.getIcon("VIEW_ICON") : ("OR".equals(this.operation) ? WorksheetResources.getIcon("OR_ICON") : ("AND".equals(this.operation) ? WorksheetResources.getIcon("AND_ICON") : ("Projection".equals(this.operation) ? WorksheetResources.getIcon("PI_ICON") : (this.operation.startsWith("INDEX") ? WorksheetResources.getIcon("INDEX_ICON") : (this.operation.startsWith("SORT") ? RaptorImagesArb.getIcon((String)"SORTASCENDING_ENA") : (this.isSpanned ? WorksheetResources.getIcon("EMPTY_ICON") : WorksheetResources.getIcon("GRAY_ICON"))))))))))));
        if (this.overlay == null) {
            return icon;
        }
        return new OverlayIcon(icon, this.overlay);
    }

    @Override
    public boolean stucturallyTheSame(RowSrcNode rowSrcNode) {
        AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)rowSrcNode;
        return !(!AutotraceTreeNode.equals(this.operation, autotraceTreeNode.operation) || !AutotraceTreeNode.equals(this.objectName, autotraceTreeNode.objectName) || !AutotraceTreeNode.equals(this.options, autotraceTreeNode.options) || !((AutotraceTreeNode)this.getRoot()).ignorePredicates && !AutotraceTreeNode.equals(this.accessPredicates, autotraceTreeNode.accessPredicates) || !((AutotraceTreeNode)this.getRoot()).ignorePredicates && !AutotraceTreeNode.equals(this.filterPredicates, autotraceTreeNode.filterPredicates));
    }

    private static boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    @Override
    public int depth() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.depth() + 1;
    }

    public static class OverlayIcon
    implements Icon {
        Icon icon;
        Icon overlay;

        public OverlayIcon(Icon icon, Icon icon2) {
            this.icon = icon;
            this.overlay = icon2;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.icon.paintIcon(component, graphics, n, n2);
            Graphics2D graphics2D = (Graphics2D)graphics;
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
            graphics2D.setComposite(alphaComposite);
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.RED, this.getIconWidth(), this.getIconHeight(), Color.PINK);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
    }
}

