/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.util.HtmlTreeTableWidget;
import oracle.dbtools.util.Service;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeNode;
import oracle.dbtools.worksheet.commands.autotrace.RowSrcNode;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.ide.Ide;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.TreeTableModel;
import oracle.javatools.dialogs.MessageDialog;

public class AutotraceTreeModel
extends AbstractTreeTableModel {
    DBConfig conf = null;
    protected String originalSQL;
    private static AutotraceTreeNode emptyRoot = new AutotraceTreeNode("");
    AutotracePanel src;
    AutotraceTreeModel cmp;
    private boolean showPartitionColumns;

    public AutotraceTreeModel(AutotracePanel autotracePanel) {
        super((Object)emptyRoot);
        try {
            this.conf = DBConfig.getInstance();
        }
        catch (Throwable throwable) {
            this.conf = new DBConfig();
        }
        this.src = null;
        this.cmp = null;
        this.showPartitionColumns = false;
        this.src = autotracePanel;
    }

    public AutotraceTreeModel(AutotracePanel autotracePanel, AutotraceTreeModel autotraceTreeModel) {
        super((Object)emptyRoot);
        try {
            this.conf = DBConfig.getInstance();
        }
        catch (Throwable throwable) {
            this.conf = new DBConfig();
        }
        this.src = null;
        this.cmp = null;
        this.showPartitionColumns = false;
        this.src = autotracePanel;
        this.cmp = autotraceTreeModel;
        this.cloneTreeAndMarkDiffs();
    }

    public void reset() {
        this.root = new AutotraceTreeNode("...");
        this.fireTreeStructureChanged((Object)this, new TreeNode[]{(TreeNode)this.root}, null, null);
    }

    public String getSQL() {
        return "select s.last_elapsed_time \n   , s.last_output_rows \n   , s.last_cr_buffer_gets \n   , s.last_starts \n   , p.* \nfrom v$sql_plan p, v$sql_plan_statistics s \nwhere p.hash_value = ? and p.child_number = ? \nand p.hash_value = s.hash_value(+)  \nand p.child_number = s.child_number(+)and p.id = s.operation_id(+)order by p.id";
    }

    public void reload(String string, String string2, Connection connection) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(this.getSQL());
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            this.getPlanAndStats(preparedStatement);
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)Messages.getString("AutotraceTreeModel.14"), null);
        }
        this.reload(this.src.tbl.getTree());
    }

    void reload(final JTree jTree) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AutotraceTreeModel.this.fireTreeStructureChanged((Object)AutotraceTreeModel.this, new TreeNode[]{(TreeNode)AutotraceTreeModel.this.root}, null, null);
                for (int i = 0; i < jTree.getRowCount(); ++i) {
                    TreePath treePath = jTree.getPathForRow(i);
                    RowSrcNode rowSrcNode = (RowSrcNode)treePath.getLastPathComponent();
                    if (SerializedData.getInstance().collapsePredNodes && (rowSrcNode.toString().endsWith("Predicates") || rowSrcNode.toString().endsWith("Projection"))) continue;
                    jTree.expandRow(i);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void explainPlan(String string, String string2, Connection connection) {
        try {
            Statement statement = connection.createStatement();
            statement.execute("explain plan SET STATEMENT_ID = '" + string2 + "' for " + string);
            statement.close();
        }
        catch (SQLException sQLException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)Messages.getString("AutotraceTreeModel.18"), null);
        }
    }

    public void fetchPlan(String string, String string2, Connection connection) {
        this.originalSQL = string;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("select 'N/A' last_elapsed_time \n   , 'N/A' last_output_rows \n   , 'N/A' last_cr_buffer_gets \n   , 'N/A' last_starts \n   , p.* \nfrom plan_table p \nwhere p.statement_id = ? \norder by p.id");
            preparedStatement.setString(1, string2);
            this.getPlanAndStats(preparedStatement);
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)Messages.getString("AutotraceTreeModel.27"), null);
        }
        this.fireTreeStructureChanged((Object)this, new TreeNode[]{(TreeNode)this.root}, null, null);
    }

    public int getChildCount(Object object) {
        return ((DefaultMutableTreeNode)object).getChildCount();
    }

    public Object getChild(Object object, int n) {
        return ((DefaultMutableTreeNode)object).getChildAt(n);
    }

    public boolean isCellEditable(Object object, int n) {
        if (object instanceof RowSrcNode) {
            return ((RowSrcNode)object).isNodeColEditable(n);
        }
        return false;
    }

    public List<String> displayedColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("OPERATION");
        if (this.src.isExplainPlan && this.conf.getBoolean("EXPL_OBJECT_NAME").booleanValue()) {
            arrayList.add("OBJECT_NAME");
        } else if (!this.src.isExplainPlan && this.conf.getBoolean("AUTO_OBJECT_NAME").booleanValue()) {
            arrayList.add("OBJECT_NAME");
        }
        if (this.src.isExplainPlan && this.conf.getBoolean("EXPL_OPTIONS").booleanValue()) {
            arrayList.add("OPTIONS");
        } else if (!this.src.isExplainPlan && this.conf.getBoolean("AUTO_OPTIONS").booleanValue()) {
            arrayList.add("OPTIONS");
        }
        if (this.src.isExplainPlan && this.conf.getBoolean("EXPL_COST").booleanValue()) {
            arrayList.add("COST");
        } else if (!this.src.isExplainPlan && this.conf.getBoolean("AUTO_COST").booleanValue()) {
            arrayList.add("COST");
        }
        if (this.src.isExplainPlan && this.conf.getBoolean("EXPL_CARDINALITY").booleanValue()) {
            arrayList.add("CARDINALITY");
        } else if (!this.src.isExplainPlan && this.conf.getBoolean("AUTO_CARDINALITY").booleanValue()) {
            arrayList.add("CARDINALITY");
        }
        if (!this.src.isExplainPlan && this.conf.getBoolean("LAST_OUTPUT_ROWS").booleanValue()) {
            arrayList.add("LAST_OUTPUT_ROWS");
        }
        if (!this.src.isExplainPlan && this.conf.getBoolean("LAST_CR_BUFFER_GETS").booleanValue()) {
            arrayList.add("LAST_CR_BUFFER_GETS");
        }
        if (!this.src.isExplainPlan && this.conf.getBoolean("LAST_ELAPSED_TIME").booleanValue()) {
            arrayList.add("LAST_ELAPSED_TIME");
        }
        if (!this.src.isExplainPlan && this.conf.getBoolean("LAST_STARTS").booleanValue()) {
            arrayList.add("LAST_STARTS");
        }
        if (this.src.isExplainPlan && !this.conf.getBoolean("EXPL_PREDICATES").booleanValue()) {
            arrayList.add("ACCESS_PREDICATES");
            arrayList.add("FILTER_PREDICATES");
        } else if (!this.src.isExplainPlan && !this.conf.getBoolean("AUTO_PREDICATES").booleanValue()) {
            arrayList.add("ACCESS_PREDICATES");
            arrayList.add("FILTER_PREDICATES");
        }
        if (this.showPartitionColumns) {
            arrayList.add("PARTITION_START");
            arrayList.add("PARTITION_STOP");
        }
        return arrayList;
    }

    public int getColumnCount() {
        return this.displayedColumns().size();
    }

    public String getColumnName(int n) {
        try {
            String string = this.displayedColumns().get(n);
            if (string != null) {
                return string;
            }
            return "??";
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "?";
        }
    }

    public Class getColumnClass(int n) {
        return n == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object object, int n) {
        String string = this.getColumnName(n);
        return ((AutotraceTreeNode)object).getValue(string);
    }

    private void getPlanAndStats(PreparedStatement preparedStatement) throws SQLException {
        Serializable serializable;
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = this.showPartitionColumns;
        this.showPartitionColumns = false;
        while (resultSet.next()) {
            Object object;
            serializable = new AutotraceTreeNode(resultSet.getString("operation"));
            ((AutotraceTreeNode)serializable).m_id = resultSet.getString("id");
            String string = resultSet.getString("parent_id");
            ((AutotraceTreeNode)serializable).objectName = resultSet.getString("object_name");
            ((AutotraceTreeNode)serializable).options = resultSet.getString("options");
            ((AutotraceTreeNode)serializable).cardinality = resultSet.getString("cardinality");
            ((AutotraceTreeNode)serializable).cost = resultSet.getString("cost");
            ((AutotraceTreeNode)serializable).rows = resultSet.getString("last_output_rows");
            ((AutotraceTreeNode)serializable).gets = resultSet.getString("last_cr_buffer_gets");
            ((AutotraceTreeNode)serializable).time = resultSet.getString("last_elapsed_time");
            ((AutotraceTreeNode)serializable).starts = resultSet.getString("last_starts");
            ((AutotraceTreeNode)serializable).partitionStart = resultSet.getString("PARTITION_START");
            ((AutotraceTreeNode)serializable).partitionStop = resultSet.getString("PARTITION_STOP");
            if (((AutotraceTreeNode)serializable).partitionStart != null || ((AutotraceTreeNode)serializable).partitionStop != null) {
                this.showPartitionColumns = true;
            }
            String string2 = null;
            String string3 = null;
            try {
                ((AutotraceTreeNode)serializable).accessPredicates = resultSet.getString("access_predicates");
                ((AutotraceTreeNode)serializable).filterPredicates = resultSet.getString("filter_predicates");
                string2 = resultSet.getString("projection");
                ((AutotraceTreeNode)serializable).qBlockName = resultSet.getString("qblock_name");
                object = resultSet.getClob("other_xml");
                if (object != null) {
                    string3 = object.getSubString(1L, (int)object.length());
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            hashMap.put(((AutotraceTreeNode)serializable).m_id, serializable);
            if ("0".equals(((AutotraceTreeNode)serializable).m_id)) {
                this.root = serializable;
            } else {
                object = (AutotraceTreeNode)hashMap.get(string);
                ((DefaultMutableTreeNode)object).add((MutableTreeNode)((Object)serializable));
                ((AutotraceTreeNode)serializable).parent = object;
            }
            if (((AutotraceTreeNode)serializable).accessPredicates != null && this.showPredicates()) {
                object = new AutotraceTreeNode("Access Predicates");
                ((AutotraceTreeNode)object).color = new Color(170);
                ((AutotraceTreeNode)object).isSpanned = true;
                ((AutotraceTreeNode)object).predicates = ((AutotraceTreeNode)serializable).accessPredicates.replaceAll("\"", "");
                ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)object);
                ((AutotraceTreeNode)object).parent = serializable;
                AutotraceTreeModel.predicates((AutotraceTreeNode)object, ((AutotraceTreeNode)serializable).accessPredicates.replaceAll("\"", ""));
            }
            if (((AutotraceTreeNode)serializable).filterPredicates != null && this.showPredicates()) {
                object = new AutotraceTreeNode("Filter Predicates");
                ((AutotraceTreeNode)object).color = new Color(170);
                ((AutotraceTreeNode)object).isSpanned = true;
                ((AutotraceTreeNode)object).predicates = ((AutotraceTreeNode)serializable).filterPredicates.replaceAll("\"", "");
                ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)object);
                ((AutotraceTreeNode)object).parent = serializable;
                AutotraceTreeModel.predicates((AutotraceTreeNode)object, ((AutotraceTreeNode)serializable).filterPredicates.replaceAll("\"", ""));
            }
            if (string2 != null && this.showProjection()) {
                object = new AutotraceTreeNode("Projection");
                ((AutotraceTreeNode)object).color = new Color(21777);
                ((AutotraceTreeNode)object).isSpanned = true;
                ((DefaultMutableTreeNode)serializable).add((MutableTreeNode)object);
                ((AutotraceTreeNode)object).parent = serializable;
                AutotraceTreeModel.projection((AutotraceTreeNode)object, string2.replaceAll("\"", ""));
            }
            if (string3 == null || !this.showOtherXML()) continue;
            AutotraceTreeModel.parseXML((AutotraceTreeNode)serializable, string3);
        }
        resultSet.close();
        if (bl != this.showPartitionColumns) {
            serializable = (AbstractTableModel)this.src.tbl.getModel();
            ((AbstractTableModel)serializable).fireTableStructureChanged();
        }
    }

    void cloneTreeAndMarkDiffs() {
        this.root = ((AutotraceTreeNode)this.src.getATMdl().root).clone((AutotraceTreeNode)this.cmp.root);
    }

    private static int minLevel(String string) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '(') {
                ++n2;
            } else if (string.charAt(i) == ')') {
                --n2;
            }
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    private static void predicates(AutotraceTreeNode autotraceTreeNode, String string) {
        Object object;
        Object object2;
        String string2 = string.trim();
        if (string2.startsWith("(") && string2.endsWith(")") && AutotraceTreeModel.minLevel((String)(object2 = string2.substring(1, string2.length() - 1))) >= 0) {
            AutotraceTreeModel.predicates(autotraceTreeNode, (String)object2);
            return;
        }
        object2 = new StringTokenizer(string2, "() ", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (((StringTokenizer)object2).hasMoreTokens()) {
            object = ((StringTokenizer)object2).nextToken();
            n2 += ((String)object).length();
            if (" ".equals(object)) continue;
            if ("(".equals(object)) {
                ++n3;
                continue;
            }
            if (")".equals(object)) {
                --n3;
                continue;
            }
            if (n3 == 0 && !bl && "and".equalsIgnoreCase((String)object)) {
                arrayList.add(string2.substring(n, n2 - "and".length()));
                n = n2;
                continue;
            }
            if (n3 != 0 || !"or".equalsIgnoreCase((String)object)) continue;
            if (!bl) {
                arrayList = new ArrayList();
                n = 0;
                bl = true;
            }
            arrayList.add(string2.substring(n, n2 - "or".length()));
            n = n2;
        }
        if (arrayList.size() > 0) {
            arrayList.add(string2.substring(n));
            object = new AutotraceTreeNode(bl ? "OR" : "AND");
            ((AutotraceTreeNode)object).color = new Color(204);
            autotraceTreeNode.add((MutableTreeNode)object);
            ((AutotraceTreeNode)object).isSpanned = true;
            autotraceTreeNode.isSpanned = true;
            ((AutotraceTreeNode)object).parent = autotraceTreeNode;
            for (int i = 0; i < arrayList.size(); ++i) {
                AutotraceTreeModel.predicates((AutotraceTreeNode)object, (String)arrayList.get(i));
            }
        } else {
            object = new AutotraceTreeNode(string2);
            ((AutotraceTreeNode)object).color = new Color(238);
            autotraceTreeNode.add((MutableTreeNode)object);
            ((AutotraceTreeNode)object).isSpanned = true;
            autotraceTreeNode.isSpanned = true;
            ((AutotraceTreeNode)object).parent = autotraceTreeNode;
        }
    }

    private static void projection(AutotraceTreeNode autotraceTreeNode, String string) {
        int n = string.indexOf("], ");
        n = n < 0 ? string.length() : ++n;
        String string2 = string.substring(0, n);
        int n2 = string2.indexOf(91);
        if (n2 < 0) {
            return;
        }
        int n3 = string2.indexOf(44, n2);
        if (n3 < 0) {
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1, string2.length() - 1);
            AutotraceTreeNode autotraceTreeNode2 = new AutotraceTreeNode(string3 + "[" + string4 + "]");
            autotraceTreeNode2.color = new Color(26197);
            autotraceTreeNode2.isSpanned = true;
            autotraceTreeNode.add(autotraceTreeNode2);
        } else {
            String string5 = string2.substring(0, n2);
            String string6 = string2.substring(n2 + 1, n3);
            String string7 = string2.substring(n3 + 1, string2.length() - 1);
            AutotraceTreeNode autotraceTreeNode3 = new AutotraceTreeNode(string5 + "[" + string6 + "," + string7 + "]");
            autotraceTreeNode3.color = new Color(0x556600);
            autotraceTreeNode3.isSpanned = true;
            autotraceTreeNode.add(autotraceTreeNode3);
        }
        if (n < string.length()) {
            AutotraceTreeModel.projection(autotraceTreeNode, string.substring(n + 2));
        }
    }

    private static CYK xmlParser() {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        treeSet.add(new RuleTuple("namevalue", new String[]{"identifier", "'='", "content"}));
        treeSet.add(new RuleTuple("namevalues", new String[]{"namevalue"}));
        treeSet.add(new RuleTuple("namevalues", new String[]{"namevalue", "namevalues"}));
        treeSet.add(new RuleTuple("opentag", new String[]{"'<'", "identifier", "'>'"}));
        treeSet.add(new RuleTuple("opentag", new String[]{"'<'", "identifier", "namevalues", "'>'"}));
        treeSet.add(new RuleTuple("closetag", new String[]{"'<'", "'/'", "identifier", "'>'"}));
        treeSet.add(new RuleTuple("content", new String[]{"identifier"}));
        treeSet.add(new RuleTuple("content", new String[]{"string_literal"}));
        treeSet.add(new RuleTuple("content", new String[]{"digits"}));
        treeSet.add(new RuleTuple("content", new String[]{"'.'"}));
        treeSet.add(new RuleTuple("content", new String[]{"'@'"}));
        treeSet.add(new RuleTuple("content", new String[]{"'('"}));
        treeSet.add(new RuleTuple("content", new String[]{"')'"}));
        treeSet.add(new RuleTuple("content", new String[]{"node"}));
        treeSet.add(new RuleTuple("contents", new String[]{"content"}));
        treeSet.add(new RuleTuple("contents", new String[]{"contents", "content"}));
        treeSet.add(new RuleTuple("node", new String[]{"opentag", "contents", "closetag"}));
        treeSet.add(new RuleTuple("node", new String[]{"'<'", "'!'", "'['", "'CDATA'", "'['", "contents", "']'", "']'", "'>'"}));
        CYK cYK = new CYK(treeSet){

            public int[] atomicSymbols() {
                return new int[]{(Integer)this.symbolIndexes.get("node")};
            }
        };
        return cYK;
    }

    private static void parseXML(AutotraceTreeNode autotraceTreeNode, String string) {
        CYK cYK = AutotraceTreeModel.xmlParser();
        List list = LexerToken.parse((String)string);
        Matrix matrix = cYK.initArray(list);
        int n = matrix.size();
        TreeMap treeMap = new TreeMap();
        cYK.closure(matrix, 0, n + 1, treeMap, -1);
        if (!matrix.contains(0, n, ((Integer)cYK.symbolIndexes.get("node")).intValue())) {
            return;
        }
        ParseNode parseNode = cYK.forest(list, matrix);
        AutotraceTreeModel.node(autotraceTreeNode, parseNode, list, cYK);
    }

    private static void node(AutotraceTreeNode autotraceTreeNode, ParseNode parseNode, List<LexerToken> list, CYK cYK) {
        AutotraceTreeNode autotraceTreeNode2 = autotraceTreeNode;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(((Integer)cYK.symbolIndexes.get("contents")).intValue())) {
                AutotraceTreeModel.content(autotraceTreeNode2, parseNode2, list, cYK);
                return;
            }
            if (!parseNode2.contains(((Integer)cYK.symbolIndexes.get("opentag")).intValue())) continue;
            for (ParseNode parseNode3 : parseNode2.children()) {
                if (!parseNode3.contains(((Integer)cYK.symbolIndexes.get("namevalues")).intValue())) continue;
                autotraceTreeNode2 = new AutotraceTreeNode(parseNode3.content(list));
                autotraceTreeNode2.color = new Color(0x886600);
                autotraceTreeNode2.isSpanned = true;
                autotraceTreeNode.add(autotraceTreeNode2);
            }
        }
    }

    private static void content(AutotraceTreeNode autotraceTreeNode, ParseNode parseNode, List<LexerToken> list, CYK cYK) {
        if (parseNode.contains(((Integer)cYK.symbolIndexes.get("node")).intValue())) {
            AutotraceTreeModel.node(autotraceTreeNode, parseNode, list, cYK);
            return;
        }
        boolean bl = true;
        for (ParseNode parseNode2 : parseNode.children()) {
            if (!parseNode2.contains(((Integer)cYK.symbolIndexes.get("node")).intValue())) continue;
            bl = false;
            break;
        }
        if (bl) {
            AutotraceTreeNode autotraceTreeNode2 = new AutotraceTreeNode(parseNode.content(list));
            autotraceTreeNode2.color = new Color(0x668800);
            autotraceTreeNode2.isSpanned = true;
            autotraceTreeNode.add(autotraceTreeNode2);
        } else {
            for (ParseNode parseNode2 : parseNode.children()) {
                if (!parseNode2.contains(((Integer)cYK.symbolIndexes.get("contents")).intValue())) continue;
                AutotraceTreeModel.content(autotraceTreeNode, parseNode2, list, cYK);
            }
        }
    }

    private boolean showPredicates() {
        if (this.src.isExplainPlan) {
            return this.conf.getBoolean("EXPL_PREDICATES");
        }
        return this.conf.getBoolean("AUTO_PREDICATES");
    }

    private boolean showProjection() {
        if (this.src.isExplainPlan) {
            return this.conf.getBoolean("EXPL_PROJECTION");
        }
        return this.conf.getBoolean("AUTO_PROJECTION");
    }

    private boolean showOtherXML() {
        if (this.src.isExplainPlan) {
            return this.conf.getBoolean("EXPL_OTHER_XML");
        }
        return this.conf.getBoolean("AUTO_OTHER_XML");
    }

    public HtmlTreeTableWidget createHtmlWidget(JTree jTree) {
        int n;
        HtmlTreeTableWidget htmlTreeTableWidget = new HtmlTreeTableWidget();
        htmlTreeTableWidget.columnNames = new String[this.getColumnCount()];
        for (n = 0; n < htmlTreeTableWidget.columnNames.length; ++n) {
            htmlTreeTableWidget.columnNames[n] = this.getColumnName(n);
        }
        for (n = 0; n < jTree.getRowCount(); ++n) {
            int n2;
            TreePath treePath = jTree.getPathForRow(n);
            RowSrcNode rowSrcNode = (RowSrcNode)treePath.getLastPathComponent();
            String[] stringArray = new String[this.getColumnCount()];
            for (n2 = 0; n2 < htmlTreeTableWidget.columnNames.length; ++n2) {
                stringArray[n2] = rowSrcNode.getValue(this.getColumnName(n2));
            }
            n2 = 0;
            if (rowSrcNode instanceof AutotraceTreeNode) {
                n2 = ((AutotraceTreeNode)rowSrcNode).isSpanned ? 1 : 0;
            }
            if (n2 != 0) {
                htmlTreeTableWidget.append(rowSrcNode.toString(), stringArray, rowSrcNode.depth(), rowSrcNode.imageName());
                continue;
            }
            htmlTreeTableWidget.append(null, stringArray, rowSrcNode.depth(), rowSrcNode.imageName());
        }
        return htmlTreeTableWidget;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = Service.readFile((String)"d:/raptor_trunk/worksheet/src/oracle/dbtools/worksheet/commands/autotrace/other_xml.txt");
        CYK cYK = AutotraceTreeModel.xmlParser();
        List list = LexerToken.parse((String)string);
        Visual visual = new Visual(list, (Parser)cYK);
        Matrix matrix = cYK.initArray(list);
        int n = matrix.size();
        TreeMap treeMap = new TreeMap();
        long l = System.currentTimeMillis();
        cYK.closure(matrix, 0, n + 1, treeMap, -1);
        long l2 = System.currentTimeMillis();
        System.out.println("Parse time = " + (l2 - l));
        ParseNode parseNode = cYK.forest(list, matrix);
        visual.draw(matrix);
    }

    static {
        AutotraceTreeModel.emptyRoot.qBlockName = "Empty Explain Plan/Autotrace. Run it from the Toolbar!";
    }
}

