/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.sqlhistory.SqlHistoryDockable;
import oracle.dbtools.worksheet.sqlhistory.SqlHistoryDockableFactory;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;

public class HistoryActionProvider
implements ActionProvider<Void> {
    public static final String HISTORY_CMD = "Worksheet.History";
    private static int _viewActionId = -911;

    public static void initMenu() {
        if (_viewActionId == -911) {
            _viewActionId = Ide.findOrCreateCmdID((String)HISTORY_CMD);
            IdeAction ideAction = IdeAction.get((int)_viewActionId);
            ideAction.addController((Controller)new SQLHistoryController());
            Menubar menubar = Ide.getMenubar();
            JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_VIEW_COMPONENT_PALETTE + 0.001f);
            menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"View"));
        }
    }

    @Override
    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        return true;
    }

    @Override
    public WorksheetTaskWrapper<Void> doAction(String string, WorksheetContext worksheetContext) {
        if (HISTORY_CMD.equals(string)) {
            HistoryActionProvider.showSqlHistory(null);
        }
        return null;
    }

    @Override
    public WorksheetAction getActionAt(int n) {
        return WorksheetAction.createWorksheetAction(HISTORY_CMD, WorksheetAction.ActionType.BOTH, 3, 0.0);
    }

    @Override
    public int getActionsCount() {
        return 1;
    }

    @Override
    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    @Override
    public int getPanelCount() {
        return 0;
    }

    public static void showSqlHistory(Context context) {
        SqlHistoryDockable sqlHistoryDockable = SqlHistoryDockableFactory.getSqlHistoryDockable();
        DockUtil.showDockableWindow((DockableView)sqlHistoryDockable);
    }

    private static class SQLHistoryController
    implements Controller {
        private SQLHistoryController() {
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n != _viewActionId) {
                return false;
            }
            HistoryActionProvider.showSqlHistory(context);
            return true;
        }
    }
}

