/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dbtools.logging.IStatusMessageConsumer;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.ui.IImageRegistry;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.controls.grid.EditableGridController;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTable;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.IRaptorGridUpdater;
import oracle.dbtools.raptor.controls.grid.RaptorEditableGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.DeleteSettings;
import oracle.dbtools.raptor.dialogs.BindDialog;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.Substitution;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.dbtools.worksheet.AbstractWorksheetTaskResultPanel;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetState;
import oracle.dbtools.worksheet.WorksheetTaskUIListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.ide.log.AbstractLogPage;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;

public class StatementRunnerResultsPanel3
extends AbstractWorksheetTaskResultPanel
implements IStatusMessageConsumer,
IActionUpdater {
    private String m_id = null;
    private EditableResultSetTable _table = null;
    private EditableGridController _controller = null;
    private SaveTaskListener _saveTaskListener;
    private static final long serialVersionUID = 1L;
    private String m_tabName = Messages.getString("RunQueryPanel.0");
    private WorksheetState m_state = WorksheetState.CLOSED;
    private ISQLCommand m_command = null;
    private String _connName = null;
    private JScrollPane _scrollPane = null;
    JTextArea _errArea = new JTextArea();
    private Icon tabIcon = this.getWaitingIcon();
    private final Icon _runningIcon = new IconWithSmallOverlay(OracleIcons.getIcon((String)"throbber.gif"), OracleIcons.getIcon((String)"run.png"));
    private final Icon _waitingIcon = new IconWithSmallOverlay(OracleIcons.getIcon((String)"run.png"), IImageRegistry.LIGHT_YELLOW);
    private final Icon _ranOkIcon = OracleIcons.getIcon((String)"run.png");
    private final Icon _problemIcon = new IconWithSmallOverlay(OracleIcons.getIcon((String)"run.png"), OracleIcons.getIcon((String)"exception.png"));
    protected IdeAction _deleteGridSettings = null;
    protected GhostPalette gp = null;

    public StatementRunnerResultsPanel3(String string, WorksheetContext worksheetContext, ISQLCommand iSQLCommand) {
        this._table = new EditableResultSetTable((IActionUpdater)this);
        this._table.setFilterFieldAllowed(false);
        this._controller = this._table.getController();
        this._toolbar.addSeparator();
        this.m_id = string;
        this._connName = worksheetContext.getConnectionName();
        this.m_command = iSQLCommand;
        HyperlinkButton hyperlinkButton = new HyperlinkButton("SQL");
        hyperlinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StatementRunnerResultsPanel3.this._resultsPanel.isShowing()) {
                    if (StatementRunnerResultsPanel3.this.gp != null && StatementRunnerResultsPanel3.this.gp.isShowing()) {
                        StatementRunnerResultsPanel3.this.gp.setVisible(false);
                    }
                    StatementRunnerResultsPanel3.this.gp = new GhostPalette((JComponent)StatementRunnerResultsPanel3.this._resultsPanel);
                    StatementRunnerResultsPanel3.this.gp.setHideOnLoseFocus(true);
                    StatementRunnerResultsPanel3.this.gp.fadeInOut(true);
                    StatementRunnerResultsPanel3.this.gp.setLook(UIConstants.Look.LIGHT);
                    int n = StatementRunnerResultsPanel3.this._resultsPanel.getLocation().x;
                    int n2 = StatementRunnerResultsPanel3.this._resultsPanel.getLocation().y;
                    Point point = new Point(n, n2);
                    point = SwingUtilities.convertPoint(StatementRunnerResultsPanel3.this._resultsPanel, point, null);
                    StatementRunnerResultsPanel3.this.gp.setLocation(point);
                    StatementRunnerResultsPanel3.this.gp.setTitle(StatementRunnerResultsPanel3.this.getTabLabel() + " SQL");
                    MultiLineLabel multiLineLabel = new MultiLineLabel();
                    multiLineLabel.setTextWrapper(WordWrapper.getTextWrapper());
                    multiLineLabel.setText(Connections.getDisplayName((String)StatementRunnerResultsPanel3.this.getConnectionName()) + " : " + StatementRunnerResultsPanel3.this.m_command.getSql());
                    JScrollPane jScrollPane = new JScrollPane((Component)multiLineLabel, 20, 30);
                    jScrollPane.setPreferredSize(new Dimension(StatementRunnerResultsPanel3.this._resultsPanel.getSize().width / 2, StatementRunnerResultsPanel3.this._resultsPanel.getSize().height / 2));
                    final HyperlinkButton hyperlinkButton = new HyperlinkButton(Messages.getString("StatementRunnerResultsPanel.2"));
                    hyperlinkButton.setBorder(BorderFactory.createEmptyBorder());
                    hyperlinkButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            StringSelection stringSelection = new StringSelection(StatementRunnerResultsPanel3.this.m_command.getSql());
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            ClipboardStack.pushCurrentClipboard();
                            clipboard.setContents(stringSelection, stringSelection);
                            hyperlinkButton.setSelected(false);
                        }
                    });
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.add((Component)jScrollPane, "Center");
                    jPanel.add((Component)hyperlinkButton, "South");
                    StatementRunnerResultsPanel3.this.gp.add((Component)jPanel);
                    StatementRunnerResultsPanel3.this.gp.setSize(jScrollPane.getPreferredSize());
                    StatementRunnerResultsPanel3.this.gp.show(Ide.getMainWindow().getLayeredPane(), false, false);
                }
            }
        });
        this._deleteGridSettings = IdeAction.get((int)DeleteSettings._cmdIdDeleteSettings);
        if (this._deleteGridSettings != null) {
            this._toolbar.add((ToggleAction)this._deleteGridSettings);
            this._deleteGridSettings.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"remove_file.png"));
            this._deleteGridSettings.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    if (ideAction.getCommandId() == DeleteSettings._cmdIdDeleteSettings) {
                        StringBuilder stringBuilder = new StringBuilder("Delete Persisted Settings ");
                        if (StatementRunnerResultsPanel3.this._table != null) {
                            if (RaptorGridPersistedSettings.deletePersistentSettings((RaptorGridTable)StatementRunnerResultsPanel3.this._table)) {
                                stringBuilder.append("successful");
                                if (StatementRunnerResultsPanel3.this._table.isVisible()) {
                                    StatementRunnerResultsPanel3.this._table.refresh();
                                }
                            } else {
                                stringBuilder.append("unsuccessful");
                            }
                            MessageDialog.information((Component)StatementRunnerResultsPanel3.this._table, (Object)stringBuilder, (String)"Delete Peristed Settings", null);
                            return true;
                        }
                    }
                    return false;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    return true;
                }
            });
        }
        this._toolbar.add((Component)hyperlinkButton);
        this._toolbar.addSeparator();
        this._toolbar.add(Box.createHorizontalStrut(5));
        this.getStatusPanel().setOpaque(false);
        this.getStatusLabel().setOpaque(false);
        this._toolbar.add((Component)this.getStatusPanel());
        this._errArea.setEditable(false);
        this._table.setColumnSelectorAvailable(true);
        Substitution substitution = new Substitution(worksheetContext.getScriptRunnerContext());
        try {
            substitution.replaceSubstitution(iSQLCommand);
        }
        catch (Substitution.SubstitutionException substitutionException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, substitutionException.getStackTrace()[0].toString(), substitutionException);
            throw new CancellationException();
        }
        Map map = BindDialog.getBindValues((String)iSQLCommand.getSql());
        if (map == null) {
            throw new CancellationException();
        }
        this._table.setQuery(this._connName, this.m_command.getSql(), null, map);
        this._table.registerConsumer((IStatusMessageConsumer)this);
        this._table.registerGridUpdater((IRaptorGridUpdater)new EditableResultSetTableModel.DataTabGridUpdater(this._table.getGridModel()));
        this._controller.addToolBarActions(this._toolbar);
        this._scrollPane = new JScrollPane((Component)this._table, 22, 30);
        JViewport jViewport = new JViewport();
        jViewport.setView(this._table.getRowHeader());
        jViewport.setPreferredSize(this._table.getRowHeader().getMaximumSize());
        this._scrollPane.setRowHeader(jViewport);
        this._resultsPanel.add((Component)this._scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLockableUI(new LockableUI());
        JXLayer jXLayer = new JXLayer((Component)this._resultsPanel, (LayerUI)this.getLockableUI());
        this._mainPanel.add((Component)jXLayer, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void open() {
        try {
            ArrayList<AbstractWorksheetTaskResultPanel.ResultsPanelTaskListener> arrayList = new ArrayList<AbstractWorksheetTaskResultPanel.ResultsPanelTaskListener>();
            arrayList.add(this.getTaskListener());
            ArrayList<SaveTaskListener> arrayList2 = new ArrayList<SaveTaskListener>();
            arrayList2.add(this.getSaveTaskListener());
            List<WorksheetTaskUIListener> list = Collections.singletonList(new WorksheetTaskUIListener(this.getContext(), this.m_command));
            this._table.open(new RaptorEditableGridTaskWrapper(this.getTabLabel(), IRaptorTaskRunMode.TASKVIEWER, true, arrayList, arrayList2, list, Collections.singletonList(this.getTaskViewer())));
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public String getConnectionName() {
        return this._connName;
    }

    @Override
    public String getOutputText() {
        return null;
    }

    @Override
    public String getSQL() {
        return this.m_command.getSql();
    }

    public void setStatusMessage(final String string, final Exception exception) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string2 = string;
                if (exception != null) {
                    if (exception.getCause() instanceof CancellationException) {
                        StatementRunnerResultsPanel3.this.createErrorComp(exception.getCause());
                    } else {
                        StatementRunnerResultsPanel3.this.createErrorComp(exception);
                    }
                } else {
                    StatementRunnerResultsPanel3.this.getStatusLabel().setText(string2);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public JComponent getGUI() {
        return this;
    }

    @Override
    public String getID() {
        return this.m_id;
    }

    @Override
    public WorksheetState getState() {
        return this.m_state;
    }

    @Override
    public String getTabLabel() {
        return this.m_tabName;
    }

    @Override
    public String getTabToolTip() {
        return "<html>" + this.m_command.getSQLOrig() + "</html>";
    }

    @Override
    public boolean isCloseable() {
        return true;
    }

    @Override
    public void setState(WorksheetState worksheetState) {
        this.m_state = worksheetState;
    }

    @Override
    public void setTabLabel(String string) {
        this.m_tabName = string;
    }

    public void tabClosed() {
        if (this._table != null) {
            this._table.closeModel();
        }
    }

    protected void refresh() {
        this.setTabIcon(this._runningIcon);
        this._resultsPanel.remove(this._errArea);
        this._resultsPanel.add((Component)this._scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this._table.isVisible()) {
            this._table.refresh();
        }
    }

    public final boolean isNotPLSQL(String string) {
        boolean bl = string.equals(SQLCommand.StmtSubType.G_S_INSERT) || string.equals(SQLCommand.StmtSubType.G_S_UPDATE) || string.equals(SQLCommand.StmtSubType.G_S_DELETE) || string.equals(SQLCommand.StmtSubType.G_S_SELECT) || string.equals(SQLCommand.StmtSubType.G_S_MERGE) || string.equals(SQLCommand.StmtSubType.G_S_WITH);
        return bl;
    }

    @Override
    protected void createErrorComp(Throwable throwable) {
        this.setTabIcon(this._problemIcon);
        this._errArea.setText("");
        String string = null;
        SQLException sQLException = null;
        if (throwable != null) {
            TaskException taskException;
            if (throwable instanceof SQLException) {
                sQLException = (SQLException)throwable;
            } else if (throwable.getCause() instanceof SQLException) {
                sQLException = (SQLException)throwable.getCause();
            } else if (throwable.getCause() instanceof TaskException && (taskException = (TaskException)throwable.getCause()).getCause() instanceof SQLException) {
                sQLException = (SQLException)taskException.getCause();
            }
            if (sQLException != null && (string = sQLException.getLocalizedMessage()) != null && string.indexOf("ORA") > -1) {
                taskException = new Oerr();
                try {
                    string = string + taskException.oerr(string);
                }
                catch (OerrException oerrException) {
                    // empty catch block
                }
            }
            if (string == null) {
                string = throwable instanceof CancellationException || throwable.getCause() instanceof CancellationException ? Messages.getString("RunQueryPanel.10") : throwable.getLocalizedMessage();
            }
        }
        this._errArea.setText(string);
        this._resultsPanel.remove(this._scrollPane);
        this._resultsPanel.add((Component)this._errArea, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private SaveTaskListener getSaveTaskListener() {
        if (this._saveTaskListener == null) {
            this._saveTaskListener = new SaveTaskListener();
        }
        return this._saveTaskListener;
    }

    public void updateActions() {
    }

    @Override
    public Icon getTabIcon() {
        return this.tabIcon;
    }

    @Override
    public void setTabIcon(Icon icon) {
        this.tabIcon = icon;
    }

    @Override
    public Icon getRunningIcon() {
        return this._runningIcon;
    }

    @Override
    public Icon getWaitingIcon() {
        return this._waitingIcon;
    }

    @Override
    public Icon getRanOKIcon() {
        return this._ranOkIcon;
    }

    public Icon getRanOkIcon() {
        return this._ranOkIcon;
    }

    public Icon getProblemIcon() {
        return this._problemIcon;
    }

    @Override
    protected void initCommands() {
        this.CLEAR_CMD_ID = this.NULL_CMD_ID;
        this.SAVE_CMD_ID = this.NULL_CMD_ID;
    }

    protected final class SaveTaskListener
    extends RaptorTaskAdapter {
        AbstractLogPage logPage;

        protected SaveTaskListener() {
            StatementRunnerResultsPanel3.this._table;
            this.logPage = EditableResultSetTable.getLogPage();
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            this.logPage.log((Object)"\n\n");
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            this.showMessages();
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            this.showMessages();
        }

        private void showMessages() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    int n;
                    SaveTaskListener.this.logPage.show();
                    SaveTaskListener.this.logPage.activate();
                    List list = StatementRunnerResultsPanel3.this._table.getLog();
                    for (n = 0; n < list.size(); ++n) {
                        if (list.get(n) == null) continue;
                        SaveTaskListener.this.logPage.log((Object)((String)list.get(n) + System.getProperty("line.separator")));
                    }
                    SaveTaskListener.this.logPage.log((Object)System.getProperty("line.separator"));
                    int n2 = StatementRunnerResultsPanel3.this._table.getNumberOfSaveErrors();
                    n = 1;
                    if (n2 > 0) {
                        n = 0;
                        if (n2 == 1) {
                            SaveTaskListener.this.logPage.log((Object)(MessageFormat.format(ConnectionArb.getString((String)"EDITRS_SING_ERR"), StatementRunnerResultsPanel3.this._table.getDbTableName()) + System.getProperty("line.separator")));
                        } else {
                            SaveTaskListener.this.logPage.log((Object)(MessageFormat.format(ConnectionArb.getString((String)"EDITRS_PLUR_ERR"), new Integer(n2), StatementRunnerResultsPanel3.this._table.getDbTableName()) + System.getProperty("line.separator")));
                        }
                        for (int i = 0; i < StatementRunnerResultsPanel3.this._table.getLoadedRowCount(); ++i) {
                            if (!StatementRunnerResultsPanel3.this._table.isRowError(i)) continue;
                            SaveTaskListener.this.logPage.log((Object)MessageFormat.format(ConnectionArb.getString((String)"EDITRS_ROW_ERR"), new Integer(i + 1), StatementRunnerResultsPanel3.this._table.getErrorMessage(i)));
                        }
                    }
                    StatementRunnerResultsPanel3.this.requestFocusInWindow();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

