/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.internal.SimpleRaptorTaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.worksheet.AbstractWorksheetResultPanel;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetTaskResultPanel;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;

public abstract class AbstractWorksheetTaskResultPanel
extends AbstractWorksheetResultPanel
implements WorksheetTaskResultPanel {
    private LockableUI lockableUI;
    private JPanel _statusPanel = new JPanel(new BorderLayout());
    private JLabel _statusLabel = new JLabel();
    private ITaskViewer _taskViewer = new GridToolbarTaskViewer();
    private Map<RaptorTaskDescriptor, ITaskUI> _descUIMap = new HashMap<RaptorTaskDescriptor, ITaskUI>();
    private ResultsPanelTaskListener _taskListener = null;

    protected abstract void createErrorComp(Throwable var1);

    protected abstract Icon getRunningIcon();

    protected abstract Icon getWaitingIcon();

    protected abstract Icon getRanOKIcon();

    @Override
    public abstract Icon getTabIcon();

    public abstract void setTabIcon(Icon var1);

    public ResultsPanelTaskListener getTaskListener() {
        if (this._taskListener == null) {
            this._taskListener = new ResultsPanelTaskListener();
        }
        return this._taskListener;
    }

    float getFetchTime(RaptorTaskEvent raptorTaskEvent) {
        long l = raptorTaskEvent.getTaskDescriptor().getElapsedTime();
        float f = 0.0f;
        if (l > 0L) {
            f = Float.parseFloat(l + "") / 1000.0f;
        }
        return f;
    }

    private void updateToolbarActions(boolean bl) {
        Action[] actionArray;
        for (Action action : actionArray = this._toolbar.getActions()) {
            if (action == null) continue;
            action.setEnabled(bl);
        }
    }

    public LockableUI getLockableUI() {
        return this.lockableUI;
    }

    public void setLockableUI(LockableUI lockableUI) {
        this.lockableUI = lockableUI;
    }

    public JPanel getStatusPanel() {
        return this._statusPanel;
    }

    public void setStatusPanel(JPanel jPanel) {
        this._statusPanel = jPanel;
    }

    public JLabel getStatusLabel() {
        return this._statusLabel;
    }

    public void setStatusLabel(JLabel jLabel) {
        this._statusLabel = jLabel;
    }

    @Override
    public ITaskViewer getTaskViewer() {
        return this._taskViewer;
    }

    public void setTaskViewer(ITaskViewer iTaskViewer) {
        this._taskViewer = iTaskViewer;
    }

    public Map<RaptorTaskDescriptor, ITaskUI> getDescUIMap() {
        return this._descUIMap;
    }

    public void setDescUIMap(Map<RaptorTaskDescriptor, ITaskUI> map) {
        this._descUIMap = map;
    }

    protected final class GridToolbarTaskViewer
    implements ITaskViewer {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTaskUI(ITaskUI iTaskUI) {
            JPanel jPanel = AbstractWorksheetTaskResultPanel.this._statusPanel;
            synchronized (jPanel) {
                AbstractWorksheetTaskResultPanel.this._statusLabel.setText("");
                AbstractWorksheetTaskResultPanel.this._statusPanel.remove(AbstractWorksheetTaskResultPanel.this._statusLabel);
                AbstractWorksheetTaskResultPanel.this._statusPanel.add(iTaskUI.getPanel(), "West");
                AbstractWorksheetTaskResultPanel.this._statusPanel.setPreferredSize(iTaskUI.getPanel().getMinimumSize());
                AbstractWorksheetTaskResultPanel.this._statusPanel.setVisible(true);
                View.updateToolbarActions((Toolbar)AbstractWorksheetTaskResultPanel.this._toolbar);
                AbstractWorksheetTaskResultPanel.this._toolbar.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ITaskUI createTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
            SimpleRaptorTaskUI simpleRaptorTaskUI = new SimpleRaptorTaskUI(raptorTaskDescriptor);
            JPanel jPanel = AbstractWorksheetTaskResultPanel.this._statusPanel;
            synchronized (jPanel) {
                AbstractWorksheetTaskResultPanel.this._descUIMap.put(raptorTaskDescriptor, simpleRaptorTaskUI);
            }
            return simpleRaptorTaskUI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ITaskUI getTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
            JPanel jPanel = AbstractWorksheetTaskResultPanel.this._statusPanel;
            synchronized (jPanel) {
                Component[] componentArray;
                ITaskUI iTaskUI = (ITaskUI)AbstractWorksheetTaskResultPanel.this._descUIMap.get(raptorTaskDescriptor);
                for (Component component : componentArray = AbstractWorksheetTaskResultPanel.this._statusPanel.getComponents()) {
                    if (component != iTaskUI) continue;
                    return iTaskUI;
                }
            }
            return null;
        }

        public void taskCancelRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
            ITaskUI iTaskUI = this.getTaskUI(raptorTaskDescriptor);
            if (iTaskUI != null) {
                iTaskUI.cancelClicked(raptorTaskDescriptor);
            }
        }

        public void taskPauseRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
            ITaskUI iTaskUI = this.getTaskUI(raptorTaskDescriptor);
            if (iTaskUI != null) {
                iTaskUI.pauseClicked(raptorTaskDescriptor);
            }
        }
    }

    protected final class ResultsPanelTaskListener
    extends RaptorTaskAdapter {
        protected ResultsPanelTaskListener() {
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            AbstractWorksheetTaskResultPanel.this.setTabIcon(AbstractWorksheetTaskResultPanel.this.getWaitingIcon());
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AbstractWorksheetTaskResultPanel.this.updateToolbarActions(false);
                    AbstractWorksheetTaskResultPanel.this.lockableUI.setLocked(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskRunning(RaptorTaskEvent raptorTaskEvent) {
            AbstractWorksheetTaskResultPanel.this.setTabIcon(AbstractWorksheetTaskResultPanel.this.getRunningIcon());
        }

        public void taskPaused(RaptorTaskEvent raptorTaskEvent) {
            AbstractWorksheetTaskResultPanel.this.setTabIcon(AbstractWorksheetTaskResultPanel.this.getWaitingIcon());
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent);
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent);
        }

        public void taskFinished(final RaptorTaskEvent raptorTaskEvent) {
            if (raptorTaskEvent.getTaskDescriptor().isCancelled()) {
                this.showError(raptorTaskEvent);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        AbstractWorksheetTaskResultPanel.this.updateToolbarActions(true);
                        AbstractWorksheetTaskResultPanel.this.lockableUI.setLocked(false);
                        AbstractWorksheetTaskResultPanel.this.setTabIcon(AbstractWorksheetTaskResultPanel.this.getRanOKIcon());
                        ResultsPanelTaskListener.this.removeTask(raptorTaskEvent);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }

        private void showError(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AbstractWorksheetTaskResultPanel.this.updateToolbarActions(true);
                    ResultsPanelTaskListener.this.removeTask(raptorTaskEvent);
                    AbstractWorksheetTaskResultPanel.this.lockableUI.setLocked(false);
                    AbstractWorksheetTaskResultPanel.this.createErrorComp(raptorTaskEvent.getThrowable());
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        private void removeTask(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JPanel jPanel = AbstractWorksheetTaskResultPanel.this._statusPanel;
                    synchronized (jPanel) {
                        RaptorTaskDescriptor raptorTaskDescriptor = raptorTaskEvent.getTaskDescriptor();
                        if (!IRaptorTaskStatus.isAlive((IRaptorTaskStatus)raptorTaskDescriptor.getStatus())) {
                            ITaskUI iTaskUI = AbstractWorksheetTaskResultPanel.this._taskViewer.getTaskUI(raptorTaskDescriptor);
                            if (iTaskUI != null) {
                                AbstractWorksheetTaskResultPanel.this._statusPanel.remove(iTaskUI.getPanel());
                            }
                            AbstractWorksheetTaskResultPanel.this._descUIMap.remove(raptorTaskDescriptor);
                            AbstractWorksheetTaskResultPanel.this._statusPanel.add(Box.createHorizontalStrut(5));
                            AbstractWorksheetTaskResultPanel.this._statusPanel.add(AbstractWorksheetTaskResultPanel.this._statusLabel);
                            this.updateTimer(raptorTaskEvent);
                            View.updateToolbarActions((Toolbar)AbstractWorksheetTaskResultPanel.this._toolbar);
                            AbstractWorksheetTaskResultPanel.this._toolbar.revalidate();
                            AbstractWorksheetTaskResultPanel.this._toolbar.repaint();
                        }
                    }
                }

                private void updateTimer(RaptorTaskEvent raptorTaskEvent2) {
                    Float f = new Float(AbstractWorksheetTaskResultPanel.this.getFetchTime(raptorTaskEvent2));
                    Object[] objectArray = new Object[]{raptorTaskEvent2.getTaskDescriptor().getMessage(), f};
                    String string = MessageFormat.format(Messages.getString("Worksheet.6"), objectArray);
                    AbstractWorksheetTaskResultPanel.this._statusLabel.setText(string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

