/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.ui;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.controls.ConnectionImportExportPanel;
import oracle.jdevimpl.vcs.svn.AlreadyExistsException;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.repos.io.ObjectFactory;
import oracle.jdevimpl.vcs.svn.repos.io.SvnRepositories;
import oracle.jdevimpl.vcs.svn.repos.io.SvnRepositoryType;
import oracle.jdevimpl.vcs.svn.util.SVNReposInfoListRenderer;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;

public class SVNRepositoryImportExportPanel
extends ConnectionImportExportPanel {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNRepositoryImportExportPanel.class.getName());
    private final ResourcePicker _res;

    public SVNRepositoryImportExportPanel() {
        this.setConnectionsCellRenderer(new SVNReposInfoListRenderer());
        this._res = ResourcePicker.getPicker(SVNProfile.class);
    }

    protected Object[] getExportableConnections() {
        SVNRepositoryManager reposMgr = SVNRepositoryManager.getInstance();
        if (!reposMgr.isEmpty()) {
            Collection connections = reposMgr.list();
            ArrayList exportables = new ArrayList(connections.size() * 2);
            Iterator it = connections.iterator();
            while (it.hasNext()) {
                exportables.add(it.next());
            }
            return exportables.toArray(new Object[exportables.size()]);
        }
        return new Object[0];
    }

    protected boolean exportConnections(String filename) {
        try {
            Object[] selectedConnections = this.getSelectedConnections();
            if (selectedConnections != null && selectedConnections.length > 0) {
                ObjectFactory of = new ObjectFactory();
                SvnRepositories repositories = of.createSvnRepositories();
                for (int i = 0; i < selectedConnections.length; ++i) {
                    repositories.getSvnRepository().add(SVNUtil.toReposType((SVNRepositoryInfo)selectedConnections[i], of));
                }
                JAXBContext ioContext = JAXBContext.newInstance((String)"oracle.jdevimpl.vcs.svn.repos.io", (ClassLoader)Thread.currentThread().getContextClassLoader());
                Marshaller ioWorker = ioContext.createMarshaller();
                ioWorker.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                ioWorker.marshal((Object)repositories, (OutputStream)new FileOutputStream(filename));
            }
            return true;
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "failed to marshall repository connections", e);
            return false;
        }
    }

    protected void filenameChanged(String filename) {
        File sourceFile = new File(filename);
        if (!this.isImportMode() || !sourceFile.exists()) {
            return;
        }
        try {
            JAXBContext ioContext = JAXBContext.newInstance((String)"oracle.jdevimpl.vcs.svn.repos.io", (ClassLoader)Thread.currentThread().getContextClassLoader());
            Unmarshaller ioWorker = ioContext.createUnmarshaller();
            ioWorker.setValidating(false);
            SvnRepositories repositories = (SvnRepositories)ioWorker.unmarshal(sourceFile);
            List reposList = repositories.getSvnRepository();
            if (reposList == null || reposList.isEmpty()) {
                this.setConnections(new Object[0]);
            } else {
                ArrayList<SVNRepositoryInfo> c = new ArrayList<SVNRepositoryInfo>(reposList.size() * 2);
                Iterator it = reposList.iterator();
                while (it.hasNext()) {
                    c.add(SVNUtil.toReposInfo((SvnRepositoryType)it.next()));
                }
                this.setConnections(c.toArray(new Object[c.size()]));
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "failed to unmarshall repository connections", e);
        }
    }

    protected boolean importConnections() {
        Object[] selected = this.getSelectedConnections();
        if (selected != null && selected.length > 0) {
            SVNRepositoryNavigatorAPI api = SVNRepositoryNavigatorAPI.getInstance();
            for (int i = 0; i < selected.length; ++i) {
                SVNRepositoryInfo reposInfo = null;
                try {
                    reposInfo = (SVNRepositoryInfo)selected[i];
                    api.createRepositoryConnection(reposInfo);
                    continue;
                }
                catch (ClassCastException cce) {
                    sLogger.warning("cannot import repository connection object of type " + selected[i].getClass().getName());
                    continue;
                }
                catch (AlreadyExistsException aee) {
                    SVNRepositoryNode existingNode;
                    if (!this.confirmOverwrite(reposInfo) || (existingNode = api.getRepositoryNode(reposInfo.getURL())) == null) continue;
                    try {
                        api.removeRepositoryConnection(existingNode);
                        api.createRepositoryConnection(reposInfo);
                        continue;
                    }
                    catch (AlreadyExistsException aae2) {
                        throw new IllegalStateException(reposInfo.getURL().toString());
                    }
                }
            }
        }
        return true;
    }

    protected void setURLChooserFilter(URLChooser urc, URLFilter filter) {
        URLFilter[] filters = urc.getChooseableURLFilters();
        URLFilter xmlFilter = null;
        for (int i = 0; i < filters.length; ++i) {
            if (!filters[i].accept(URLFactory.newFileURL((String)"*.xml"))) continue;
            xmlFilter = filters[i];
        }
        urc.setURLFilter(xmlFilter);
    }

    private boolean confirmOverwrite(SVNRepositoryInfo reposInfo) {
        return MessageDialog.confirm((Component)((Object)this), (Object)this._res.getString("REPOS_CONN_IMP_OVERWRITE_CONFIRM_MESSAGE", (Object[])new String[]{reposInfo.getURL().toString()}), (String)this._res.getString("REPOS_CONN_IMP_OVERWRITE_CONFIRM_TITLE"), (String)"f1_confirmoverwriteconnection_html");
    }
}

