/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.NetArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.SVNOperationNewRemoteDir;
import oracle.jdevimpl.vcs.svn.util.SVNRepositoryTreeNode;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRepositoryBrowsePanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final String TRANSIENT_TREE_PATH_KEY = SVNRepositoryBrowsePanel.class.getName() + ".treePath";
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private final Map _treeModels = new HashMap(10);
    private boolean _initialized = false;
    private JScrollPane _treeScroller;
    private JTree _tree;
    private DefaultMutableTreeNode _treeRoot;
    private JLabel _treeLabel;
    private JToolBar _treeToolbar;
    private JButton _newReposDirButton;
    private SVNRepositoryInfo _repoInfo;
    private SVNRepositoryTreeNode _currentSelectedNode;

    public SVNRepositoryBrowsePanel(SVNRepositoryInfo repoInfo) {
        this._repoInfo = repoInfo;
        this.initialize();
        this.reloadTreeNodes(true);
    }

    public void setSelectedPath(SVNUrl destURL) {
        DefaultMutableTreeNode root = this._treeRoot;
        SVNRepositoryTreeNode childNode = this.locateChildNode(destURL, root);
        if (childNode != null) {
            TreePath path = new TreePath(childNode.getPath());
            this._tree.setSelectionPath(path);
            this._tree.scrollPathToVisible(path.getParentPath());
        }
    }

    private SVNRepositoryTreeNode locateChildNode(SVNUrl destURL, DefaultMutableTreeNode parent) {
        String[] pathSegs = destURL.getPathSegments();
        block0: for (int i = 0; i < pathSegs.length; ++i) {
            Enumeration<TreeNode> children = parent.children();
            if (children == DefaultMutableTreeNode.EMPTY_ENUMERATION) {
                return null;
            }
            while (children.hasMoreElements()) {
                SVNRepositoryTreeNode child = (SVNRepositoryTreeNode)children.nextElement();
                if (!child.getURL().getLastPathSegment().equals(pathSegs[i])) continue;
                parent = child;
                continue block0;
            }
        }
        return parent instanceof SVNRepositoryTreeNode ? (SVNRepositoryTreeNode)parent : null;
    }

    public SVNUrl getSelectedPathURL() {
        return ((SVNRepositoryTreeNode)this._tree.getSelectionPath().getLastPathComponent()).getURL();
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
        this._initialized = true;
    }

    private void reloadTreeNodes(boolean contactRepos) {
        this._treeRoot.removeAllChildren();
        if (contactRepos) {
            this._treeModels.put(this._repoInfo, null);
        }
        Iterator it = this.getNodeModel(this._repoInfo).iterator();
        while (it.hasNext()) {
            this._treeRoot.add((MutableTreeNode)it.next());
        }
        ((DefaultTreeModel)this._tree.getModel()).reload(this._treeRoot);
    }

    private void createComponents() {
        this._treeRoot = new DefaultMutableTreeNode("root");
        this._tree = new JTree(this._treeRoot);
        this._tree.setVisibleRowCount(10);
        this._tree.setRootVisible(true);
        this._tree.setShowsRootHandles(true);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (!(value instanceof SVNRepositoryTreeNode)) {
                    this.setIcon(SVNRepositoryBrowsePanel.this._res.getImage("NAV_ICON_REPOSITORY_NODE"));
                }
                return this;
            }
        });
        this._treeLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._treeLabel, (Component)this._tree, (String)this._res.getString("IMPORT_UI_REPOS_CONNECTION"));
        this._treeScroller = new JScrollPane(this._tree);
        this._newReposDirButton = new JButton(NetArb.getIcon((int)37));
        this._newReposDirButton.setMargin(new Insets(1, 1, 1, 1));
        this._newReposDirButton.setToolTipText(this._res.getString("IMPORT_UI_CREATE_REMOTE_FOLDER_TOOLTIP"));
        this._newReposDirButton.setFocusable(true);
        this._treeToolbar = new JToolBar(0);
        this._treeToolbar.setBorder(BorderFactory.createEmptyBorder());
        this._treeToolbar.setFloatable(false);
        this._treeToolbar.setRollover(true);
        this._treeToolbar.add(this._newReposDirButton);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add(this._treeLabel, this.gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 3, 0), 0, 0));
        this.add(this._treeToolbar, this.gbc(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 3, 0), 0, 0));
        this.add(this._treeScroller, this.gbc(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext ctx) {
        this.initialize();
    }

    public void onExit(TraversableContext ctx) throws TraversalException {
    }

    private Collection getNodeModel(SVNRepositoryInfo repos) {
        Collection nodeModel = (Collection)this._treeModels.get(repos);
        if (nodeModel == null) {
            try {
                nodeModel = this.generateNodeModel(repos);
                this._treeModels.put(repos, nodeModel);
            }
            catch (SVNClientException ce) {
                nodeModel = Collections.EMPTY_LIST;
            }
        }
        return nodeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection generateNodeModel(SVNRepositoryInfo repos) throws SVNClientException {
        ArrayList arrayList;
        SVNRepositoryTreeNode virtualRoot;
        this._currentSelectedNode = virtualRoot = new SVNRepositoryTreeNode(repos, SVNNodeKind.DIR, repos.getURL(), "/", 0, SVNUtil.getIDEClientAdapter());
        ArrayList nodes = new ArrayList(20);
        final WaitCursor wc = new WaitCursor((Component)((Object)this));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                wc.show(500);
            }
        });
        try {
            Enumeration children = virtualRoot.children();
            while (children.hasMoreElements()) {
                nodes.add(children.nextElement());
            }
            arrayList = nodes;
        }
        catch (Throwable throwable) {
            EventQueue.invokeLater(new Runnable(wc){
                final /* synthetic */ WaitCursor val$wc;
                {
                    this.val$wc = waitCursor;
                }

                @Override
                public void run() {
                    this.val$wc.hide();
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        return arrayList;
    }

    private void initListeners() {
        this._newReposDirButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._newReposDirButton) {
            TreeNode selectedNode;
            SVNUrl parent = this._repoInfo.getURL();
            TreePath selectedPath = this._tree.getSelectionPath();
            DefaultMutableTreeNode parentNode = this._treeRoot;
            if (selectedPath != null && (selectedNode = (TreeNode)selectedPath.getLastPathComponent()) != this._treeRoot) {
                SVNRepositoryTreeNode svnNode = (SVNRepositoryTreeNode)selectedNode;
                parent = svnNode.getURL();
                parentNode = svnNode;
            }
            SVNOperationNewRemoteDir command = new SVNOperationNewRemoteDir(this._repoInfo, parent, (Component)((Object)this), false);
            Context context = Context.newIdeContext();
            command.setContext(context);
            try {
                CommandProcessor.getInstance().invoke((Command)command);
                String newDir = (String)context.getProperty(SVNOperationNewRemoteDir.DIR_NAME_PROP_KEY);
                if (newDir != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Ide.getWaitCursor().show(500);
                        }
                    });
                    if (parentNode instanceof SVNRepositoryTreeNode) {
                        ((SVNRepositoryTreeNode)parentNode).repopulate();
                        ((DefaultTreeModel)this._tree.getModel()).reload(parentNode);
                        Enumeration<TreeNode> childNodes = parentNode.children();
                        this.selectChildNode(newDir, childNodes);
                    } else {
                        this.reloadTreeNodes(true);
                        Enumeration<TreeNode> childNodes = this._treeRoot.children();
                        this.selectChildNode(newDir, childNodes);
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Ide.getWaitCursor().hide();
                        }
                    });
                }
            }
            catch (Exception commandException) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(commandException.getMessage());
            }
        }
    }

    private void selectChildNode(String newDir, Enumeration childNodes) {
        while (childNodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)childNodes.nextElement();
            if (!newDir.equals(node.getUserObject())) continue;
            this._tree.setSelectionPath(new TreePath(node.getPath()));
        }
    }
}

