/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.ui.BasicCheckoutPanel;
import oracle.jdevimpl.vcs.svn.op.ui.CheckoutInfo;
import oracle.jdevimpl.vcs.svn.op.ui.ValidatedPanel;
import oracle.jdevimpl.vcs.svn.util.SVNReposInfoComboBoxRenderer;
import oracle.jdevimpl.vcs.svn.util.SVNRepositoryTreeNode;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public class FullCheckoutPanel
extends ValidatedPanel
implements CheckoutInfo,
ActionListener,
TreeSelectionListener {
    private final ISVNClientAdapter _client;
    private final Map _rootNodes = new HashMap(20);
    private DefaultMutableTreeNode _treeVirtualRoot;
    private JLabel _reposLabel;
    private JComboBox _reposList;
    private JLabel _treeLabel;
    private JTree _tree;
    private JScrollPane _treeScroller;
    private BasicCheckoutPanel _basicPanel;
    private URL _baseUrl;
    boolean _hasSelectedTreeNode = true;
    boolean _basicPanelValidationResult = false;

    public FullCheckoutPanel(Collection reposInfos, URL checkoutBase, ISVNClientAdapter client) {
        super(new GridBagLayout());
        this._client = client;
        this._baseUrl = checkoutBase;
        this.createComponents(reposInfos);
        this.layoutComponents();
        this.listen();
        this.selectTreeRoot();
    }

    @Override
    public SVNRepositoryInfo getRepositoryInfo() {
        return (SVNRepositoryInfo)this._reposList.getSelectedItem();
    }

    @Override
    public SVNUrl getSourceURL() {
        if (this._tree.getSelectionPath() == null) {
            return null;
        }
        SVNRepositoryTreeNode selectedNode = (SVNRepositoryTreeNode)this._tree.getSelectionPath().getLastPathComponent();
        SVNUrl selectedUrl = selectedNode.getURL();
        SVNUrl reposUrl = this.getRepositoryInfo().getURL();
        if (SVNUrlUtils.getCommonRootUrl((SVNUrl)reposUrl, (SVNUrl)selectedUrl) == null) {
            throw new IllegalStateException(reposUrl.toString() + ", " + selectedUrl.toString());
        }
        return selectedUrl;
    }

    @Override
    public URL getDestinationURL() {
        return this._basicPanel.getDestinationURL();
    }

    @Override
    public SVNRevision getRevision() {
        return this._basicPanel.getRevision();
    }

    @Override
    public int getDepth() {
        return this._basicPanel.getDepth();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this._reposList) {
            SVNRepositoryInfo repos = (SVNRepositoryInfo)this._reposList.getSelectedItem();
            this._treeVirtualRoot.remove(0);
            this._treeVirtualRoot.add(this.getRootNode(repos));
            ((FilteredTreeModel)this._tree.getModel()).reload(this._treeVirtualRoot);
            this._basicPanel.setDestinationURL(this._baseUrl);
            this.selectTreeRoot();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        boolean isRoot;
        SVNUrl source;
        SVNRepositoryTreeNode selectedNode = (SVNRepositoryTreeNode)this._tree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            return;
        }
        URL suggested = SVNUtil.suggestCheckoutDestination(this._baseUrl, source, isRoot, (isRoot = (source = selectedNode.getURL()).equals((Object)selectedNode.getParentRepository().getURL())) ? selectedNode.getParentRepository().getAlias() : null);
        this._basicPanel.setDestinationURL(suggested);
    }

    private void createComponents(Collection reposInfos) {
        ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
        this._reposList = new JComboBox<SVNRepositoryInfo>(reposInfos.toArray(new SVNRepositoryInfo[reposInfos.size()]));
        this._reposList.setRenderer(new SVNReposInfoComboBoxRenderer());
        this._reposList.setSelectedIndex(0);
        this._reposLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._reposLabel, (Component)this._reposList, (String)res.getString("UI_FULL_CHECKOUT_PANEL_LABEL_REPOS"));
        this._treeVirtualRoot = new DefaultMutableTreeNode();
        FilteredTreeModel model = new FilteredTreeModel(new DefaultTreeModel(this._treeVirtualRoot));
        this._tree = new JTree(model);
        this._tree.setVisibleRowCount(10);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.getSelectionModel().setSelectionMode(1);
        SVNRepositoryTreeNode rootNode = this.getRootNode((SVNRepositoryInfo)this._reposList.getSelectedItem());
        this._treeVirtualRoot.add(rootNode);
        model.reload(this._treeVirtualRoot);
        this._treeLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._treeLabel, (Component)this._tree, (String)res.getString("UI_FULL_CHECKOUT_PANEL_LABEL_TREE"));
        this._treeScroller = new JScrollPane(this._tree);
        this._basicPanel = new BasicCheckoutPanel(null, null, this._baseUrl);
    }

    private void layoutComponents() {
        this.add((Component)this._reposLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)this._reposList, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 90, 0));
        this.add((Component)this._treeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 3, 0), 0, 0));
        this.add((Component)this._treeScroller, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this._basicPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 16, 1, new Insets(5, 0, 2, 0), 0, 0));
    }

    private void listen() {
        this._reposList.addActionListener(this);
        this._basicPanel.addBCPListener(new BasicCheckoutPanel.Listener(){

            @Override
            public void newURLChosen(URL newUrl) {
                FullCheckoutPanel.this._baseUrl = newUrl;
            }
        });
        this._tree.addTreeSelectionListener(this);
        this._tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                FullCheckoutPanel.this.setWaitingCursor(true);
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
            }
        });
        this._tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                FullCheckoutPanel.this.setWaitingCursor(false);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.initListeners();
    }

    private void setWaitingCursor(boolean isWaiting) {
        int cursorType = isWaiting ? 3 : 0;
        Cursor c = Cursor.getPredefinedCursor(cursorType);
        this.setCursor(c);
    }

    private void selectTreeRoot() {
        TreePath rootpath = new TreePath(new Object[]{this._tree.getModel().getRoot(), this.getRootNode(this.getRepositoryInfo())});
        this._tree.setSelectionPath(rootpath);
        this._tree.scrollPathToVisible(rootpath);
    }

    private SVNRepositoryTreeNode getRootNode(SVNRepositoryInfo reposInfo) {
        String key = reposInfo.getURL().toString();
        SVNRepositoryTreeNode node = (SVNRepositoryTreeNode)this._rootNodes.get(key);
        if (node == null) {
            node = new SVNRepositoryTreeNode(reposInfo, SVNNodeKind.DIR, reposInfo.getURL(), "/", 0, this._client);
            this._rootNodes.put(key, node);
        }
        return node;
    }

    @Override
    public void initListeners() {
        this._basicPanel.addListener(new ValidatedPanel.PanelValidationListener(){

            @Override
            public void onReceiveValidationResult(boolean validationResult) {
                FullCheckoutPanel.this._basicPanelValidationResult = validationResult;
                FullCheckoutPanel.this.fireValidContent(FullCheckoutPanel.this.validateContent());
            }
        });
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                FullCheckoutPanel.this._hasSelectedTreeNode = true;
                SVNRepositoryTreeNode selectedNode = (SVNRepositoryTreeNode)FullCheckoutPanel.this._tree.getLastSelectedPathComponent();
                if (selectedNode == null) {
                    FullCheckoutPanel.this._hasSelectedTreeNode = false;
                }
                FullCheckoutPanel.this.fireValidContent(FullCheckoutPanel.this.validateContent());
            }
        });
    }

    @Override
    public boolean validateContent() {
        return this._hasSelectedTreeNode && this._basicPanelValidationResult;
    }

    private class FilteredTreeModel
    implements TreeModel {
        private boolean showingLeaves = false;
        private DefaultTreeModel delegate;

        public FilteredTreeModel(DefaultTreeModel delegate) {
            this.delegate = delegate;
        }

        public void setShowingLeaves(boolean show) {
            this.showingLeaves = show;
            this.delegate.reload();
        }

        public boolean isShowingLeaves() {
            return this.showingLeaves;
        }

        @Override
        public Object getChild(Object parent, int index) {
            Object child = this.delegate.getChild(parent, index);
            if (!this.isShowingLeaves() && this.delegate.isLeaf(child)) {
                child = null;
            }
            return child;
        }

        @Override
        public int getChildCount(Object parent) {
            int count = this.delegate.getChildCount(parent);
            if (!this.showingLeaves) {
                int newCount = count;
                for (int i = 0; i < count; ++i) {
                    if (!this.delegate.isLeaf(this.delegate.getChild(parent, i))) continue;
                    --newCount;
                }
                count = newCount;
            }
            return count;
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            int index = this.delegate.getIndexOfChild(parent, child);
            if (!this.showingLeaves && this.delegate.isLeaf(child)) {
                index = -1;
            }
            return index;
        }

        public void reload(TreeNode node) {
            this.delegate.reload(node);
        }

        @Override
        public Object getRoot() {
            return this.delegate.getRoot();
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.delegate.isLeaf(node);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            this.delegate.valueForPathChanged(path, newValue);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.delegate.addTreeModelListener(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.delegate.removeTreeModelListener(l);
        }
    }
}

