/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.ui.CheckoutInfo;
import oracle.jdevimpl.vcs.svn.op.ui.DepthOperationPanel;
import oracle.jdevimpl.vcs.svn.op.ui.ValidatedPanel;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class BasicCheckoutPanel
extends ValidatedPanel
implements CheckoutInfo,
ActionListener {
    private final Collection _listeners = new ArrayList(10);
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private final SVNRepositoryInfo _reposInfo;
    private final SVNUrl _sourceUrl;
    private final URL _defaultDestination;
    private JLabel _destLabel;
    private FileField _destField;
    private JButton _browseButton;
    private JCheckBox _revisionCheckbox;
    private JTextField _revisionField;
    private DepthOperationPanel _depthPanel;

    public BasicCheckoutPanel(SVNRepositoryInfo reposInfo, SVNUrl sourceUrl, URL defaultDestination) {
        super(new GridBagLayout());
        this._reposInfo = reposInfo;
        this._sourceUrl = sourceUrl;
        this._defaultDestination = defaultDestination;
        this.createComponents(defaultDestination);
        this.layoutComponents();
        this.listen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBCPListener(Listener listener) {
        Collection collection = this._listeners;
        synchronized (collection) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBCPListener(Listener listener) {
        Collection collection = this._listeners;
        synchronized (collection) {
            this._listeners.remove(listener);
        }
    }

    @Override
    public SVNRepositoryInfo getRepositoryInfo() {
        return this._reposInfo;
    }

    @Override
    public SVNUrl getSourceURL() {
        return this._sourceUrl;
    }

    @Override
    public URL getDestinationURL() {
        return URLFileSystem.canonicalize((URL)URLFactory.newDirURL((String)this._destField.getText()));
    }

    public void setDestinationURL(URL dest) {
        this._destField.setText(URLFileSystem.getPlatformPathName((URL)dest));
    }

    @Override
    public SVNRevision getRevision() {
        String revisionText;
        if (this._revisionCheckbox.isSelected() && (revisionText = this._revisionField.getText()) != null && revisionText.length() > 0) {
            try {
                return SVNRevision.getRevision((String)this._revisionField.getText());
            }
            catch (ParseException pe) {
                return SVNRevision.INVALID_REVISION;
            }
        }
        return SVNRevision.HEAD;
    }

    @Override
    public int getDepth() {
        return this._depthPanel.getDepthSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        Object source = e.getSource();
        if (source == this._revisionCheckbox) {
            this._revisionField.setEnabled(this._revisionCheckbox.isSelected());
        } else if (source == this._browseButton) {
            this.chooseNewDirectory();
            this.fireNewURLChosen(this.getDestinationURL());
        }
    }

    private void chooseNewDirectory() {
        URL currentUrl = URLFactory.newURL((String)this._destField.getText());
        if (!URLFileSystem.exists((URL)currentUrl)) {
            currentUrl = this._defaultDestination;
        }
        URLChooser chooser = DialogUtil.newURLChooser((URL)currentUrl);
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(1);
        if (chooser.showOpenDialog((Component)this) == 0) {
            this._destField.setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
        }
    }

    private void createComponents(URL defaultUrl) {
        this._destField = new FileField(true);
        this._destLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._destLabel, (Component)this._destField, (String)this._res.getString("UI_BASIC_CHECKOUT_PANEL_LABEL_DESTINATION"));
        this._destField.setText(URLFileSystem.getPlatformPathName((URL)defaultUrl));
        this._browseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._browseButton, (String)this._res.getString("UI_BASIC_CHECKOUT_PANEL_LABEL_BROWSE"));
        this._revisionCheckbox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._revisionCheckbox, (String)this._res.getString("UI_BASIC_CHECKOUT_PANEL_LABEL_REVISION"));
        this._revisionField = new JTextField();
        this._revisionCheckbox.setSelected(false);
        this._revisionField.setEnabled(false);
        this._depthPanel = new DepthOperationPanel();
    }

    private void layoutComponents() {
        this.add((Component)this._destLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 3, 5), 0, 0));
        this.add((Component)this._destField, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 150, 0));
        this.add((Component)this._browseButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this._revisionCheckbox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this._revisionField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this._depthPanel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
    }

    private void listen() {
        this._revisionCheckbox.addActionListener(this);
        this._browseButton.addActionListener(this);
        this.initListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNewURLChosen(URL newUrl) {
        Collection collection = this._listeners;
        synchronized (collection) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((Listener)it.next()).newURLChosen(newUrl);
            }
        }
    }

    @Override
    public void initListeners() {
        this._destField.getDocument().addDocumentListener(new ValidatedPanel.FieldListener(this));
        this._revisionField.getDocument().addDocumentListener(new ValidatedPanel.FieldListener(this));
        this._revisionCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicCheckoutPanel.this.fireValidContent(BasicCheckoutPanel.this.validateContent());
            }
        });
    }

    @Override
    public boolean validateContent() {
        boolean destfieldResult = !this._destField.getText().equals("") && URLFileSystem.isDirectoryPath((URL)this.getDestinationURL());
        boolean revisionfieldResult = true;
        if (this._revisionCheckbox.isSelected() && (this._revisionField.getText() == null || this._revisionField.getText().length() == 0 || this.getRevision().equals((Object)SVNRevision.INVALID_REVISION))) {
            revisionfieldResult = false;
        }
        return destfieldResult && revisionfieldResult;
    }

    public static interface Listener {
        public void newURLChosen(URL var1);
    }
}

