/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizard;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.MergePanel;
import oracle.jdevimpl.vcs.svn.op.ui.MonitoredPanel;
import oracle.jdevimpl.vcs.svn.prefs.SVNVersionToolsPreferences;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNOperationMerge
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.merge";
    private MergePanel _mergePanel;
    private JEWTDialog _dialog;
    private ISVNInfo _wcInfo;

    public SVNOperationMerge() {
        super(COMMAND_ID);
    }

    public SVNOperationMerge(String commandID) {
        super(commandID);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        boolean useMergeTracking;
        VCSPropertyMap vtoolsPrefs = profile.getData("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
        boolean bl = useMergeTracking = (Boolean)vtoolsPrefs.getMap().get("svnMergeTracking") != null ? ((Boolean)vtoolsPrefs.getMap().get("svnMergeTracking")).booleanValue() : SVNVersionToolsPreferences.DEFAULT_KEY_USE_MEREGE_TRACKING.booleanValue();
        if (useMergeTracking) {
            SVNMergeWizard wizard = new SVNMergeWizard();
            if (wizard.runWizard(VCSWindowUtils.getCurrentWindow(), this.getContext())) {
                return 1;
            }
            return 1;
        }
        this._wcInfo = this.getWCInfo();
        if (this._wcInfo == null) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)this._res.getString("ACTION_BRANCH_ERROR_MESSAGE_NO_INFO"), (String)this._res.getString("ACTION_BRANCH_ERROR_TITLE_NO_INFO"), null);
            return 1;
        }
        this.createPanel();
        this.createDialog();
        this.initListeners();
        this.initPanel();
        if (this._dialog.runDialog()) {
            return 0;
        }
        return 1;
    }

    private void initPanel() {
        this._mergePanel.setToField(this.getFromURLString());
        this._mergePanel.setFromField(this.getFromURLString());
        this._mergePanel.setContext(this.getContext());
        this._mergePanel.setApplyWCField(this.getCurrentWC());
        this._mergePanel.fireValidContent(this._mergePanel.validateContent());
    }

    private String getCurrentWC() {
        if (this._wcInfo != null) {
            return this._wcInfo.getFile().toString();
        }
        return null;
    }

    private void setOKButton(final boolean containsValidContent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SVNOperationMerge.this._dialog.setOKButtonEnabled(containsValidContent);
            }
        });
    }

    private ISVNInfo getWCInfo() {
        Node node = this.getContext().getNode();
        URL url = null;
        File file = null;
        if (node != null) {
            url = node.getURL();
            String suffix = URLFileSystem.getSuffix((URL)url);
            if (suffix.equals(".jws") || suffix.equals(".jpr")) {
                url = URLFileSystem.getParent((URL)url);
            }
        } else {
            Element elem = this.getContext().getElement();
            if (elem instanceof RelativeDirectoryContextFolder) {
                url = ((RelativeDirectoryContextFolder)elem).getRootDirectories().getFirstEntry();
            }
        }
        file = SVNUtil.toFile(url);
        ISVNClientAdapter client = null;
        try {
            client = SVNUtil.getIDEClientAdapter();
            ISVNInfo info = client.getInfoFromWorkingCopy(file);
            return info;
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            return null;
        }
    }

    private void createPanel() {
        this._mergePanel = new MergePanel();
    }

    private void createDialog() {
        String title = this._res.getString("ACTION_MERGE_DIALOG_TITLE");
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)this._mergePanel, (Component)this._mergePanel.getInitialFocus(), (String)title, (int)7);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("ACTION_MERGE_DIALOG_HEADER_DESC"));
        this._dialog.setDialogHeader((Component)header);
        this._dialog.setDefaultButton(1);
        this._dialog.setContent((Component)this._mergePanel);
        this._dialog.setResizable(true);
        this._dialog.setMinimumSize(350, 580);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._mergePanel, "f1_svnmerge_html");
    }

    private String getFromURLString() {
        return SVNUtil.canonicalizeSVNUrl(this._wcInfo.getUrl()).toString();
    }

    private void initListeners() {
        this._dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                    return;
                }
                MergeThread mergeThread = new MergeThread();
                mergeThread.start();
            }
        });
        this._mergePanel.addListener(new MonitoredPanel.PanelListener(){

            @Override
            public void setContainsURL(boolean containsValidContent) {
                SVNOperationMerge.this.setOKButton(containsValidContent);
                SVNOperationMerge.this._mergePanel.setTestButtonEnabled(containsValidContent);
            }
        });
    }

    private class MergeThread
    extends Thread {
        IndeterminateProgressMonitor progressMon;
        SVNUrl fromUrl;
        SVNUrl toUrl;
        SVNRevision fromRevision;
        SVNRevision toRevision;
        File destFile;
        boolean isNoAncestry;
        boolean isForce;
        boolean isDryRun;
        boolean isRecurse;

        private MergeThread() {
            super("svn-merge-thread");
            this.isRecurse = true;
        }

        @Override
        public void run() {
            final WaitCursor wc = new WaitCursor(SVNOperationMerge.this._dialog.getContent());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    wc.show();
                }
            });
            this.executeMergingWithProgress();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SVNOperationMerge.this._dialog.setVisible(false);
                    SVNOperationMerge.this._dialog.dispose();
                }
            });
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    wc.hide();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeMergingWithProgress() {
            this.progressMon = new IndeterminateProgressMonitor((Component)SVNOperationMerge.this._dialog, SVNOperationMerge.this._res.getString("ACTION_MERGE_PROGRESS_TITLE"), (Object)SVNOperationMerge.this._res.getString("ACTION_MERGE_PROGRESS_MESSAGE"), null);
            this.progressMon.setMillisToPopup(0);
            this.progressMon.setCloseOnFinish(true);
            this.progressMon.setCancellable(false);
            this.progressMon.start();
            try {
                this.executeMerging();
            }
            finally {
                this.progressMon.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeMerging() {
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(SVNOperationMerge.this._wcInfo.getRepository());
            try {
                this.getParameters();
                ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(svnClient, repoInfo, this.progressMon);
                svnClient.merge(this.fromUrl, this.fromRevision, this.toUrl, this.toRevision, this.destFile, this.isForce, this.isRecurse, this.isDryRun);
                this.refreshNodes();
            }
            catch (SVNClientException e) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(e.getMessage());
            }
            catch (IOException ioe) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).severe(ioe.getMessage());
                MessageDialog.error((Component)SVNOperationMerge.this._dialog, (Object)SVNOperationMerge.this._res.getString("ACTION_MERGE_DEST_NOT_EXIST"), (String)SVNOperationMerge.this._res.getString("ACTION_MERGE_DEST_NOT_EXIST_TITLE"), null);
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
            }
        }

        private void getParameters() throws IOException {
            this.fromUrl = SVNOperationMerge.this._mergePanel.getFromUrl();
            this.fromRevision = SVNOperationMerge.this._mergePanel.getFromRevision();
            this.toUrl = SVNOperationMerge.this._mergePanel.getToUrl();
            this.toRevision = SVNOperationMerge.this._mergePanel.getToRevision();
            this.destFile = SVNOperationMerge.this._mergePanel.getApplyWCFile();
            if (!this.destFile.exists()) {
                throw new IOException();
            }
            this.isNoAncestry = SVNOperationMerge.this._mergePanel.getNoAncestryStatus();
            this.isForce = SVNOperationMerge.this._mergePanel.getForceStatus();
            this.isDryRun = false;
        }

        private void refreshNodes() {
            Context ctx = SVNOperationMerge.this.getContext();
            this.refreshNodes(ctx.getElement());
        }

        private void refreshNodes(Element elem) {
            if (elem != null) {
                if (!elem.mayHaveChildren()) {
                    if (elem instanceof Node && ((Node)elem).isOpen()) {
                        VCSBufferUtils.reloadBuffer((URL)((Node)elem).getURL());
                        return;
                    }
                } else {
                    Iterator it = elem.getChildren();
                    while (it != null && it.hasNext()) {
                        this.refreshNodes((Element)it.next());
                    }
                }
            }
        }
    }
}

