/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.op.SVNOperationAddProperty;
import oracle.jdevimpl.vcs.svn.op.ui.PropertyEditorPanel;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNOperationIgnore
extends SVNOperationAddProperty {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.ignore";
    private URL[] _selectedURLs;

    public SVNOperationIgnore() {
        super(COMMAND_ID);
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        URL[] selectedURLs = this.getSelectedURLs(profile);
        if (selectedURLs == null || selectedURLs.length == 0) {
            return false;
        }
        VCSStatusFilter ignoredFilter = profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.IGNORED");
        VCSStatusCache statusCache = profile.getStatusCache();
        for (URL url : selectedURLs) {
            VCSStatus parentstatus = statusCache.get(URLFileSystem.getParent((URL)url));
            if (!ignoredFilter.accept(parentstatus)) continue;
            return false;
        }
        return this.inSameFolder(selectedURLs);
    }

    @Override
    protected JEWTDialog createDialog() {
        String title = this._res.getString("ACTION_IGNORE_DIALOG_TITLE");
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)this.getPanel(), null, (String)title, (int)7);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("ACTION_IGNORE_DIALOG_HEADER_DESC"));
        dialog.setDialogHeader((Component)header);
        dialog.setDefaultButton(1);
        dialog.setResizable(true);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.getPanel(), "f1_svnignore_html");
        return dialog;
    }

    @Override
    protected PropertyEditorPanel createPanel() {
        this._selectedURLs = this.getSelectedUrls();
        PropertyEditorPanel panel = super.createPanel();
        File resourceFile = SVNUtil.toFile(URLFileSystem.getParent((URL)this._selectedURLs[0]));
        panel.setResourceField(resourceFile);
        panel.setNameComboBoxEditable(false);
        panel.setResourceFieldEditable(false);
        panel.setPropertyName("svn:ignore");
        StringBuffer sb = new StringBuffer();
        String exisitingIgnoredValue = this.getExistingIgnoredValue(resourceFile);
        if (exisitingIgnoredValue != null) {
            sb.append(exisitingIgnoredValue);
            sb.append(" ");
        }
        for (int i = 0; i < this._selectedURLs.length; ++i) {
            sb.append(URLFileSystem.getFileName((URL)this._selectedURLs[i]));
            sb.append(" ");
        }
        panel.setStringPropertyValue(sb.toString().trim());
        panel.hideFileField();
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getExistingIgnoredValue(File resourceFile) {
        String exisitingIgnoredValue = null;
        try {
            ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(svnClient, null);
            ISVNProperty existingProp = svnClient.propertyGet(resourceFile, "svn:ignore");
            if (existingProp != null) {
                exisitingIgnoredValue = existingProp.getValue();
            }
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
            this.getExceptionHandler().handleException(SVNExceptionWrapper.wrapException((Exception)((Object)e)));
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
        return exisitingIgnoredValue;
    }

    private URL[] getSelectedURLs(VCSProfile profile) throws Exception {
        Locatable[] locatables = this.getOperands(profile);
        return VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
    }

    private boolean inSameFolder(URL[] selectedURLs) {
        URL commonParent = URLFileSystem.getParent((URL)selectedURLs[0]);
        for (int i = 1; i < selectedURLs.length; ++i) {
            if (commonParent.equals(URLFileSystem.getParent((URL)selectedURLs[i]))) continue;
            return false;
        }
        return true;
    }
}

