/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOverlayItem;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSRecentCommentsModel;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.ui.CommitOptionsCustomizer;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.NotifyListenerAdapter;
import oracle.jdevimpl.vcs.svn.util.SVNComponents;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.xspi.ALMCommitContext;
import oracle.jdevimpl.vcs.xspi.ALMCommitFile;
import oracle.jdevimpl.vcs.xspi.ALMCommitManager;
import oracle.jdevimpl.vcs.xspi.XVCSCommandState;
import oracle.jdevimpl.vcs.xspi.XVCSComponents;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;

public class SVNOperationCommit
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.commit";
    private static VCSRecentCommentsModel _recentCommentsModel;
    IndeterminateProgressMonitor progress;
    private static final int UPDATE_NOT_NEEDED = 0;
    private static final int UPDATE_SUCCESSFUL = 1;
    private static final int UPDATE_FAILED = 2;
    private static final int UPDATE_CONFLICT = 3;

    public SVNOperationCommit() {
        super(COMMAND_ID);
    }

    SVNOperationCommit(String commandId) {
        super(commandId);
    }

    @Override
    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        if (this.getId() == Ide.findCmdID((String)COMMAND_ID).intValue() && !this.isSilent(this.getContext(), profile)) {
            URL wcRoot;
            URL[] urls = VCSModelUtils.convertNodesToURLs((Locatable[])commandState.getLocatables());
            URL uRL = wcRoot = urls.length > 0 ? SVNUtil.resolveWorkingCopy(urls[0]) : null;
            if (wcRoot != null && !URLFileSystem.equals((URL)wcRoot, (URL)urls[0]) && profile.getStatusCache().get(wcRoot) == profile.getStatusInstance("MODIFIED")) {
                int result = MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)Resource.get("ACTION_COMMIT_CONFIRM_WORKING_COPY_COMMIT"), (String)Resource.get("ACTION_COMMIT_CONFIRM_WORKING_COPY_COMMIT_TITLE"), null, (boolean)false);
                if (result == -1) {
                    return false;
                }
                if (result == 1) {
                    IdeAction.find((int)Ide.findCmdID((String)"oracle.jdeveloper.subversion.commit-workingcopy")).performAction(this.getContext());
                    return true;
                }
            }
        }
        return super.invokeCommand(profile, commandState);
    }

    public static final VCSRecentCommentsModel getRecentCommentsModel() {
        if (_recentCommentsModel == null) {
            _recentCommentsModel = new VCSRecentCommentsModel();
        }
        return _recentCommentsModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState state, Component parentUi, Map options) throws Exception {
        this.progress = new IndeterminateProgressMonitor(parentUi, this._res.getString("ACTION_COMMIT_PROGRESS_TITLE"));
        this.progress.setMillisToPopup(0);
        this.progress.setCloseOnFinish(true);
        this.progress.setCancellable(false);
        this.progress.start();
        try {
            this.invokeCommit(profile, state, options, this.progress);
        }
        finally {
            if (!this.progress.isCancelled()) {
                this.progress.finish();
            }
        }
        return true;
    }

    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        this.invokeCommit(profile, commandState, options, null);
        return true;
    }

    protected CommandState createCommandState() {
        return new XVCSCommandState();
    }

    protected void configureCommandState(CommandState commandState, VCSDirectoryInvokableState invokableState, Map timestamps, Locatable[] locatables) {
        super.configureCommandState(commandState, invokableState, timestamps, locatables);
        URL[] operands = VCSFileSystemUtils.coalesceURLs((URL[])VCSModelUtils.convertNodesToURLs((Locatable[])locatables));
        try {
            SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(operands);
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("url", repos.getURL().toString());
            ((XVCSCommandState)commandState).setALMCommitContext(new ALMCommitContext("oracle.jdeveloper.subversion", criteria));
        }
        catch (SVNClientException svnce) {
            // empty catch block
        }
    }

    protected VCSOptionsCustomizer createOptionsCustomizer(Collection nodes) {
        VCSCommentsCustomizer customizer = new VCSCommentsCustomizer((VCSOptionsCustomizer)new CommitOptionsCustomizer());
        customizer.setShowReuseCommentsOption(false);
        customizer.setRecentCommentsModel(SVNOperationCommit.getRecentCommentsModel());
        customizer.setShowTemplatesAndCommentsCombo(true);
        VCSProfile profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        customizer.setClientSetting(profile.getSettings());
        customizer.setTemplatesDataKey(profile.getQualifiedDataKey("COMMENT_TEMPLATES"));
        customizer.setTemplatesSettingsPath(VCSNavigableUtils.getSystemNavigablePath((String)Resource.get("SVN_SHORT_NAME"), (String[])new String[]{VCSCommentsCustomizer.COMMENT_TEMPLATES_NAVIGABLE_LABEL}));
        customizer.setContextURLs(VCSFileSystemUtils.coalesceURLs((URL[])VCSModelUtils.convertNodesToURLs((Collection)nodes)));
        return customizer;
    }

    @Override
    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        return XVCSComponents.createCommitOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), (String)this.getDialogHint(), (Component)SVNComponents.createFileListerComponent(nodes), (VCSOptionsCustomizer)customizer, (String)this.getHelpTopicId(), (ALMCommitContext)((XVCSCommandState)commandState).getALMCommitContext());
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] loc = super.getOperands(profile);
        return this.createChangeListItems(this.getUrlArray(loc));
    }

    protected boolean saveDirtyNodes(Locatable[] contextLocatables) throws Exception {
        Locatable[] loc = super.getOperands(this.getProfile());
        return VCSCommandUtils.saveDirtyNodes((Locatable[])loc);
    }

    private URL[] getUrlArray(Locatable[] loc) {
        URL[] urls = new URL[loc.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = loc[i].getURL();
        }
        return urls;
    }

    private ChangeListItem[] createChangeListItems(URL[] urls) {
        ChangeListItem[] items = new ChangeListItem[urls.length];
        VCSOverlayItemProducer overlayItemProducer = new VCSOverlayItemProducer(this.getStatusCache());
        for (int i = 0; i < urls.length; ++i) {
            items[i] = this.createChangeListItem(urls[i], overlayItemProducer);
        }
        return items;
    }

    private ChangeListItem createChangeListItem(URL url, VCSOverlayItemProducer overlayItemProducer) {
        VCSOverlayItem overlayItem = null;
        try {
            overlayItem = overlayItemProducer != null ? overlayItemProducer.getOverlayItems(new URL[]{url})[0] : null;
        }
        catch (Exception e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
        }
        return new ChangeListItem(url, overlayItem != null ? overlayItem.getOverlay() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeCommit(VCSProfile profile, CommandState state, Map options, IndeterminateProgressMonitor progress) throws Exception {
        String comment = this.getComments(options);
        boolean keepLocks = this.getKeepLocks(options);
        URL[] operands = VCSFileSystemUtils.coalesceURLs((URL[])VCSModelUtils.convertNodesToURLs((Locatable[])state.getLocatables()));
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(operands);
        if (this.checkUpdate(repos, operands) == 3) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)this._res.getString("ACTION_COMMIT_INTERRUPTED_CONFLICT_MESSAGE"), (String)this._res.getString("ACTION_COMMIT_INTERRUPTED_CONFLICT_TITLE"), null);
            return;
        }
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            if (progress != null) {
                SVNOperationLogger.getInstance().beginOperation(client, repos, progress);
            } else {
                SVNOperationLogger.getInstance().beginOperation(client, repos);
            }
            this.commitParents(profile, client, operands, comment, keepLocks);
            final XVCSCommandState almCommandState = (XVCSCommandState)state;
            ALMCommitContext almCommitContext = almCommandState.getALMCommitContext();
            NotifyListenerAdapter notifyListener = null;
            if (almCommitContext != null && almCommitContext.canCommitToALM()) {
                final SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
                notifyListener = new NotifyListenerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void onNotify(File path, SVNNodeKind nodeKind) {
                        if (!nodeKind.equals((Object)SVNNodeKind.FILE)) {
                            return;
                        }
                        try {
                            wcAccess.open(path.getParentFile(), false, 0);
                            SVNEntry entry = wcAccess.retrieve(path.getParentFile()).getEntry(path.getName(), true);
                            if (entry == null) {
                                return;
                            }
                            String rootUrlStr = entry.getRepositoryRootURL().toString();
                            String urlStr = entry.getSVNURL().toString();
                            if (!rootUrlStr.endsWith("/")) {
                                rootUrlStr = rootUrlStr + '/';
                            }
                            if (!urlStr.startsWith(rootUrlStr)) {
                                return;
                            }
                            ArrayList<ALMCommitFile> almCommitFiles = almCommandState.getALMCommitFiles();
                            if (almCommitFiles == null) {
                                almCommitFiles = new ArrayList<ALMCommitFile>();
                                almCommandState.setALMCommitFiles(almCommitFiles);
                            }
                            almCommitFiles.add(new ALMCommitFile(urlStr.substring(rootUrlStr.length()), null));
                            return;
                        }
                        catch (SVNException svne) {
                            FeedbackManager.reportException((Throwable)svne);
                            return;
                        }
                        finally {
                            try {
                                wcAccess.close();
                            }
                            catch (SVNException sVNException) {}
                        }
                    }
                };
                client.addNotifyListener((ISVNNotifyListener)notifyListener);
            }
            long revision = client.commit(SVNUtil.toFiles(operands), comment, true, keepLocks);
            if (notifyListener != null) {
                client.removeNotifyListener((ISVNNotifyListener)notifyListener);
            }
            if (almCommitContext != null && almCommitContext.canCommitToALM()) {
                String revisionStr = String.valueOf(revision);
                if (almCommandState.getALMCommitFiles() != null) {
                    for (ALMCommitFile almCommitFile : almCommandState.getALMCommitFiles()) {
                        almCommitFile.setRevision(revisionStr);
                    }
                }
                almCommitContext.setVCSRevisionName(revisionStr);
            }
            Collection processed = this.getProcessedUrlsNotifier(state);
            processed.addAll(Arrays.asList(operands));
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
            state.setProperty("oracle.jdeveloper.subversion.RECURSIVE", (Object)Boolean.TRUE);
        }
    }

    @Override
    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        super.postInvoke(profile, commandState);
        ALMCommitManager.getALMCommitManager().executeCommitWorker((XVCSCommandState)commandState);
    }

    protected int checkUpdate(SVNRepositoryInfo repos, URL[] operands) throws SVNClientException, Exception {
        ArrayList<File> updateList = new ArrayList<File>();
        if (this.doCheckUpdate(repos, operands, updateList)) {
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)this._res.getString("ACTION_COMMIT_NEED_UPDATE_MESSAGE"), (String)this._res.getString("ACTION_COMMIT_NEED_UPDATE_TITLE"), null)) {
                return this.doUpdate(repos, updateList);
            }
            return 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCheckUpdate(SVNRepositoryInfo repos, URL[] operands, List<File> updateList) throws SVNClientException {
        boolean needUpdate = false;
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, repos);
            File[] opFiles = SVNUtil.toFiles(operands);
            for (int i = 0; i < opFiles.length; ++i) {
                ISVNStatus status = client.getSingleStatus(opFiles[i]);
                if (status.getRepositoryTextStatus().equals((Object)SVNStatusKind.NONE)) {
                    break;
                }
                ISVNInfo info = client.getInfo(opFiles[i]);
                Long lastChangedRev = info.getLastChangedRevision().getNumber();
                info = client.getInfoFromWorkingCopy(opFiles[i]);
                Long currentRev = info.getRevision().getNumber();
                if (lastChangedRev <= currentRev) continue;
                needUpdate = true;
                updateList.add(opFiles[i]);
            }
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
        return needUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doUpdate(SVNRepositoryInfo repos, List<File> updateList) throws Exception {
        File[] opFiles = updateList.toArray(new File[0]);
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, repos);
            long[] results = client.update(opFiles, SVNRevision.HEAD, true, true);
            ISVNStatus[] statuses = client.getStatus(opFiles);
            for (int i = 0; i < statuses.length; ++i) {
                if (!statuses[i].getTextStatus().equals((Object)SVNStatusKind.CONFLICTED) && !statuses[i].getPropStatus().equals((Object)SVNStatusKind.CONFLICTED)) continue;
                int n = 3;
                return n;
            }
        }
        catch (Exception e) {
            int n = 2;
            return n;
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
        return 1;
    }

    private boolean getKeepLocks(Map options) {
        Boolean keepLocks = (Boolean)options.get("oracle.jdeveloper.subversion.KEEP_LOCKS");
        if (keepLocks != null) {
            return keepLocks;
        }
        return false;
    }

    private String getComments(Map options) {
        String commentOption = (String)options.get("setting_comments");
        return commentOption != null ? commentOption : "";
    }

    private void commitParents(VCSProfile profile, ISVNClientAdapter client, URL[] operands, String comment, boolean keepLocks) throws Exception {
        for (int u = 0; u < operands.length; ++u) {
            URL parent = URLFileSystem.getParent((URL)operands[u]);
            if (parent == null) continue;
            this.commitParent(profile, client, parent, comment, keepLocks);
        }
    }

    private void commitParent(VCSProfile profile, ISVNClientAdapter client, URL child, String comment, boolean keepLocks) throws Exception {
        VCSStatus status;
        VCSStatusFilter filter = profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.ADDED");
        if (filter.accept(status = profile.getStatusCache().get(child))) {
            URL parent = URLFileSystem.getParent((URL)child);
            if (parent != null) {
                this.commitParent(profile, client, parent, comment, keepLocks);
            }
            client.commit(new File[]{SVNUtil.toFile(child)}, comment, false, keepLocks);
            profile.getStatusCache().clear(child);
        }
    }
}

