/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.net.URL;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;

public class SVNOperationCleanup
extends AbstractSVNOperation {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.cleanup";

    public SVNOperationCleanup() {
        super(COMMAND_ID);
    }

    @Override
    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        URL projectURL = this.getContext().getWorkspace().getActiveProjectURL();
        URL workingCopyRoot = SVNUtil.resolveWorkingCopy(projectURL);
        if (workingCopyRoot == null) {
            return false;
        }
        SVNRepositoryInfo repos = SVNUtil.getFirstAssociatedRepository(workingCopyRoot);
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, repos);
            client.cleanup(SVNUtil.toFile(workingCopyRoot));
        }
        catch (Exception e) {
            throw SVNExceptionWrapper.wrapException(e);
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
        return true;
    }
}

