/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.SelectFilesConfiguration;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdevimpl.vcs.generic.util.VCSDirectoryWatcher;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFolder;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.op.ui.BasicCheckoutPanel;
import oracle.jdevimpl.vcs.svn.op.ui.CheckoutInfo;
import oracle.jdevimpl.vcs.svn.op.ui.FullCheckoutPanel;
import oracle.jdevimpl.vcs.svn.op.ui.ValidatedPanel;
import oracle.jdevimpl.vcs.svn.prefs.SVNVersionToolsPreferences;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.svn.util.TimingUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

public class SVNOperationCheckout
extends ActionCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.checkout";
    private static final String LAST_CO_ROOT_KEY = SVNOperationCheckout.class.getName() + ".lastCoRoot";
    private static final String TIMING_CTX_CO = "checkout";
    private static final String TIMING_CTX_SCAN = "dirScan";
    private Boolean warnReposRoot = null;

    public SVNOperationCheckout() {
        super(COMMAND_ID);
    }

    protected boolean isAvailableImpl(VCSProfile profile) throws Exception {
        SVNRemoteNode remoteNode;
        if (!super.isAvailableImpl(profile)) {
            return false;
        }
        return !SVNUtil.isRepositoryNavigatorView(this.getContext()) || (remoteNode = SVNUtil.getSVNRemoteNode(this.getContext())) == null || remoteNode.getNodeKind() != SVNNodeKind.FILE;
    }

    protected int doitImpl(final VCSProfile profile) throws Exception {
        URL checkOutRoot;
        ValidatedPanel panel = null;
        String checkOutPath = null;
        SVNRemoteNode remoteNode = SVNUtil.getSVNRemoteNode(this.getContext());
        String checkOutRootStr = Ide.getDTCache().getString(LAST_CO_ROOT_KEY);
        URL uRL = checkOutRoot = checkOutRootStr != null ? URLFactory.newDirURL((String)checkOutRootStr) : URLFactory.newDirURL((String)Ide.getWorkDirectory());
        if (remoteNode != null) {
            if (remoteNode instanceof SVNRepositoryNode) {
                this.warnReposRoot = this.warnReposRoot();
                if (!this.warnReposRoot.booleanValue()) {
                    return 1;
                }
            }
            boolean isReposRoot = false;
            String reposAlias = null;
            if (remoteNode instanceof SVNRepositoryNode) {
                isReposRoot = true;
                SVNRepositoryInfo reposInfo = (SVNRepositoryInfo)((SVNRepositoryNode)remoteNode).getData();
                reposAlias = reposInfo.getAlias();
            }
            URL suggestedDestination = SVNUtil.suggestCheckoutDestination(checkOutRoot, remoteNode.getSVNUrl(), isReposRoot, reposAlias);
            panel = new BasicCheckoutPanel((SVNRepositoryInfo)remoteNode.getParentRepository().getData(), remoteNode.getSVNUrl(), suggestedDestination);
            checkOutPath = SVNUrlUtils.getRelativePath((SVNUrl)remoteNode.getParentRepository().getSVNUrl(), (SVNUrl)remoteNode.getSVNUrl());
        } else {
            if (!SVNUtil.ensureRepositoryConnection(this.getContext())) {
                return 1;
            }
            panel = new FullCheckoutPanel(SVNRepositoryManager.getInstance().list(), checkOutRoot, SVNUtil.getIDEClientAdapter());
        }
        final JEWTDialog dialog = this.createDialog(panel, checkOutPath);
        final CheckoutInfo coInfo = panel;
        dialog.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
                URL[] contents;
                if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                    return;
                }
                if (coInfo.getRevision() == SVNRevision.INVALID_REVISION) {
                    MessageDialog.error((Component)dialog, (Object)Resource.get("INVALID_REVISION_ERROR_MESSAGE"), (String)Resource.get("INVALID_REVISION_ERROR_TITLE"), null);
                    throw new PropertyVetoException(null, pce);
                }
                URL dest = coInfo.getDestinationURL();
                URL root = URLFileSystem.getParent((URL)dest);
                if (root == null) {
                    root = URLFactory.newDirURL((String)Ide.getWorkDirectory());
                }
                Ide.getDTCache().putString(LAST_CO_ROOT_KEY, URLFileSystem.getPlatformPathName((URL)root));
                if (URLFileSystem.exists((URL)dest) && (contents = URLFileSystem.list((URL)dest)).length > 0 && !SVNOperationCheckout.this.warnNonEmptyDestination((Component)dialog, dest)) {
                    throw new PropertyVetoException(null, pce);
                }
                if (coInfo.getSourceURL().equals((Object)coInfo.getRepositoryInfo().getURL())) {
                    if (SVNOperationCheckout.this.warnReposRoot == null) {
                        SVNOperationCheckout.this.warnReposRoot = SVNOperationCheckout.this.warnReposRoot();
                    }
                    if (!SVNOperationCheckout.this.warnReposRoot.booleanValue()) {
                        throw new PropertyVetoException(null, pce);
                    }
                }
                dialog.setOKButtonEnabled(false);
                CheckoutThread coThread = new CheckoutThread(profile, dialog, dialog.getContent(), coInfo);
                coThread.start();
                throw new PropertyVetoException(null, pce);
            }
        });
        ((ValidatedPanel)panel).addListener(new ValidatedPanel.PanelValidationListener(){

            @Override
            public void onReceiveValidationResult(final boolean validationResult) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dialog.setOKButtonEnabled(validationResult);
                    }
                });
            }
        });
        if (dialog.runDialog()) {
            this.postInvoke(profile, coInfo);
            return 0;
        }
        return 1;
    }

    protected void postInvoke(VCSProfile profile, CheckoutInfo coInfo) throws Exception {
        URL dest = coInfo.getDestinationURL();
        this.fireFileStructureChanged(new URL[]{dest});
        VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
    }

    private boolean warnNonEmptyDestination(Component parent, URL dest) {
        return MessageDialog.optionalConfirm((String)(SVNOperationCheckout.class.getName() + ".warnNonEmptyDestination"), (Component)parent, (String)Resource.format("ACTION_CHECKOUT_NONEMPTY_DEST_WARNING_MESSAGE", URLFileSystem.getPlatformPathName((URL)dest)), (String)Resource.get("ACTION_CHECKOUT_WARNING_TITLE"), (String)"f1_svnconfirmcheckoutintodir_html");
    }

    private boolean warnReposRoot() {
        return MessageDialog.optionalConfirm((String)(SVNOperationCheckout.class.getName() + ".warnRootCheckout"), (Component)Ide.getMainWindow(), (String)Resource.get("ACTION_CHECKOUT_ROOT_WARNING_MESSAGE"), (String)Resource.get("ACTION_CHECKOUT_WARNING_TITLE"), (String)"f1_svnconfirmcheckoutfromroot_html");
    }

    private JEWTDialog createDialog(JComponent content, String relativePath) {
        String title = relativePath != null ? Resource.format("ACTION_CHECKOUT_DIALOG_TITLE_URL", relativePath) : Resource.get("ACTION_CHECKOUT_DIALOG_TITLE");
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), title, 7);
        dialog.setDefaultButton(1);
        dialog.setContent((Component)content);
        dialog.setResizable(true);
        HelpSystem.getHelpSystem().registerTopic(content, "f1_svncheckoutfromsubversion_html");
        return dialog;
    }

    static /* synthetic */ VCSExceptionHandler access$800(SVNOperationCheckout x0) {
        return x0.getExceptionHandler();
    }

    static /* synthetic */ VCSExceptionHandler access$900(SVNOperationCheckout x0) {
        return x0.getExceptionHandler();
    }

    public final class CheckoutThread
    extends Thread {
        private final JEWTDialog _parentDialog;
        private final Component _parentPanel;
        private final CheckoutInfo _coInfo;
        private final VCSProfile _profile;

        private CheckoutThread(VCSProfile profile, JEWTDialog parentDialog, Component parentPanel, CheckoutInfo coInfo) {
            super("svn-checkout-thread");
            this._profile = profile;
            this._parentDialog = parentDialog;
            this._parentPanel = parentPanel;
            this._coInfo = coInfo;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private String getName(Context context) {
            Element elm = context.getElement();
            String name = "";
            if (elm instanceof Locatable) {
                URL url = ((Locatable)elm).getURL();
                if (elm instanceof SVNRemoteFolder) {
                    String[] svnLPath = ((SVNRemoteFolder)elm).getSVNUrl().getPathSegments();
                    String path = url.getPath();
                    if (svnLPath.length > 0 && path.length() > svnLPath[0].length() + 2) {
                        name = path.substring(svnLPath[0].length() + 2);
                    }
                }
                if (name == null) {
                    name = URLFileSystem.getName((URL)url);
                }
            }
            return name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeCheckoutWithProgress(JEWTDialog dialog, CheckoutInfo coInfo, VCSDirectoryWatcher watcher) throws SVNClientException, IOException {
            IndeterminateProgressMonitor progressMon = new IndeterminateProgressMonitor((Component)dialog, Resource.get("ACTION_CHECKOUT_PROGRESS_TITLE"), (Object)Resource.get("ACTION_CHECKOUT_PROGRESS_MESSAGE"), null);
            progressMon.setMillisToPopup(0);
            progressMon.setCloseOnFinish(true);
            progressMon.setCancellable(false);
            progressMon.start();
            try {
                this.executeCheckout(progressMon, coInfo, watcher);
            }
            finally {
                progressMon.finish();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeCheckout(IndeterminateProgressMonitor progress, CheckoutInfo coInfo, VCSDirectoryWatcher watcher) throws SVNClientException, IOException {
            SVNUrl sourceUrl = coInfo.getSourceURL();
            URL destUrl = coInfo.getDestinationURL();
            String coContext = "checkout.{" + sourceUrl.toString() + "}";
            String scanContext = "dirScan.{" + URLFileSystem.getPlatformPathName((URL)destUrl) + "}";
            TimingUtil.beginTiming(this.getClass(), coContext);
            ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
            URL destination = coInfo.getDestinationURL();
            if (!URLFileSystem.mkdirs((URL)destination)) {
                throw new IOException(URLFileSystem.getPlatformPathName((URL)destination));
            }
            TimingUtil.beginTiming(this.getClass(), scanContext);
            watcher.beginWatch();
            TimingUtil.endTiming(this.getClass(), scanContext);
            try {
                SVNOperationLogger.getInstance().beginOperation(svnClient, coInfo.getRepositoryInfo(), progress);
                svnClient.checkout(sourceUrl, SVNUtil.toFile(coInfo.getDestinationURL()), coInfo.getRevision(), coInfo.getDepth(), false, false);
                TimingUtil.beginTiming(this.getClass(), scanContext);
                watcher.endWatch();
                TimingUtil.endTiming(this.getClass(), scanContext);
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
                TimingUtil.endTiming(this.getClass(), coContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAutoLockWithProgress(JEWTDialog dialog, CheckoutInfo coInfo, VCSDirectoryWatcher watcher) throws SVNClientException, IOException {
            boolean autoLock;
            VCSPropertyMap vtoolsPrefs = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion").getData("oracle.jdeveloper.vcs.data.COMMON_SETTINGS");
            boolean bl = autoLock = (Boolean)vtoolsPrefs.getMap().get("svnAutoLock") != null ? ((Boolean)vtoolsPrefs.getMap().get("svnAutoLock")).booleanValue() : SVNVersionToolsPreferences.DEFAULT_KEY_AUTO_LOCK.booleanValue();
            if (!autoLock) {
                return;
            }
            IndeterminateProgressMonitor progressMon = new IndeterminateProgressMonitor((Component)dialog, Resource.get("ACTION_AUTOLOCK_PROGRESS_TITLE"), (Object)Resource.get("ACTION_AUTOLOCK_PROGRESS_MESSAGE"), null);
            progressMon.setMillisToPopup(500);
            progressMon.setCloseOnFinish(true);
            progressMon.setCancellable(false);
            progressMon.start();
            try {
                ArrayList newURLs = new ArrayList();
                newURLs.addAll(watcher.getNewWorkspaces());
                newURLs.addAll(watcher.getNewProjects());
                newURLs.addAll(watcher.getNewRegularURLs());
                File[] newFiles = SVNUtil.toFiles(newURLs.toArray(new URL[0]));
                ArrayList<File> needsLockFiles = new ArrayList<File>();
                ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
                for (File file : newFiles) {
                    ISVNProperty[] properties;
                    for (ISVNProperty property : properties = svnClient.getProperties(file)) {
                        if (!property.getName().equals("svn:needs-lock")) continue;
                        needsLockFiles.add(file);
                    }
                }
                if (needsLockFiles.isEmpty()) {
                    return;
                }
                svnClient.lock(needsLockFiles.toArray(new File[0]), Resource.get("ACTION_AUTOLOCK_COMMENT_MESSAGE"), false);
                ArrayList<File> unlockedFiles = new ArrayList<File>();
                for (File file : needsLockFiles) {
                    ISVNStatus status = svnClient.getSingleStatus(file);
                    if (status.getLockOwner() != null) continue;
                    unlockedFiles.add(file);
                }
                if (unlockedFiles.isEmpty()) {
                    return;
                }
                progressMon.finish();
                SelectFilesConfiguration selectFilesConfiguration = new SelectFilesConfiguration((Component)dialog, Resource.get("ACTION_AUTOLOCK_DIALOG_FAILED_TITLE"), Resource.format("ACTION_AUTOLOCK_DIALOG_FAILED_SINGLE_MESSAGE", unlockedFiles.toArray(new File[0])[0].getCanonicalPath()), Resource.get("ACTION_AUTOLOCK_DIALOG_FAILED_MULTI_MESSAGE"), VCSComponents.createCheckBoxListModel((Object[])unlockedFiles.toArray(new File[0]), (boolean)false), false, -1, "f1_svnfailedautomaticlock_html");
                SelectFilesPanel.showDialog((SelectFilesConfiguration)selectFilesConfiguration);
            }
            finally {
                progressMon.finish();
            }
        }
    }
}

