/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.io.File;
import java.net.URL;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;
import oracle.javatools.compare.algorithm.directory.DirectoryList;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.generic.util.VCSCompareCommand;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.history.SVNHistoricalContentCache;
import oracle.jdevimpl.vcs.svn.history.SVNHistoryEntryProducer;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class AbstractSVNCompareOperation
extends VCSCompareCommand {
    public AbstractSVNCompareOperation(String commandId) {
        super(commandId);
    }

    protected boolean isDirectoryCompareSupported() {
        return true;
    }

    protected DirectoryList listDirectory(URL directoryUrl) throws Exception {
        VCSProfile profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        DirectoryList directoryList = new DirectoryList();
        for (final URLFileSystem.FileInfo info : URLFileSystem.ls((URL)directoryUrl)) {
            if (URLFileSystem.getFileName((URL)info.getURL()).equals(".svn")) continue;
            VCSStatus status = this.getStatusCache().get(info.getURL());
            String id = status.isVersioned() && !SVNUtil.isModified(status, profile) ? Long.toString(SVNURLInfoCache.getInstance().getLastChangedRevision(info.getURL())) : Long.toString(Long.MAX_VALUE);
            directoryList.appendFile(new DirectoryFile(info.isDirectory(), URLFileSystem.getFileName((URL)info.getURL()), id){

                public CompareContributor createCompareContributor() throws Exception {
                    assert (URLFileSystem.isDirectoryPath((URL)info.getURL()) == this.isDirectory());
                    return AbstractSVNCompareOperation.this.getCurrentContributor(info.getURL());
                }
            });
        }
        return directoryList;
    }

    protected CompareContributor getHistoricalContributor(VCSProfile profile, Locatable source, Object revisionObject) throws Exception {
        return this.getHistoricalContributor(profile, source.getURL(), revisionObject);
    }

    protected CompareContributor getHistoricalContributor(VCSProfile profile, URL sourceUrl, Object revisionObject) throws Exception {
        SVNRevision revision = (SVNRevision)revisionObject;
        if (URLFileSystem.isDirectoryPath((URL)sourceUrl)) {
            String label = SVNUtil.getCompareIdentifier(sourceUrl, revision);
            return this.createDirectoryContributor(sourceUrl, this.listDirectory(sourceUrl, revision), label);
        }
        SVNUrl reposUrl = SVNURLInfoCache.getInstance().getURL(sourceUrl);
        if (reposUrl == null) {
            throw new IllegalStateException();
        }
        SVNHistoricalContentCache contentCache = SVNHistoricalContentCache.getInstance();
        if (!contentCache.containsRevisionContent(reposUrl, revision)) {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(AbstractSVNOperation.CLIENT_CONTEXT);
            SVNRepositoryInfo reposInfo = SVNUtil.resolveRepository(reposUrl);
            SVNClientInteraction.getInstance().beginInteraction(client, reposInfo);
            try {
                contentCache.putRevisionContentStream(reposUrl, revision, client.getContent(reposUrl, revision));
            }
            catch (SVNClientException svnex) {
                throw SVNExceptionWrapper.wrapSVNClientException((Exception)((Object)svnex));
            }
            finally {
                SVNClientInteraction.getInstance().endInteraction();
            }
        }
        String resourceName = SVNUtil.getCompareIdentifier(sourceUrl, revision);
        if (VCSFileSystemUtils.isContentTypeBinary((URL)sourceUrl)) {
            return new BinaryCompareContributor(contentCache.getRevisionContentStream(reposUrl, revision), URLFileSystem.getFileName((URL)sourceUrl), resourceName, resourceName);
        }
        return new InputStreamTextContributor(contentCache.getRevisionContentStream(reposUrl, revision), resourceName, resourceName, URLFileSystem.getSuffix((URL)sourceUrl));
    }

    private DirectoryList listDirectory(final URL directoryUrl, SVNRevision revision) throws Exception {
        ISVNDirEntry[] dirEntries;
        ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNHistoryEntryProducer.CLIENT_CONTEXT);
        SVNRepositoryInfo reposInfo = SVNUtil.getFirstAssociatedRepository(directoryUrl);
        SVNClientInteraction.getInstance().beginInteraction(client, reposInfo);
        try {
            dirEntries = client.getList(new File(URLFileSystem.getPlatformPathName((URL)directoryUrl)), revision, false);
        }
        catch (SVNClientException svnex) {
            throw SVNExceptionWrapper.wrapSVNClientException((Exception)((Object)svnex));
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
        final VCSProfile profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        DirectoryList directoryList = new DirectoryList();
        for (ISVNDirEntry dirEntry : dirEntries) {
            boolean directory = dirEntry.getNodeKind() == SVNNodeKind.DIR;
            String name = dirEntry.getPath().replace('\\', '/');
            name = name.substring(name.lastIndexOf(47) + 1);
            String id = Long.toString(dirEntry.getLastChangedRevision().getNumber());
            directoryList.appendFile(new DirectoryFile(directory, name, id){

                public CompareContributor createCompareContributor() throws Exception {
                    URL url = this.isDirectory() ? URLFactory.newDirURL((URL)directoryUrl, (String)this.getName()) : URLFactory.newURL((URL)directoryUrl, (String)this.getName());
                    return AbstractSVNCompareOperation.this.getHistoricalContributor(profile, url, (Object)SVNRevision.getRevision((String)this.getID()));
                }
            });
        }
        directoryList.clearModified();
        return directoryList;
    }
}

