/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.nav.ConnectionNode;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteContainer;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRepositoryNode
extends SVNRemoteContainer
implements ConnectionNode {
    private static final ResourcePicker sRes = ResourcePicker.getPicker(SVNProfile.class);
    private final SVNRepositoryInfo _reposInfo;

    public SVNRepositoryNode(SVNRepositoryInfo reposInfo) {
        super(null, null, reposInfo.getURL());
        this._reposInfo = reposInfo;
    }

    public Map<String, String> getConnectionCriteria() {
        SVNUrl url = this._reposInfo.getURL();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("url", url.toString());
        return criteria;
    }

    @Override
    public SVNRepositoryNode getParentRepository() {
        return this;
    }

    public String getShortLabel() {
        String label = this._reposInfo.getAlias();
        if (label == null || label.equals("")) {
            label = this._reposInfo.getURL().toString();
        }
        return label;
    }

    public Icon getIcon() {
        return sRes.getImage("NAV_ICON_REPOSITORY_NODE");
    }

    public String getToolTipText() {
        return this._reposInfo.getURL().toString();
    }

    @Override
    public Object getData() {
        return this._reposInfo;
    }
}

