/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.migration;

import java.io.File;
import java.io.IOException;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.util.FileCopyUtil;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.repos.SVNConnectionFileConstansts;

public class SVNConnectionsMigrator
extends XMLMigrator
implements SVNConnectionFileConstansts {
    private static final int SVN_CONNECTIONS = 0;
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);

    public SVNConnectionsMigrator() {
        super(new int[]{0});
    }

    protected String getFileName() {
        return "repositories.xml";
    }

    protected String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    protected String getRootTag() {
        return "svn-repositories";
    }

    public String getDescription(int category) {
        return this._res.getString("SVN_CONNECTIONS_DESCRIPTION");
    }

    public String[] migrate(File sourceDir, File destDir) {
        File srcFile = new File(sourceDir, this.getFileName());
        File dstFile = new File(destDir, this.getFileName());
        try {
            FileCopyUtil.copyFile((File)srcFile, (File)dstFile);
        }
        catch (IOException e) {
            String[] error = new String[]{e.getMessage()};
            return error;
        }
        return null;
    }

    protected File getSourceFile(File sourceDir, File destDir) {
        return super.getSourceFile(sourceDir, destDir);
    }

    protected File getDestFile(File sourceDir, File destDir) {
        return super.getDestFile(sourceDir, destDir);
    }
}

