/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizard;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizardModel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.RevisionRangePanel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.SVNUrlInputPanel;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.WorkingCopyRevListerPanel;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRevisionLister;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ReintegratePanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final String TRANSIENT_TREE_PATH_KEY = ReintegratePanel.class.getName() + ".treePath";
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private boolean _initialized = false;
    private JMultiLineLabel _hint;
    SVNMergeWizardModel _model;
    private SVNUrlInputPanel _urlInputPanel;
    private WorkingCopyRevListerPanel _wcRevListerPanel;
    private JButton _revListerButton;
    private SVNUrl _svnurl;

    public ReintegratePanel() {
        this.setLayout(new GridBagLayout());
    }

    public void onEntry(TraversableContext dataContext) {
        this._model = (SVNMergeWizardModel)dataContext.get(SVNMergeWizard.DATA_KEY);
        this.initialize();
        this.updateMergeURL();
        File resourceFile = SVNUtil.toFile(this._model.getResourceUrl());
        this._wcRevListerPanel.setWCFile(resourceFile.toString());
    }

    private void updateMergeURL() {
        SVNExecutorService executor = SVNExecutorService.getInstance();
        Thread suggestionThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                URL resourceUrl = ReintegratePanel.this._model.getResourceUrl();
                File resourceFile = SVNUtil.toFile(resourceUrl);
                String[] suggestedStrs = null;
                String svnurlStr = null;
                try {
                    ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                    ReintegratePanel.this._svnurl = client.getInfoFromWorkingCopy(resourceFile).getUrl();
                    ReintegratePanel.this._urlInputPanel.setComboBox(new String[]{ReintegratePanel.this._svnurl.toString()}, ReintegratePanel.this._svnurl.toString());
                    SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(ReintegratePanel.this._svnurl);
                    SVNClientInteraction.getInstance().beginInteraction(client, repoInfo);
                    suggestedStrs = client.suggestMergeSources(resourceFile);
                    svnurlStr = ReintegratePanel.this._svnurl.toString();
                    SVNClientInteraction.getInstance().endInteraction();
                }
                catch (SVNClientException e) {
                    try {
                        SVNProfile.getQualifiedLogger(RevisionRangePanel.class.getName()).warning(e.getMessage());
                        SVNClientInteraction.getInstance().endInteraction();
                    }
                    catch (Throwable throwable) {
                        SVNClientInteraction.getInstance().endInteraction();
                        List<String> suggestedList = Arrays.asList(suggestedStrs);
                        if (suggestedList.size() == 0 || !suggestedList.contains(svnurlStr)) {
                            suggestedList = new LinkedList(suggestedList);
                            ((LinkedList)suggestedList).addFirst(svnurlStr);
                            suggestedStrs = suggestedList.toArray(new String[0]);
                        }
                        ReintegratePanel.this._urlInputPanel.setComboBox(suggestedStrs, svnurlStr);
                        throw throwable;
                    }
                    List<String> suggestedList = Arrays.asList(suggestedStrs);
                    if (suggestedList.size() == 0 || !suggestedList.contains(svnurlStr)) {
                        suggestedList = new LinkedList(suggestedList);
                        ((LinkedList)suggestedList).addFirst(svnurlStr);
                        suggestedStrs = suggestedList.toArray(new String[0]);
                    }
                    ReintegratePanel.this._urlInputPanel.setComboBox(suggestedStrs, svnurlStr);
                }
                List<String> suggestedList = Arrays.asList(suggestedStrs);
                if (suggestedList.size() == 0 || !suggestedList.contains(svnurlStr)) {
                    suggestedList = new LinkedList<String>(suggestedList);
                    ((LinkedList)suggestedList).addFirst(svnurlStr);
                    suggestedStrs = suggestedList.toArray(new String[0]);
                }
                ReintegratePanel.this._urlInputPanel.setComboBox(suggestedStrs, svnurlStr);
            }
        };
        executor.activate();
        executor.submit(suggestionThread);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this._model = (SVNMergeWizardModel)dataContext.get(SVNMergeWizard.DATA_KEY);
        URL resourceUrl = this._model.getResourceUrl();
        File resourceFile = SVNUtil.toFile(resourceUrl);
        this._model.setFromSVNUrl(this.getSVNUrl());
        this._model.setLocalPath(resourceFile);
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
        this._initialized = true;
    }

    private void createComponents() {
        this._hint = new JMultiLineLabel();
        this._hint.setText(this._res.getString("MERGE_UI_REINTEGRATE_HINT"));
        this._urlInputPanel = new SVNUrlInputPanel(this._res.getString("UI_REINTEGRATEPANEL_FROM_URL_TEXT"));
        this._urlInputPanel.setModel(this._model);
        this._revListerButton = new JButton();
        this._revListerButton = new JButton();
        this._revListerButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._revListerButton, (String)this._res.getString("UI_SHOW_REVLISTER_BTN_TEXT"));
        this._wcRevListerPanel = new WorkingCopyRevListerPanel(this._res.getString("UI_REINTEGRATEPANEL_WCREVLISTER_TEXT"));
        URL resourceUrl = this._model.getResourceUrl();
        File resourceFile = SVNUtil.toFile(resourceUrl);
        this._wcRevListerPanel.setWCFile(resourceFile.toString());
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        this.add((Component)this._hint, this.gbc(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add(this._urlInputPanel, this.gbc(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(this._revListerButton, this.gbc(0, 2, 1, 1, 0.0, 0.0, 13, 0, insets, 0, 0));
        this.add(this._wcRevListerPanel, this.gbc(0, 3, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(Box.createVerticalGlue(), this.gbc(0, 4, 1, 1, 0.0, 1.0, 15, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initListeners() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SVNRevisionLister revLister = new SVNRevisionLister(this.getSVNUrl(), SVNRevision.HEAD, (SVNRevision)new SVNRevision.Number(0L));
        revLister.setAllowMultipleSelection(true);
        revLister.showLister();
    }

    private SVNUrl getSVNUrl() {
        return this._urlInputPanel.getSVNUrl();
    }
}

