/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.mergewiz.MergeOperation;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizard;
import oracle.jdevimpl.vcs.svn.mergewiz.SVNMergeWizardModel;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.ui.DepthOperationPanel;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class MergeOptionsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final String TRANSIENT_TREE_PATH_KEY = MergeOptionsPanel.class.getName() + ".treePath";
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private boolean _initialized = false;
    private SVNMergeWizardModel _model;
    private DepthOperationPanel _depthPanel;
    private JCheckBox _ignoreAncestryBox;
    private JCheckBox _recordBox;
    private JCheckBox _forceBox;
    private JButton _testButton;
    private JMultiLineLabel _hint;
    private JLabel _statusLabel;
    private JTextArea _statusArea;
    private JScrollPane _scrollPane;
    static String _pre_complete_msg = null;
    static String _pre_error_msg = null;
    boolean _newSession = true;

    public MergeOptionsPanel() {
        this.setLayout(new GridBagLayout());
    }

    public void onEntry(TraversableContext dataContext) {
        this._model = (SVNMergeWizardModel)dataContext.get(SVNMergeWizard.DATA_KEY);
        this.initialize();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this._model = (SVNMergeWizardModel)dataContext.get(SVNMergeWizard.DATA_KEY);
        this.updateModelWithOptions();
    }

    private synchronized void initialize() {
        if (this._initialized) {
            this._statusArea.setText("");
            return;
        }
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
        this._initialized = true;
    }

    private void createComponents() {
        this._hint = new JMultiLineLabel();
        this._hint.setText(this._res.getString("MERGE_UI_OPTIONS_HINT"));
        this._depthPanel = new DepthOperationPanel();
        this._ignoreAncestryBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._ignoreAncestryBox, (String)this._res.getString("UI_OPTIONSPANEL_ANCESTRY_CHECKBOX"));
        this._forceBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._forceBox, (String)this._res.getString("UI_OPTIONSPANEL_FORCE_CHECKBOX"));
        this._recordBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._recordBox, (String)this._res.getString("UI_OPTIONSPANEL_RECORD_CHECKBOX"));
        this._testButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._testButton, (String)this._res.getString("UI_OPTIONSPANEL_TESTMERGE_BUTTON"));
        this._statusLabel = new JLabel();
        this._statusArea = new JTextArea();
        this._statusArea.setEditable(false);
        this._statusArea.setRows(3);
        this._statusArea.setLineWrap(true);
        this._statusArea.setText("");
        ResourceUtils.resLabel((JLabel)this._statusLabel, (Component)this._statusArea, (String)this._res.getString("UI_MERGE_PANEL_LABEL_STATUS"));
        this._scrollPane = new JScrollPane(this._statusArea);
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        this.add((Component)this._hint, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add(this._depthPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add(this._ignoreAncestryBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add(this._forceBox, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add(this._recordBox, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add(this._testButton, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
        this.add(this._statusLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add(this._scrollPane, new GridBagConstraints(0, 7, 1, 3, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 8, 1, 1, 0.0, 1.0, 15, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initListeners() {
        this._testButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModelWithOptions();
        if (e.getSource().equals(this._testButton)) {
            this._statusArea.setText("");
            TextAreaNotificationListener tanListener = new TextAreaNotificationListener();
            MergeTestThread mergeThread = new MergeTestThread(this._model, true, tanListener);
            mergeThread.start();
        }
    }

    private void updateModelWithOptions() {
        this._model.setDepth(this._depthPanel.getDepthSelected());
        this._model.setIgnoreAncestry(this._ignoreAncestryBox.isSelected());
        this._model.setRecordOnly(this._recordBox.isSelected());
        this._model.setForce(this._forceBox.isSelected());
    }

    private class MergeTestThread
    extends Thread {
        private int _mergeType = 0;
        private SVNMergeWizardModel m_model;
        private boolean m_dryrun;
        private ISVNNotifyListener m_tanListener;

        public MergeTestThread(SVNMergeWizardModel model, boolean dryrun, ISVNNotifyListener tanListener) {
            this.m_model = model;
            this.m_dryrun = dryrun;
            this.m_tanListener = tanListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized void run() {
            this._mergeType = this.m_model.getMergeType();
            WaitCursor wc = null;
            ISVNClientAdapter client = null;
            try {
                client = SVNUtil.getIDEClientAdapter();
                client.addNotifyListener(this.m_tanListener);
                wc = new WaitCursor((Component)((Object)MergeOptionsPanel.this));
                wc.show();
                MergeOptionsPanel.this._testButton.setEnabled(false);
                SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(this.m_model.getFromSVNUrl());
                SVNOperationLogger.getInstance().beginOperation(client, repoInfo);
                switch (this._mergeType) {
                    case 0: {
                        this.doRangeMerge(client);
                        return;
                    }
                    case 1: {
                        this.doIntegrateMerge(client);
                        return;
                    }
                    case 2: {
                        this.doTreeMerge(client);
                        return;
                    }
                }
                return;
            }
            catch (SVNClientException e) {
                SVNProfile.getQualifiedLogger(MergeOperation.class.getName()).warning(e.getMessage());
                return;
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
                MergeOptionsPanel.this._newSession = true;
                if (this.m_tanListener != null) {
                    client.removeNotifyListener(this.m_tanListener);
                }
                if (wc != null) {
                    wc.hide();
                    wc.dispose();
                    MergeOptionsPanel.this._testButton.setEnabled(true);
                }
            }
        }

        private synchronized void doRangeMerge(ISVNClientAdapter client) throws SVNClientException {
            client.merge(this.m_model.getFromSVNUrl(), SVNRevision.HEAD, this.m_model.getFromRevisionRanges(), this.m_model.getLocalPath(), this.m_model.isForce(), this.m_model.getDepth(), this.m_model.isIgnoreAncestry(), this.m_dryrun, this.m_model.isRecordOnly());
        }

        private synchronized void doIntegrateMerge(ISVNClientAdapter client) throws SVNClientException {
            client.mergeReintegrate(this.m_model.getFromSVNUrl(), SVNRevision.HEAD, this.m_model.getLocalPath(), this.m_model.isForce(), this.m_dryrun);
        }

        private synchronized void doTreeMerge(ISVNClientAdapter client) throws SVNClientException {
            client.merge(this.m_model.getFromSVNUrl(), this.m_model.getFromRevision(), this.m_model.getToSVNUrl(), this.m_model.getToRevision(), this.m_model.getLocalPath(), this.m_model.isForce(), this.m_model.getDepth(), this.m_dryrun, this.m_model.isIgnoreAncestry(), this.m_model.isRecordOnly());
        }
    }

    private final class TextAreaNotificationListener
    implements ISVNNotifyListener {
        private TextAreaNotificationListener() {
        }

        public void setCommand(int command) {
        }

        public void logCommandLine(String commandLine) {
            this.appendLater(commandLine);
            this.appendLater("");
        }

        public void logMessage(String message) {
            this.appendLater(message);
        }

        public void logError(String message) {
            if (message.equals(_pre_error_msg)) {
                _pre_error_msg = null;
                return;
            }
            MergeOptionsPanel.this._newSession = false;
            _pre_error_msg = message;
            this.appendLater(message);
        }

        public void logRevision(long revision) {
        }

        public void logCompleted(String message) {
            if (!MergeOptionsPanel.this._newSession && message.equals(_pre_complete_msg)) {
                _pre_complete_msg = null;
                return;
            }
            MergeOptionsPanel.this._newSession = false;
            _pre_complete_msg = message;
            this.appendLater(message);
        }

        public void onNotify(File path, SVNNodeKind nodeKind) {
        }

        public void logRevision(long revision, String path) {
        }

        private void appendLater(String message) {
            MergeOptionsPanel.this._statusArea.append(message);
            MergeOptionsPanel.this._statusArea.append("\n");
        }
    }
}

