/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.mergewiz.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.mergewiz.ui.SVNUrlProvider;
import oracle.jdevimpl.vcs.svn.op.ui.SVNRevisionLister;
import oracle.jdevimpl.vcs.svn.op.ui.ValidatedPanel;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class HeadRevisionSelectionPanel
extends ValidatedPanel
implements ActionListener {
    private ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private ButtonGroup _revisionGroup;
    private JRadioButton _headRadio;
    private JRadioButton _revisionRadio;
    private NumberTextField _revisionField;
    private JButton _revisionButton;
    private SVNUrl _svnurl;
    private SVNRevision _selectedRevision;
    private SVNUrlProvider _svnurlProvider;

    public HeadRevisionSelectionPanel() {
        super(new GridBagLayout());
        this.createComponents();
        this.layoutComponents();
    }

    public HeadRevisionSelectionPanel(SVNUrlProvider svnurlProvider) {
        super(new GridBagLayout());
        this._svnurlProvider = svnurlProvider;
        this.createComponents();
        this.layoutComponents();
    }

    private void createComponents() {
        this._revisionGroup = new ButtonGroup();
        this._headRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._headRadio, (String)this._res.getString("UI_HEADREVISIONSELECTIONPANEL_HEAD_RADIO"));
        this._headRadio.setSelected(true);
        this._headRadio.addActionListener(this);
        this._revisionGroup.add(this._headRadio);
        this._revisionRadio = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this._revisionRadio, (String)this._res.getString("UI_HEADREVISIONSELECTIONPANEL_REVISION_RADIO"));
        this._revisionRadio.addActionListener(this);
        this._revisionGroup.add(this._revisionRadio);
        this._revisionField = new NumberTextField();
        this._revisionField.setColumns(8);
        this._revisionField.setDecimal(false);
        this._revisionField.setDataType(Integer.class);
        this._revisionField.setSigned(false);
        this._revisionField.setEnabled(this._revisionRadio.isSelected());
        this._revisionButton = new JButton();
        this._revisionButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._revisionButton, (String)this._res.getString("UI_DEFAULT_REVLISTER_BTN_TEXT"));
        this._revisionButton.setEnabled(this._revisionRadio.isSelected());
    }

    private void layoutComponents() {
        Insets insets = new Insets(6, 2, 2, 6);
        Insets insetsRadio = new Insets(6, 6, 2, 6);
        this.add((Component)this._headRadio, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, insetsRadio, 0, 0));
        this.add((Component)this._revisionRadio, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, insetsRadio, 0, 0));
        this.add((Component)this._revisionField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        this.add((Component)this._revisionButton, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
    }

    @Override
    public void initListeners() {
    }

    @Override
    public boolean validateContent() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this._revisionButton)) {
            SVNRevisionLister revLister = new SVNRevisionLister(this.getSourceUrl(), SVNRevision.HEAD, (SVNRevision)new SVNRevision.Number(0L));
            revLister.setAllowMultipleSelection(false);
            revLister.showLister();
            this._selectedRevision = revLister.getSelectedRevision();
            this._revisionField.setText(this._selectedRevision.toString());
        }
        if (e.getSource().equals(this._revisionRadio)) {
            this._revisionField.setEnabled(true);
            this._revisionButton.setEnabled(true);
        }
        if (e.getSource().equals(this._headRadio)) {
            this._revisionField.setEnabled(false);
            this._revisionButton.setEnabled(false);
        }
    }

    public SVNUrl getSourceUrl() {
        if (this._svnurlProvider != null) {
            this._svnurl = this._svnurlProvider.getSVNUrl();
        }
        return this._svnurl;
    }

    public void setSourceUrl(SVNUrl svnurl) {
        this._svnurl = svnurl;
    }

    public SVNRevision getRevision() {
        if (this._headRadio.isSelected()) {
            return SVNRevision.HEAD;
        }
        try {
            this._selectedRevision = SVNRevision.getRevision((String)this._revisionField.getText());
        }
        catch (ParseException e) {
            MessageDialog.error((Component)this, (Object)Resource.get("UI_REVISIONSELECTIONPANEL_RANGE_ERR_MESSAGE"), (String)Resource.get("UI_REVISIONSELECTIONPANEL_RANGE_ERR_TITLE"), null);
            return SVNRevision.INVALID_REVISION;
        }
        return this._selectedRevision;
    }
}

