/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.imp;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.imp.SVNImportModel;
import oracle.jdevimpl.vcs.svn.imp.SVNImportWizard;
import oracle.jdevimpl.vcs.util.CreateFileAndFolderFilterPanel;
import oracle.jdevimpl.vcs.util.FilterPanel;

public final class FiltersPanel
extends DefaultTraversablePanel {
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private boolean _initialized = false;
    private JMultiLineLabel _hint;
    private FilterPanel _filterPanel;

    public void onEntry(TraversableContext ctx) {
        SVNImportModel model = (SVNImportModel)ctx.get(SVNImportWizard.DATA_KEY);
        this.initialize(model.getFilters());
        ctx.getWizardCallbacks().wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
    }

    public void onExit(TraversableContext ctx) throws TraversalException {
        SVNImportModel model = (SVNImportModel)ctx.get(SVNImportWizard.DATA_KEY);
        this.initialize(model.getFilters());
        model.setFilters(this._filterPanel.getFilterPatterns());
    }

    private synchronized void initialize(Collection filterPatterns) {
        if (this._initialized) {
            return;
        }
        this.createComponents(filterPatterns);
        this.layoutComponents();
        this._initialized = true;
    }

    private void createComponents(Collection filterPatterns) {
        this._hint = new JMultiLineLabel();
        this._hint.setText(this._res.getString("IMPORT_UI_FILTERS_HINT"));
        this._filterPanel = new FilterPanel();
        this._filterPanel.setFilterPanelClass(CreateFilterPanel.class);
        this._filterPanel.setFilterPatterns(filterPatterns, true);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hint, this.gbc(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 20, 0), 0, 0));
        this.add((Component)this._filterPanel, this.gbc(0, 1, 1, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public static final class CreateFilterPanel
    extends CreateFileAndFolderFilterPanel {
        protected String getHelpId() {
            return "f1_scscreatefilter_html";
        }

        public boolean isComplete() {
            return this.getFilterText().trim().length() > 0;
        }
    }
}

