/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.compare;

import oracle.javatools.compare.algorithm.list.CompareList;
import oracle.javatools.compare.algorithm.list.CompareListItem;
import oracle.javatools.compare.algorithm.list.ListCompareContributor;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.compare.SVNComparableProperty;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNPropertiesCompareContributor
extends ListCompareContributor {
    private SVNUrl _url;
    private SVNRevision _revision;

    public SVNPropertiesCompareContributor(SVNUrl url, SVNRevision revision) {
        this._url = url;
        this._revision = revision;
    }

    protected final CompareList getCompareListImpl() {
        if (this._url == null || this._revision == null) {
            return new CompareList();
        }
        ISVNProperty[] properties = this.getPropertiesAdapter(this._url, this._revision);
        CompareList propertiesCompareList = new CompareList();
        for (int i = 0; i < properties.length; ++i) {
            propertiesCompareList.appendItem((CompareListItem)new SVNComparableProperty(properties[i].getName(), properties[i].getValue()));
        }
        return propertiesCompareList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISVNProperty[] getPropertiesAdapter(SVNUrl url, SVNRevision revision) {
        try {
            ISVNProperty[] properties;
            ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
            SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(url);
            SVNClientInteraction.getInstance().beginInteraction(svnClient, repoInfo);
            ISVNProperty[] iSVNPropertyArray = properties = svnClient.getProperties(url, revision);
            return iSVNPropertyArray;
        }
        catch (SVNClientException e) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).severe(e.getMessage());
            ISVNProperty[] iSVNPropertyArray = new ISVNProperty[]{};
            return iSVNPropertyArray;
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
    }

    public String getLongLabel() {
        return "SVNRevision " + this._revision + " - " + this._url.toString();
    }

    public String getShortLabel() {
        return this.getLongLabel();
    }
}

