/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.compare;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.CompareViewDecoration;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.compare.SVNPropertiesCompareContributor;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.util.WorkingCopyURLFilter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNCompareViewDecoration
extends CompareViewDecoration {
    private JLabel _labelMsg;
    HyperlinkButton _comparePropertyButton;
    private JPanel _panel;
    private URL _leftURL;
    private URL _rightURL;
    private String _leftRevision;
    private String _rightRevision;
    private SVNPropertiesCompareContributor _leftContributor;
    private SVNPropertiesCompareContributor _rightContributor;
    public static String LEFT_CONTRIBUTOR = "LEFT_CONTRIBUTOR";
    public static String RIGHT_CONTRIBUTOR = "RIGHT_CONTRIBUTOR";
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);

    public Component decorate(BaseCompareView view, Component gui) {
        if (!this.validToDecorate()) {
            return gui;
        }
        JPanel panel = this.getGUI();
        panel.add(gui, "Center");
        return panel;
    }

    private boolean validToDecorate() {
        if (SVNRepositoryManager.getInstance().isEmpty()) {
            return false;
        }
        if (this.getModel().getContributor(ContributorKind.FIRST) instanceof SVNPropertiesCompareContributor) {
            return false;
        }
        this.updateHistorySelecitonData((CompareModel)this.getModel());
        WorkingCopyURLFilter wcfilter = new WorkingCopyURLFilter();
        if (!wcfilter.accept(this._leftURL) || !wcfilter.accept(this._rightURL)) {
            return false;
        }
        try {
            if (SVNStatusKind.UNVERSIONED.toInt() == SVNURLInfoCache.getInstance().getTextStatus(this._leftURL) || SVNStatusKind.UNVERSIONED.toInt() == SVNURLInfoCache.getInstance().getTextStatus(this._rightURL)) {
                return false;
            }
        }
        catch (SVNClientException ex) {
            return false;
        }
        return true;
    }

    public void update() {
        if (this._labelMsg != null) {
            this.updateHistorySelecitonData((CompareModel)this.getModel());
            this.updatePropertyCompareMessage();
        }
    }

    protected JPanel getGUI() {
        if (this._panel == null) {
            this._comparePropertyButton = new HyperlinkButton((Action)new AbstractAction(this._res.getString("COMPARE_PROPERTY_HYPERLINK_TEXT")){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        Context context = this.createContext();
                        IdeAction.find((String)"oracle.jdeveloper.subversion.compareproperty").performAction(context);
                    }
                    catch (Exception f) {
                        f.printStackTrace();
                    }
                }

                private Context createContext() {
                    Context context = new Context();
                    try {
                        Element[] selection = SVNCompareViewDecoration.this._leftURL.equals(SVNCompareViewDecoration.this._rightURL) ? new Element[]{NodeFactory.findOrCreate((URL)SVNCompareViewDecoration.this._leftURL)} : new Element[]{NodeFactory.findOrCreate((URL)SVNCompareViewDecoration.this._leftURL), NodeFactory.findOrCreate((URL)SVNCompareViewDecoration.this._rightURL)};
                        context.setSelection(selection);
                        context.setProperty(LEFT_CONTRIBUTOR, (Object)SVNCompareViewDecoration.this._leftContributor);
                        context.setProperty(RIGHT_CONTRIBUTOR, (Object)SVNCompareViewDecoration.this._rightContributor);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException ex) {
                        ex.printStackTrace();
                    }
                    return context;
                }
            });
            this._comparePropertyButton.setHorizontalAlignment(2);
            Box box = Box.createHorizontalBox();
            box.add((Component)this._comparePropertyButton);
            this._labelMsg = new JLabel(this._res.getString("COMPARE_PROPERTY_HYPERLINK_PREFIX"));
            box.add(this._labelMsg);
            BorderLayout layout = new BorderLayout();
            layout.setVgap(2);
            this._panel = new JPanel(layout);
            this._panel.add((Component)box, "South");
            this._panel.setBackground(Color.WHITE);
            return this._panel;
        }
        return this._panel;
    }

    private void updateHistorySelecitonData(CompareModel compareModel) {
        CompareContributor contributor1 = compareModel.getContributor(ContributorKind.FIRST);
        CompareContributor contributor2 = compareModel.getContributor(ContributorKind.SECOND);
        if (contributor1 != null && contributor2 != null) {
            String longLabel = contributor1.getLongLabel();
            this._leftURL = this.parseLongLabelURL(longLabel);
            this._leftRevision = this.parseLongLabelRevision(longLabel);
            longLabel = contributor2.getLongLabel();
            if (longLabel.startsWith("Local Directory")) {
                longLabel = contributor1.getLongLabel();
            }
            this._rightURL = this.parseLongLabelURL(longLabel);
            this._rightRevision = this.parseLongLabelRevision(longLabel);
        }
    }

    private URL parseLongLabelURL(String label) {
        URL url = null;
        try {
            String[] tokens = label.split("\\s-\\s");
            url = URLFactory.newFileURL((String)tokens[tokens.length - 1]);
        }
        catch (Exception e) {
            return null;
        }
        return url;
    }

    private String parseLongLabelRevision(String label) {
        String revStr = null;
        try {
            String[] tokens = label.split("\\s-\\s");
            if (tokens.length < 2) {
                return SVNRevision.HEAD.toString();
            }
            String[] tokens2 = tokens[0].split("\\D+");
            if (tokens2.length < 1) {
                tokens2 = tokens[0].split("\\s");
            }
            if ((revStr = tokens2[tokens.length - 1]).equalsIgnoreCase("Revision")) {
                revStr = tokens2[0];
            }
        }
        catch (Exception e) {
            return null;
        }
        return revStr;
    }

    private void updatePropertyCompareMessage() {
        SVNExecutorService executor = SVNExecutorService.getInstance();
        Thread updateThread = new Thread(){

            @Override
            public void run() {
                try {
                    SVNUrl leftsvnurl = SVNURLInfoCache.getInstance().getURL(SVNCompareViewDecoration.this._leftURL);
                    SVNCompareViewDecoration.this._leftContributor = new SVNPropertiesCompareContributor(leftsvnurl, SVNRevision.getRevision((String)SVNCompareViewDecoration.this._leftRevision));
                    SVNUrl rightsvnurl = SVNURLInfoCache.getInstance().getURL(SVNCompareViewDecoration.this._rightURL);
                    SVNCompareViewDecoration.this._rightContributor = new SVNPropertiesCompareContributor(rightsvnurl, SVNRevision.getRevision((String)SVNCompareViewDecoration.this._rightRevision));
                    CompareInvocation invocationContext = CompareUtil.createInvocationContext((CompareContributor)SVNCompareViewDecoration.this._leftContributor, (CompareContributor)SVNCompareViewDecoration.this._rightContributor);
                    CompareModel model = CompareUtil.createCompareModel((CompareContributor)SVNCompareViewDecoration.this._leftContributor, (CompareContributor)SVNCompareViewDecoration.this._rightContributor, (CompareInvocation)invocationContext);
                    if (model.getDifferenceCount() > 0) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SVNCompareViewDecoration.this._labelMsg.setVisible(true);
                            }
                        });
                    } else {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SVNCompareViewDecoration.this._labelMsg.setVisible(false);
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        executor.activate();
        executor.submit(updateThread);
    }
}

