/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.client;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.client.AbstractSVNClient;
import oracle.jdevimpl.vcs.svn.client.SVNRAInfo;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;

public class SVNKitClient
extends AbstractSVNClient {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNKitClient.class.getName());
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);
    private String _version;
    private SVNRAInfo _raInfo;

    @Override
    public String getSVNVersion() {
        if (this._version == null) {
            this._version = this.getVersionImpl();
        }
        return this._version;
    }

    @Override
    public SVNRAInfo getRAInfo() {
        if (this._raInfo == null) {
            this._raInfo = new SVNRAInfo(true, true, true, true, true);
        }
        return this._raInfo;
    }

    @Override
    protected String getAdapterType() {
        return "svnkit";
    }

    private String getVersionImpl() {
        try {
            boolean jnaPresent;
            String[] tokens;
            Class<?> theClass = Class.forName("org.tmatesoft.svn.core.javahl.SVNClientImpl", true, Thread.currentThread().getContextClassLoader());
            Method theMethod = theClass.getMethod("version", null);
            String version = String.valueOf(theMethod.invoke(null, null));
            for (String token : tokens = version.split(" ")) {
                if (!token.startsWith("SVNKit")) continue;
                version = token;
                break;
            }
            version = (jnaPresent = SVNJNAUtil.isJNAPresent()) ? version.concat(this._res.getString("INFO_JNA_PRESENT")) : version.concat(this._res.getString("INFO_JNA_NOT_PRESENT"));
            return version;
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "unable to determine SVNKit version by calling org.tmatesoft.svn.core.javahl.SVNClientImpl.version()", e);
            return null;
        }
    }
}

