/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.client;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.client.SVNClient;
import oracle.jdevimpl.vcs.svn.client.SVNClientAPI;
import oracle.jdevimpl.vcs.svn.client.SVNKitClient;
import oracle.jdevimpl.vcs.svn.client.SVNNativeClient;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class SVNClientRegistry {
    private static final SVNClientRegistry sInstance = new SVNClientRegistry();
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNClientRegistry.class.getName());
    private final Map _contexts = new HashMap(5);
    private SVNClient _nativeClient;
    private SVNClient _cliClient;
    private SVNClient _svnkitClient;
    private boolean _initialized;

    public static SVNClientRegistry getInstance() {
        sInstance.initialize();
        return sInstance;
    }

    private synchronized void initialize() {
        long start;
        block5: {
            if (this._initialized) {
                return;
            }
            start = System.currentTimeMillis();
            try {
                SVNClientAPI.initializeNative();
                this._nativeClient = new SVNNativeClient();
                sLogger.info("discovered native svn client with version: " + this._nativeClient.getSVNVersion());
            }
            catch (SVNClientException ce) {
                sLogger.log(Level.WARNING, "native subversion client unavailable", ce);
                if (!sLogger.isLoggable(Level.FINE)) break block5;
                FastStringBuffer buff = new FastStringBuffer(500);
                buff.append("failed to load libsvnjavahl-1 or one of its ");
                buff.append("dependencies. java.library.path is ");
                buff.append(System.getProperty("java.library.path"));
                sLogger.fine(buff.toString());
            }
        }
        try {
            SVNClientAPI.initializeSVNKit();
            this._svnkitClient = new SVNKitClient();
            sLogger.info("discovered SVNKit client with version: " + this._svnkitClient.getSVNVersion());
        }
        catch (SVNClientException ce) {
            sLogger.log(Level.WARNING, "SVNKit subversion client unavailable", ce);
        }
        this._initialized = true;
        long duration = System.currentTimeMillis() - start;
        sLogger.fine("SVNClientRegistry initialized in " + duration + " ms.");
    }

    public boolean isNativeClientAvailable() {
        try {
            this.getNativeClient();
            return true;
        }
        catch (SVNClientException ce) {
            return false;
        }
    }

    public SVNClient getNativeClient() throws SVNClientException {
        if (this._nativeClient == null) {
            ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
            throw new SVNClientException(res.getString("NATIVE_CLIENT_UNAVAILABLE", new Object[]{"libsvnjavahl-l"}));
        }
        return this._nativeClient;
    }

    public boolean isCLIClientAvailable() {
        try {
            this.getCLIClient();
            return true;
        }
        catch (SVNClientException ce) {
            return false;
        }
    }

    public SVNClient getCLIClient() throws SVNClientException {
        if (this._cliClient == null) {
            ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
            throw new SVNClientException(res.getString("CLI_CLIENT_UNAVAILABLE", new Object[]{"'svn'"}));
        }
        return this._cliClient;
    }

    public boolean isSVNKitClientAvailable() {
        try {
            this.getSVNKitClient();
            return true;
        }
        catch (SVNClientException ce) {
            return false;
        }
    }

    public SVNClient getSVNKitClient() throws SVNClientException {
        if (this._svnkitClient == null) {
            ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
            throw new SVNClientException(res.getString("SVNKIT_CLIENT_UNAVAILABLE"));
        }
        return this._svnkitClient;
    }

    public synchronized void setContextClient(Object context, SVNClient clientInfo) {
        this._contexts.put(context, clientInfo);
    }

    public synchronized SVNClient getContextClient(Object id) {
        return (SVNClient)this._contexts.get(id);
    }

    private SVNClientRegistry() {
    }
}

