/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.client;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.ExtensionRegistry;
import oracle.jdevimpl.vcs.svn.client.SVNClient;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public abstract class AbstractSVNClient
implements SVNClient {
    protected final Map _adapters = new HashMap(10);
    private URL _configUrl;

    @Override
    public synchronized ISVNClientAdapter getManagedAdapter(Object id) throws SVNClientException {
        ISVNClientAdapter adapter = (ISVNClientAdapter)this._adapters.get(id);
        if (adapter == null) {
            adapter = SVNClientAdapterFactory.createSVNClient((String)this.getAdapterType());
            if (this.getConfigUrl() != null) {
                adapter.setConfigDirectory(new File(this.getConfigUrl().getPath()));
            }
            this._adapters.put(id, adapter);
        }
        return adapter;
    }

    protected abstract String getAdapterType();

    @Override
    public URL getConfigUrl() {
        if (this._configUrl == null && System.getProperty("jdev.svn.default-config-dir") == null) {
            this._configUrl = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.jdeveloper.subversion");
        }
        return this._configUrl;
    }
}

