/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import oracle.ide.explorer.IconOverlay;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.svn.SVNProfile;

public final class SVNRemoteStatus
implements VCSStatus,
ChangeListStatus {
    private static final ResourcePicker sRes = ResourcePicker.getPicker(SVNProfile.class);
    public static final SVNRemoteStatus UNMODIFIED = new SVNRemoteStatus("UNMODIFIED", sRes.getString("STATUS_UNMODIFIED"));
    public static final SVNRemoteStatus TEXT_MODIFIED = new SVNRemoteStatus("TEXT_MODIFIED", sRes.getString("STATUS_MODIFIED"));
    public static final SVNRemoteStatus PROP_MODIFIED = new SVNRemoteStatus("PROP_MODIFIED", sRes.getString("STATUS_MODIFIED"));
    public static final SVNRemoteStatus TEXT_PROP_MODIFIED = new SVNRemoteStatus("TEXT_PROP_MODIFIED", sRes.getString("STATUS_MODIFIED"));
    public static final SVNRemoteStatus ADDED = new SVNRemoteStatus("ADDED", sRes.getString("REMOTE_STATUS_ADDED"));
    public static final SVNRemoteStatus DELETED = new SVNRemoteStatus("DELETED", sRes.getString("REMOTE_STATUS_DELETED"));
    public static final SVNRemoteStatus UNRECOGNIZED = new SVNRemoteStatus("UNRECOGNIZED", sRes.getString("REMOTE_STATUS_UNRECOGNIZED"));
    private final String _id;
    private final String _label;

    private SVNRemoteStatus(String id, String label) {
        this._id = id;
        this._label = label;
    }

    public String getID() {
        return this._id;
    }

    public String getChangeListLabel() {
        return this._label;
    }

    public boolean isChangeListCellHighlighted() {
        return false;
    }

    public boolean isVersioned() {
        return !this._id.equals("UNRECOGNIZED");
    }

    public boolean isCandidate() {
        return this._id.equals("ADDED");
    }

    public IconOverlay getOverlay() {
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof SVNRemoteStatus && ((SVNRemoteStatus)o)._id.equals(this._id);
    }
}

