/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdevimpl.vcs.svn.util.MergeTempFileFilter;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.svn.util.WorkingCopyURLFilter;

public final class SVNCandidatesEventQueue
extends ChangeListEventQueue {
    private VCSProfile _profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
    private final URLFilter _workingCopyFilter = new WorkingCopyURLFilter();
    private final MergeTempFileFilter _mergeTempFileFilter = new MergeTempFileFilter();
    private VCSStatusFilter _ignoredFilter = this._profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.IGNORED");
    private VCSStatusCache statusCache = this._profile.getStatusCache();

    public SVNCandidatesEventQueue(ChangeList changeList) {
        super(changeList);
        changeList.setExcludeDirectories(true);
    }

    protected void filterByStatus(Collection<VCSHashURL> urls) throws Exception {
        super.filterByStatus(urls);
        Iterator<VCSHashURL> it = urls.iterator();
        while (it.hasNext()) {
            VCSHashURL url = it.next();
            if (this._workingCopyFilter.accept(url.getURL()) && !this._mergeTempFileFilter.accept(url.getURL()) && !this.isAncesterFolderIgnored(url.getURL())) continue;
            it.remove();
        }
    }

    private boolean isAncesterFolderIgnored(URL url) throws Exception {
        boolean gotAdmin = false;
        URL parent;
        while ((parent = URLFileSystem.getParent((URL)url)) != null) {
            boolean isWorkingCopy = SVNUtil.isWorkingCopy(parent);
            if (gotAdmin && !isWorkingCopy) {
                return false;
            }
            if (this._ignoredFilter.accept(this.statusCache.get(parent))) {
                return true;
            }
            gotAdmin = isWorkingCopy;
            url = parent;
        }
        return false;
    }
}

