/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.net.URL;
import java.util.Map;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

abstract class SVNURLInfoCacheStrategy {
    private ISVNClientAdapter _client = null;

    SVNURLInfoCacheStrategy() {
    }

    protected Map<VCSHashURL, SVNURLInfo> getDirectoryURLInfo(URL url, boolean descend) throws SVNClientException {
        throw new UnsupportedOperationException();
    }

    protected abstract SVNURLInfo getURLInfo(URL var1) throws SVNClientException;

    protected abstract void clear();

    protected abstract void clear(URL[] var1);

    protected abstract void clear(URLFilter var1);

    protected final ISVNClientAdapter getClientAdapter() throws SVNClientException {
        if (this._client == null) {
            this._client = SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.CACHE_ADAPTER_CONTEXT_ID);
        }
        return this._client;
    }

    protected final SVNURLInfo toURLInfo(ISVNStatus status) {
        SVNRevision.Number workingRevision = status.getRevision();
        SVNRevision.Number changedRevision = status.getLastChangedRevision();
        return new SVNURLInfo(status.getTextStatus().toInt(), status.getPropStatus().toInt(), workingRevision != null ? workingRevision.getNumber() : -1L, changedRevision != null ? changedRevision.getNumber() : -1L, status.getLastCommitAuthor(), SVNUtil.canonicalizeSVNUrl(status.getUrl()));
    }
}

