/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.net.URL;
import java.util.Map;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCacheSimpleStrategy;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCacheStrategy;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNURLInfoCache {
    private static final SVNURLInfoCache _instance = new SVNURLInfoCache();
    private static final SVNURLInfoCacheStrategy _strategy = new SVNURLInfoCacheSimpleStrategy();

    private SVNURLInfoCache() {
    }

    public static SVNURLInfoCache getInstance() {
        return _instance;
    }

    public int getTextStatus(URL url) throws SVNClientException {
        return _strategy.getURLInfo(url).getTextStatus();
    }

    public int getPropStatus(URL url) throws SVNClientException {
        return _strategy.getURLInfo(url).getPropStatus();
    }

    public long getRevision(URL url) throws SVNClientException {
        return _strategy.getURLInfo(url).getRevision();
    }

    public long getLastChangedRevision(URL url) throws SVNClientException {
        return _strategy.getURLInfo(url).getLastChangedRevision();
    }

    public String getLastCommitAuthor(URL url) throws SVNClientException {
        return _strategy.getURLInfo(url).getLastCommitAuthor();
    }

    public SVNUrl getURL(URL url) throws SVNClientException {
        return _strategy.getURLInfo(url).getURL();
    }

    public void clear() {
        _strategy.clear();
    }

    public void clear(URL[] urls) {
        _strategy.clear(urls);
    }

    public void clear(URLFilter filter) {
        _strategy.clear(filter);
    }

    public SVNURLInfo getURLInfo(URL url) throws SVNClientException {
        return _strategy.getURLInfo(url);
    }

    public Map<VCSHashURL, SVNURLInfo> getDirectoryURLInfo(URL url, boolean descend) throws UnsupportedOperationException, SVNClientException {
        return _strategy.getDirectoryURLInfo(url, descend);
    }
}

