/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSQuickDiffReferenceProvider;
import oracle.jdevimpl.vcs.generic.GenericClient;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.history.SVNHistoricalContentCache;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class SVNQuickDiffReferenceProvider
extends VCSQuickDiffReferenceProvider {
    private static final String ID = "PristineSVNCopy";

    SVNQuickDiffReferenceProvider() {
        super((VCSExtension)((GenericClient)VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion")));
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return ResourcePicker.getPicker(SVNProfile.class).getString("PRISTINE_SVN_COPY");
    }

    public InputStream openInputStream(URL url) throws IOException {
        try {
            long previousRevision = SVNURLInfoCache.getInstance().getRevision(url);
            if (previousRevision < 0L) {
                return null;
            }
            SVNUrl reposUrl = SVNURLInfoCache.getInstance().getURL(url);
            if (reposUrl == null) {
                return null;
            }
            SVNRevision.Number revision = new SVNRevision.Number(previousRevision);
            SVNHistoricalContentCache contentCache = SVNHistoricalContentCache.getInstance();
            if (!contentCache.containsRevisionContent(reposUrl, (SVNRevision)revision)) {
                ISVNClientAdapter client = SVNUtil.getClientAdapter(AbstractSVNOperation.CLIENT_CONTEXT);
                SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(reposUrl);
                SVNClientInteraction.getInstance().beginInteraction(client, repoInfo);
                contentCache.putRevisionContentStream(reposUrl, (SVNRevision)revision, client.getContent(reposUrl, (SVNRevision)revision));
                SVNClientInteraction.getInstance().endInteraction();
            }
            return contentCache.getRevisionContentStream(reposUrl, (SVNRevision)revision);
        }
        catch (SVNClientException svnce) {
            throw new IOException(svnce);
        }
    }
}

