/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.quickdiff.QuickDiffReferenceProvider;
import oracle.ide.quickdiff.QuickDiffReferenceRegistry;
import oracle.ide.wizard.Wizard;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.algorithm.BaseCompareModel;
import oracle.javatools.compare.algorithm.list.ListCompareAlgorithm;
import oracle.javatools.compare.view.BaseCompareView;
import oracle.javatools.compare.view.list.ListCompareView;
import oracle.javatools.jndi.Names;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.compare.CompareManager;
import oracle.jdeveloper.compare.CompareMethod;
import oracle.jdeveloper.compare.StreamType;
import oracle.jdeveloper.merge.AbstractMergeAddin;
import oracle.jdeveloper.vcs.annotations.AnnotationsCommand;
import oracle.jdeveloper.vcs.changeset.cmd.CommentTemplatesConfiguration;
import oracle.jdeveloper.vcs.generic.AbstractProfileListener;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.share.ShareWizard;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdevimpl.vcs.svn.SVNClientSelector;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNQuickDiffReferenceProvider;
import oracle.jdevimpl.vcs.svn.client.SVNClientRegistry;
import oracle.jdevimpl.vcs.svn.compare.SVNCompareModelExtension;
import oracle.jdevimpl.vcs.svn.compare.SVNCompareViewDecoration;
import oracle.jdevimpl.vcs.svn.compare.SVNPropertiesCompareContributor;
import oracle.jdevimpl.vcs.svn.history.SVNHistoryEntryProducer;
import oracle.jdevimpl.vcs.svn.merge.SVNMergeEditor;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesObservable;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryExplorer;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.op.AbstractSVNOperation;
import oracle.jdevimpl.vcs.svn.op.SVNOperationCommit;
import oracle.jdevimpl.vcs.svn.op.SVNOperationResolveConflicts;
import oracle.jdevimpl.vcs.svn.op.SVNOperationViewAnnotation;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.res.Resource;

public class SVNProfile
extends AbstractProfileListener
implements IdeListener {
    public static final String SVN_PROFILE_ID = "oracle.jdeveloper.subversion";
    public static final String SVN_WC_ADMIN_DIR = ".svn";
    public static final Object IDE_CLIENT_CONTEXT_ID = "IDE_Client/Adapter";
    public static final Object IC_ADAPTER_CONTEXT_ID = "IncomingChanges_Adapter";
    public static final Object OC_ADAPTER_CONTEXT_ID = "OutgoingChanges_Adapter";
    public static final Object CACHE_ADAPTER_CONTEXT_ID = "Cache_Adapter";
    private SVNClientSelector _clientSelector;
    private AbstractMergeAddin _mergeEditorAddin;
    CompareType SVN_PROPERTIES = new CompareType("SVN_PROPERTIES");

    public static Logger getQualifiedLogger(String name) {
        return Logger.getLogger("oracle.jdeveloper.subversion." + name);
    }

    public static String getQualifiedKey(String key) {
        return "oracle.jdeveloper.subversion." + key;
    }

    public void profileInitialized(VCSProfile profile) {
        Ide.addIdeListener((IdeListener)this);
        this.bindSystemDir(profile);
        this._clientSelector = new SVNClientSelector(profile);
        Ide.addIdeListener((IdeListener)this._clientSelector);
        ExplorerManager.getExplorerManager().register(SVNRepositoryInfo.class, SVNRepositoryExplorer.class, null, Resource.get("NAV_REPOS_EXPLORER_CAPTION"), null);
        SVNHistoryEntryProducer.CLIENT_CONTEXT = IDE_CLIENT_CONTEXT_ID;
        AbstractSVNOperation.CLIENT_CONTEXT = IDE_CLIENT_CONTEXT_ID;
        SVNRepositoryNavigatorAPI.CLIENT_CONTEXT = IDE_CLIENT_CONTEXT_ID;
        QuickDiffReferenceRegistry.register((QuickDiffReferenceProvider)new SVNQuickDiffReferenceProvider());
        CompareModelFactory.registerCompareAlgorithm((CompareType)this.SVN_PROPERTIES, ListCompareAlgorithm.class);
        CompareViewFactory.registerCompareView((CompareType)this.SVN_PROPERTIES, ListCompareView.class);
        BaseCompareView.registerViewDecoration(SVNCompareViewDecoration.class);
        CompareManager.getCompareManager().registerCompareMethod(new CompareMethod(){

            public boolean canCompare(CompareContributor left, CompareContributor right, StreamType streamType) {
                return left instanceof SVNPropertiesCompareContributor;
            }

            public CompareType getCompareType() {
                return SVNProfile.this.SVN_PROPERTIES;
            }
        });
        BaseCompareModel.registerModelExtension(SVNCompareModelExtension.class);
    }

    public boolean canActivate(VCSProfile profile) {
        boolean canActivate;
        VCSPropertyMap props = profile.getData("CLIENT_TECHNOLOGY");
        props.addChangeListener((ChangeListener)this._clientSelector);
        props.fireChangeEvent();
        boolean bl = canActivate = SVNClientRegistry.getInstance().getContextClient(IDE_CLIENT_CONTEXT_ID) != null;
        if (!canActivate) {
            props.removeChangeListener((ChangeListener)this._clientSelector);
        }
        return canActivate;
    }

    public void profileActivated(final VCSProfile profile) {
        SVNExecutorService.getInstance().activate();
        SVNRepositoryManager.getInstance().load();
        SVNRepositoryNavigatorAPI.getInstance().activate();
        this._mergeEditorAddin = new AbstractMergeAddin(SVNMergeEditor.class){

            protected boolean isEditorAvailable(URL url) {
                try {
                    return SVNOperationResolveConflicts.isEditorAvailable(url);
                }
                catch (Exception e) {
                    SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(e.getMessage());
                    return false;
                }
            }
        };
        EditorManager.getEditorManager().registerDynamic((EditorAddin)this._mergeEditorAddin);
        ShareWizard.registerShareWizard((Wizard)new ShareWizard(Resource.get("SVN_SHORT_NAME"), ResourcePicker.getPicker(SVNProfile.class).getImage("NAV_ICON_REPOSITORIES_NODE"), Ide.findOrCreateCmdID((String)"oracle.jdeveloper.subversion.import")));
        AnnotationsCommand.getAnnotationsAction((String)SVNOperationViewAnnotation.class.getName(), (String)profile.getID());
        CommentTemplatesConfiguration templatesConfiguration = new CommentTemplatesConfiguration();
        templatesConfiguration.setClientSetting(profile.getSettings());
        templatesConfiguration.setRecentCommentsModel(SVNOperationCommit.getRecentCommentsModel());
        templatesConfiguration.setTemplatesDataKey(profile.getQualifiedDataKey("COMMENT_TEMPLATES"));
        templatesConfiguration.setTemplatesSettingsPath(VCSNavigableUtils.getSystemNavigablePath((String)Resource.get("SVN_SHORT_NAME"), (String[])new String[]{VCSCommentsCustomizer.COMMENT_TEMPLATES_NAVIGABLE_LABEL}));
        CommentTemplatesConfiguration.register((String)SVN_PROFILE_ID, (CommentTemplatesConfiguration)templatesConfiguration);
        SVNRepositoriesObservable.getObservable().addObserver(new Observer(){

            @Override
            public final void update(Observable o, Object arg) {
                VCSControlCache.getInstance().fireControlStateChanged(profile.getID());
                profile.getStatusCache().clear();
            }
        });
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
    }

    public void mainWindowClosing(IdeEvent e) {
    }

    private void bindSystemDir(VCSProfile profile) {
        try {
            String systemDir = URLFileSystem.getPlatformPathName((URL)profile.getSystemDirectory());
            Names.bind((Context)new InitialContext(), (String)SVNRepositoryManager.STORE_URL_BINDING_NAME, (Object)systemDir);
        }
        catch (NamingException ne) {
            profile.getLogger().log(Level.WARNING, "problem with jndi environment", ne);
        }
        catch (IllegalStateException ise) {
            profile.getLogger().log(Level.WARNING, ise.getMessage(), ise.getCause());
        }
    }
}

