/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.util.logging.Logger;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNExceptionWrapper {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNClientInteraction.class.getName());

    public static Exception wrapException(Exception ex) {
        if (ex instanceof SVNClientException) {
            return SVNExceptionWrapper.wrapSVNClientException(ex);
        }
        return ex;
    }

    public static VCSException wrapSVNClientException(Exception ex) {
        ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
        String title = res.getString("EXCEPTION_WRAPPER_TITLE");
        String exceptionHeader = "org.tigris.subversion.javahl.ClientException: ";
        String message = ex.getMessage();
        if (message.startsWith(exceptionHeader)) {
            message = message.substring(exceptionHeader.length());
        }
        message = SVNExceptionWrapper.wrapAuthMsg(message, res);
        return new VCSException(title, message);
    }

    public static String wrapAuthMsg(String message, ResourcePicker res) {
        if (message.indexOf("authentication cancelled") > -1) {
            message = message.replaceFirst("authentication cancelled", res.getString("EXCEPTION_WRAPPER_AUTH_CANCELED"));
        }
        return message;
    }
}

