/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.searchbar.addin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.searchbar.addin.Messages;
import oracle.dbtools.raptor.searchbar.addin.SearchListCellEditor;
import oracle.dbtools.raptor.searchbar.addin.SearchListCellRenderer;
import oracle.dbtools.raptor.searchbar.addin.SearchListItem;
import oracle.dbtools.raptor.searchbar.addin.SearchPluginComboBoxUI;
import oracle.dbtools.raptor.searchbar.addin.SearchPluginLoader;
import oracle.dbtools.raptor.searchbar.addin.SearchPluginOptions;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.ClientSetting;
import oracle.ide.controls.Toolbar;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.Href;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogPrintWriter;
import oracle.ide.net.URLFactory;
import oracle.ide.webbrowser.BrowserRunner;

public final class SearchPlugin
implements Addin,
ChangeListener {
    public static final String EXTENSION_ID = "oracle.sqldeveloper.searchbar";
    private JComboBox _searchBox = null;
    private AbstractLogPage _logPage = null;

    public void initialize() {
        Ide.addIdeListener((IdeListener)new IdeAdapter(){

            public void mainWindowOpened(IdeEvent ideEvent) {
                AddinManager addinManager = AddinManager.getAddinManager();
                SearchPlugin searchPlugin = (SearchPlugin)addinManager.getAddin(SearchPlugin.class);
                searchPlugin.initializeToolbar();
            }
        });
    }

    private void initializeToolbar() {
        this._searchBox = new JComboBox();
        this._searchBox.setBorder(BorderFactory.createLoweredBevelBorder());
        this._searchBox.setUI(new SearchPluginComboBoxUI());
        Toolbar toolbar = Ide.getToolbar();
        this._searchBox.setEditable(true);
        this._updateSearchPluginsModel();
        this._searchBox.setRenderer(new SearchListCellRenderer());
        this._searchBox.setEditor(new SearchListCellEditor(this._searchBox));
        this._searchBox.getEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPlugin.this._executeSearchQuery(actionEvent);
            }
        });
        this._searchBox.setSize(120, toolbar.getHeight());
        this._searchBox.setMaximumSize(this._searchBox.getSize());
        this._searchBox.setPreferredSize(this._searchBox.getSize());
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add((Component)this._searchBox);
        if (this._getOptions() != null) {
            this._getOptions().addChangeListener(this);
        }
    }

    private SearchPluginOptions _getOptions() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)EXTENSION_ID);
        SearchPluginOptions searchPluginOptions = (SearchPluginOptions)clientSetting.getData("SearchPluginOptions");
        return searchPluginOptions;
    }

    private void _executeSearchQuery(ActionEvent actionEvent) {
        try {
            if (this._logPage == null) {
                this._logPage = (AbstractLogPage)LogManager.getLogManager().getMsgPage();
            }
            String string = actionEvent.getActionCommand();
            Object object = this._searchBox.getSelectedItem();
            if (object instanceof SearchListItem) {
                SearchListItem searchListItem = (SearchListItem)object;
                URL uRL = new URL(searchListItem.getURL(string));
                BrowserRunner.getBrowserRunner().runBrowserOnURL(uRL, null, (PrintWriter)new LogPrintWriter((LogPage)this._logPage));
                String string2 = MessageFormat.format(Messages.getString("SearchPlugin.5"), searchListItem.getName(), string);
                this._logPage.log((Object)string2);
                this._logPage.log((Object)new WebBrowserHref(uRL));
                this._logPage.log((Object)"\n\n");
            } else {
                this._logPage.log((Object)Messages.getString("SearchPlugin.7"));
                this._logPage.log((Object)(Messages.getString("SearchPlugin.8") + object));
                this._logPage.log((Object)(Messages.getString("SearchPlugin.9") + string));
            }
        }
        catch (MalformedURLException malformedURLException) {
            this._logPage.log((Object)Messages.getString("SearchPlugin.10"));
            this._logPage.log((Object)malformedURLException);
            this._logPage.log((Object)"\n");
        }
        if (this._logPage.isVisible()) {
            this._logPage.activate();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this._updateSearchPluginsModel();
    }

    private void _updateSearchPluginsModel() {
        String string = Ide.getBinDirectory() + "/../searchengines";
        if (string != null && string.length() >= 0) {
            URL uRL = URLFactory.newDirURL((String)string);
            Vector vector = SearchPluginLoader.loadPlugins(uRL);
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(vector);
            this._searchBox.setModel(defaultComboBoxModel);
        }
    }

    class WebBrowserHref
    extends Href {
        WebBrowserHref(URL uRL) {
            super(uRL.toString(), uRL);
        }

        public void go() {
            BrowserRunner.getBrowserRunner().runBrowserOnURL(this.getURL(), null, null);
        }
    }
}

