/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.msg;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Msg {
    private ResourceBundle bundle;
    static final String[] empty = new String[0];

    public Msg(String name) {
        try {
            this.bundle = ResourceBundle.getBundle(name + ".Messages");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    String cleanup(String s) {
        StringBuffer buf = new StringBuffer();
        block9: for (int xChar = 0; xChar < s.length(); ++xChar) {
            char c = s.charAt(xChar);
            switch (c) {
                default: {
                    buf.append(c);
                    continue block9;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block9;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block9;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block9;
                }
                case '\'': {
                    buf.append("\\'");
                    continue block9;
                }
                case ' ': {
                    buf.append("\\ ");
                }
            }
        }
        return buf.toString();
    }

    String lookup(String key, String defaultValue) {
        String fmt = null;
        if (this.bundle != null && key != null) {
            try {
                fmt = this.bundle.getString(key);
            }
            catch (MissingResourceException ignore) {
                // empty catch block
            }
        }
        if (fmt == null) {
            fmt = defaultValue;
        }
        return fmt;
    }

    String format(String key, String defaultValue, Object[] args) {
        String m = this.lookup(key, defaultValue);
        try {
            return MessageFormat.format(m, args);
        }
        catch (Exception ex) {
            StringBuffer buf = new StringBuffer(m).append(": ");
            for (int xArg = 0; xArg < args.length; ++xArg) {
                if (args[xArg] != null) {
                    buf.append(args[xArg]);
                }
                if (xArg == args.length) continue;
                buf.append(", ");
            }
            return buf.toString();
        }
    }

    Object obj(String a) {
        return a;
    }

    Object obj(long n) {
        return new Long(n);
    }

    public String m(String key) {
        return this.format(key, key, empty);
    }

    public String m(String key, String a0) {
        return this.format(key, key, new Object[]{this.obj(a0)});
    }

    public String m(String key, long a0) {
        return this.format(key, key, new Object[]{this.obj(a0)});
    }

    public String m(String key, String a0, String a1) {
        return this.format(key, key, new Object[]{this.obj(a0), this.obj(a1)});
    }

    public String m(String key, String a0, long a1) {
        return this.format(key, key, new Object[]{this.obj(a0), this.obj(a1)});
    }

    public String m(String key, long a0, String a1) {
        return this.format(key, key, new Object[]{this.obj(a0), this.obj(a1)});
    }

    public String m(String key, long a0, long a1) {
        return this.format(key, key, new Object[]{this.obj(a0), this.obj(a1)});
    }

    public String m(String key, String a0, String a1, String a2) {
        return this.format(key, key, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String m(String key, String a0, String a1, long a2) {
        return this.format(key, key, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String m(String key, String a0, long a1, String a2) {
        return this.format(key, key, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String m(String key, String a0, long a1, long a2) {
        return this.format(key, key, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String m(String key, long a0, String a1, String a2) {
        return this.format(key, key, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String m(String key, long a0, String a1, long a2) {
        return this.format(key, key, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String m(String key, long a0, long a1, String a2) {
        return this.format(key, key, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String m(String key, long a0, long a1, long a2) {
        return this.format(key, key, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String k(String key, String value) {
        return this.format(key, value, empty);
    }

    public String k(String key, String value, String a0) {
        return this.format(key, value, new Object[]{this.obj(a0)});
    }

    public String k(String key, String value, long a0) {
        return this.format(key, value, new Object[]{this.obj(a0)});
    }

    public String k(String key, String value, String a0, String a1) {
        return this.format(key, value, new Object[]{this.obj(a0), this.obj(a1)});
    }

    public String k(String key, String value, String a0, long a1) {
        return this.format(key, value, new Object[]{this.obj(a0), this.obj(a1)});
    }

    public String k(String key, String value, long a0, String a1) {
        return this.format(key, value, new Object[]{this.obj(a0), this.obj(a1)});
    }

    public String k(String key, String value, long a0, long a1) {
        return this.format(key, value, new Object[]{this.obj(a0), this.obj(a1)});
    }

    public String k(String key, String value, String a0, String a1, String a2) {
        return this.format(key, value, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String k(String key, String value, String a0, String a1, long a2) {
        return this.format(key, value, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String k(String key, String value, String a0, long a1, String a2) {
        return this.format(key, value, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String k(String key, String value, String a0, long a1, long a2) {
        return this.format(key, value, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String k(String key, String value, long a0, String a1, String a2) {
        return this.format(key, value, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String k(String key, String value, long a0, String a1, long a2) {
        return this.format(key, value, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String k(String key, String value, long a0, long a1, String a2) {
        return this.format(key, value, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }

    public String k(String key, String value, long a0, long a1, long a2) {
        return this.format(key, value, new Object[]{this.obj(a0), this.obj(a1), this.obj(a2)});
    }
}

