/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.classfile;

import oracle.aurora.util.classfile.Lnkd;
import oracle.aurora.util.classfile.TypeFactory;
import oracle.aurora.util.tools.ToolException;

public abstract class Type {
    protected char kind;

    Type(char kind) {
        this.kind = kind;
    }

    public char getKind() {
        return this.kind;
    }

    public int getTypeCode() {
        int t;
        switch (this.kind) {
            case 'B': {
                t = 1;
                break;
            }
            case 'C': {
                t = 2;
                break;
            }
            case 'D': {
                t = 7;
                break;
            }
            case 'F': {
                t = 6;
                break;
            }
            case 'I': {
                t = 4;
                break;
            }
            case 'J': {
                t = 5;
                break;
            }
            case 'S': {
                t = 3;
                break;
            }
            case 'Z': {
                t = 0;
                break;
            }
            case 'V': {
                t = 11;
                break;
            }
            case 'L': {
                t = 10;
                break;
            }
            case '(': {
                t = 12;
                break;
            }
            case '[': {
                t = 9;
                break;
            }
            case '0': {
                t = 13;
                break;
            }
            default: {
                t = 13;
                System.out.println("error typecode " + this.kind);
            }
        }
        return t;
    }

    public boolean isSimple() {
        return this.isPrimitive() || this.isClass();
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isPrimitive(char c) {
        return this.isPrimitive() && this.kind == c;
    }

    public boolean isArray() {
        return this.dim() != 0;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isUnboundClass() {
        return false;
    }

    public boolean isObject() {
        return this.isArray() || this.isClass() || this.isUnboundClass();
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public Lnkd[] interfaces() {
        return null;
    }

    public Lnkd superClass() {
        return null;
    }

    public Lnkd lnkd() {
        return null;
    }

    public Type elem() {
        return null;
    }

    public int dim() {
        return 0;
    }

    public LinkageError error() {
        return null;
    }

    public Type returnType() {
        return null;
    }

    public Type[] params() {
        return null;
    }

    public String getClassName() {
        return null;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public String declaration() {
        return this.declaration("");
    }

    public String declaration(String name) {
        String decl;
        if (name == null) {
            name = "";
        }
        if (this.isClass() | this.isUnboundClass()) {
            decl = this.getClassName().replace('/', '.') + " " + name;
        } else if (this.isArray()) {
            StringBuffer e = new StringBuffer(this.elem().declaration());
            for (int x = 0; x < this.dim(); ++x) {
                e.append("[]");
            }
            e.append(' ').append(name);
            decl = e.toString();
        } else {
            decl = this.toString() + " " + name;
        }
        return decl;
    }

    public abstract String toString();

    public Type[] getArgumentTypes() {
        return this.params();
    }

    public Type getElementType() {
        return this.elem();
    }

    public Type getReturnType() {
        return this.returnType();
    }

    static class TypeError
    extends Type {
        LinkageError error_;

        TypeError(LinkageError error) {
            super('0');
            this.error_ = error;
        }

        public LinkageError error() {
            return this.error_;
        }

        public boolean isError() {
            return true;
        }

        public int hashCode() {
            return "Error".hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof Error;
        }

        public String toString() {
            return "TYPE_ERROR";
        }
    }

    static class Method
    extends Type {
        Type _returnType;
        Type[] _params;

        Method(Type[] params, Type returnType) {
            super('(');
            this._returnType = returnType;
            this._params = params;
        }

        public boolean isMethod() {
            return true;
        }

        public Type returnType() {
            return this._returnType;
        }

        public Type[] params() {
            return this._params;
        }

        public int hashCode() {
            int h = this._returnType.hashCode();
            for (int xParam = 0; xParam < this._params.length; ++xParam) {
                h += this._params[xParam].hashCode();
            }
            return h;
        }

        public boolean equals(Object other) {
            boolean eq;
            if (!(other instanceof Method)) {
                eq = false;
            } else {
                Type[] oParams = ((Method)other).params();
                eq = this._params.length == oParams.length;
                for (int xParam = 0; xParam < this._params.length && eq; ++xParam) {
                    eq = this._params[xParam].equals(oParams[xParam]);
                }
            }
            return eq;
        }

        public String declaration(String name) {
            if (name == null) {
                name = "";
            }
            StringBuffer t = new StringBuffer();
            t.append(this.returnType().toString());
            t.append(' ');
            t.append(name);
            t.append('(');
            Type[] params = this.params();
            for (int xParam = 0; xParam < params.length; ++xParam) {
                t.append(params[xParam].toString());
                if (xParam == params.length - 1) continue;
                t.append(", ");
            }
            t.append(')');
            return t.toString();
        }

        public String toString() {
            return this.declaration("");
        }
    }

    static class Primitive
    extends Type {
        Primitive(char kind) {
            super(kind);
        }

        public boolean isPrimitive() {
            return true;
        }

        public int hashCode() {
            return this.kind;
        }

        public boolean equals(Object other) {
            return other instanceof Primitive && this.kind == ((Primitive)other).kind;
        }

        public String toString() {
            String t;
            switch (this.kind) {
                case 'B': {
                    t = "byte";
                    break;
                }
                case 'C': {
                    t = "char";
                    break;
                }
                case 'D': {
                    t = "double";
                    break;
                }
                case 'F': {
                    t = "float";
                    break;
                }
                case 'I': {
                    t = "int";
                    break;
                }
                case 'J': {
                    t = "long";
                    break;
                }
                case 'S': {
                    t = "short";
                    break;
                }
                case 'Z': {
                    t = "boolean";
                    break;
                }
                case 'V': {
                    t = "void";
                    break;
                }
                default: {
                    t = "kind-" + this.kind;
                }
            }
            return t;
        }
    }

    static class Array
    extends Type {
        int _dim;
        Type _elem;
        TypeFactory factory;

        Array(int dim, Type elem, TypeFactory factory) {
            super('[');
            this.factory = factory;
            if (elem instanceof Array) {
                this._dim = elem.dim() + dim;
                this._elem = elem.elem();
            } else {
                this._dim = dim;
                this._elem = elem;
            }
        }

        public boolean isArray() {
            return true;
        }

        public Type elem() {
            return this._elem;
        }

        public int dim() {
            return this._dim;
        }

        public Lnkd superClass() {
            return this.factory.arraySuper();
        }

        public Lnkd[] interfaces() {
            return this.factory.arrayInterfaces();
        }

        public int hashCode() {
            return this._elem.hashCode() * (this._dim + 1);
        }

        public boolean equals(Object other) {
            boolean eq = false;
            if (other instanceof Array) {
                Array oArray = (Array)other;
                eq = this.dim() == oArray.dim() && this.elem().equals(oArray.elem());
            }
            return eq;
        }

        public String toString() {
            StringBuffer brackets = new StringBuffer();
            for (int x = 0; x < this.dim(); ++x) {
                brackets.append("[]");
            }
            return this.elem().toString() + brackets;
        }
    }

    static class UnboundUser
    extends Type {
        String name;
        LinkageError error_;

        UnboundUser(String name) {
            super('L');
            this.name = name;
            this.error_ = new NoClassDefFoundError(name);
        }

        public boolean isUnboundClass() {
            return true;
        }

        public boolean isError() {
            return true;
        }

        public LinkageError error() {
            return this.error_;
        }

        public String getClassName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof UnboundUser && this.name.equals(((UnboundUser)other).name);
        }

        public String toString() {
            return "Unbound class(" + this.name + ")";
        }
    }

    static class User
    extends Type {
        Lnkd linked;

        User(Lnkd linked) {
            super('L');
            this.linked = linked;
        }

        public boolean isClass() {
            return true;
        }

        public Lnkd lnkd() {
            return this.linked;
        }

        public Lnkd[] interfaces() {
            try {
                return this.linked.getClazz().getInterfaces();
            }
            catch (ToolException ex) {
                return null;
            }
        }

        public Lnkd superClass() {
            try {
                return this.linked.getClazz().getSuperClass();
            }
            catch (ToolException ex) {
                return null;
            }
        }

        public int hashCode() {
            return this.linked.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof User && this.linked.equals(((User)other).linked);
        }

        public String getClassName() {
            try {
                return this.linked.getClazz().getName();
            }
            catch (ToolException ex) {
                return "<UNKNOWN>";
            }
        }

        public String toString() {
            try {
                return this.linked.getClazz().getName();
            }
            catch (ToolException ex) {
                return "Bad Class(" + ex.toString() + ")";
            }
        }
    }
}

