/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.classfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import oracle.aurora.util.classfile.Raw;

public class RawFactory
implements Raw.JavaConstants {
    Raw.Class raw = new Raw.Class();
    private Vector constants;
    private Vector interfaces;
    private Vector fields;
    private Vector methods;
    private Vector attributes;

    public RawFactory() {
        this.raw.magic = -889275714;
        this.raw.majorVersion = 45;
        this.raw.minorVersion = 3;
        this.raw.accessFlags = 0;
        this.constants = new Vector();
        this.constants.addElement(null);
        this.interfaces = new Vector();
        this.fields = new Vector();
        this.methods = new Vector();
        this.attributes = new Vector();
    }

    public Raw.Class toRaw() {
        this.raw.poolCount = this.constants.size();
        this.raw.constantPool = new Raw.Constant[this.raw.poolCount];
        this.toArray(this.constants, this.raw.constantPool);
        this.raw.interfaceCount = this.interfaces.size();
        this.raw.interfaces = this.toIntArray(this.interfaces);
        this.raw.fieldCount = this.fields.size();
        this.raw.fields = new Raw.Member[this.raw.fieldCount];
        this.toArray(this.fields, this.raw.fields);
        this.raw.methodCount = this.methods.size();
        this.raw.methods = new Raw.Member[this.raw.methodCount];
        this.toArray(this.methods, this.raw.methods);
        this.raw.attributeCount = this.attributes.size();
        this.raw.attributes = new Raw.Attribute[this.raw.attributeCount];
        this.toArray(this.attributes, this.raw.attributes);
        return this.raw;
    }

    int[] toIntArray(Vector v) {
        int[] a = new int[v.size()];
        for (int x = 0; x < a.length; ++x) {
            a[x] = ((Number)v.get(x)).intValue();
        }
        return a;
    }

    Object[] toArray(Vector v, Object[] a) {
        for (int x = 0; x < v.size(); ++x) {
            a[x] = v.elementAt(x);
        }
        return a;
    }

    int get(Raw.Constant constant) {
        return this.constants.indexOf(constant);
    }

    public int add(Raw.Constant constant) {
        int x = this.get(constant);
        if (x < 0) {
            x = this.constants.size();
            this.constants.addElement(constant);
        }
        return x;
    }

    public int addConstant(int tag, String value) {
        return this.add(this.constant(tag, value));
    }

    public int addConstantPair(int tag, Raw.Constant first, Raw.Constant second) {
        return this.add(this.constant(tag, first, second));
    }

    public int setThis(String name) {
        this.raw.thisClass = this.add(this.constant(7, name));
        return this.raw.thisClass;
    }

    public int setSuper(String name) {
        this.raw.superClass = this.add(this.constant(7, name));
        return this.raw.superClass;
    }

    public void setAccess(int accessFlags) {
        this.raw.accessFlags = accessFlags;
    }

    public int addMember(Raw.Member m, Vector v) {
        int x = v.size();
        v.addElement(m);
        return x;
    }

    public int addField(Raw.Member field) {
        return this.addMember(field, this.fields);
    }

    public int addMethod(Raw.Member method) {
        return this.addMember(method, this.methods);
    }

    public void addMethod(int accessFlags, String name, String descriptor, Raw.Code code, Raw.Attribute[] attributes) {
        int attLen;
        int n = attLen = attributes == null ? 0 : attributes.length;
        if (code != null) {
            ++attLen;
        }
        Raw.Attribute[] att = new Raw.Attribute[attLen];
        int xNextAtt = 0;
        if (code != null) {
            Raw.Attribute codeAttribute;
            int codeIndex = this.add(this.constant(1, "Code"));
            byte[] codeBytes = this.toBytes(code);
            att[0] = codeAttribute = new Raw.Attribute(codeIndex, codeBytes);
            xNextAtt = 1;
        }
        if (attributes != null) {
            System.arraycopy(attributes, 0, att, xNextAtt, attributes.length);
        }
        Raw.Member method = new Raw.Member(accessFlags, this.add(this.constant(1, name)), this.add(this.constant(1, descriptor)), att);
        this.addMethod(method);
    }

    public void add(Raw.Attribute a) {
        this.attributes.addElement(a);
    }

    public Raw.Constant constant(int tag, String info) {
        Raw.Constant c = new Raw.Constant();
        c.tag = tag;
        switch (tag) {
            case 1: {
                c.info = info;
                break;
            }
            case 3: {
                c.info = Integer.valueOf(info);
                break;
            }
            case 4: {
                c.info = Float.valueOf(info);
                break;
            }
            case 5: {
                c.info = Long.valueOf(info);
                break;
            }
            case 6: {
                c.info = Double.valueOf(info);
                break;
            }
            case 7: 
            case 8: {
                c.info = new Integer(this.add(this.constant(1, info)));
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                c.info = null;
            }
        }
        return c;
    }

    public Raw.Constant constant(int tag, Number info) {
        Raw.Constant c = new Raw.Constant();
        c.tag = tag;
        switch (tag) {
            case 1: {
                break;
            }
            case 3: {
                c.info = new Integer(info.intValue());
                break;
            }
            case 4: {
                c.info = new Float(info.floatValue());
                break;
            }
            case 5: {
                c.info = new Long(info.longValue());
                break;
            }
            case 6: {
                c.info = new Double(info.doubleValue());
                break;
            }
            case 7: 
            case 8: {
                c.info = new Integer(info.intValue());
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                c.info = null;
            }
        }
        return c;
    }

    public Raw.Constant constant(int tag, Raw.Constant first, Raw.Constant second) {
        Raw.Constant c = new Raw.Constant();
        c.tag = tag;
        switch (tag) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                c.info = null;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                c.info = new Raw.Pair(this.add(first), this.add(second));
            }
        }
        return c;
    }

    byte[] toBytes(Raw.Write w) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream d = new DataOutputStream(b);
        Raw.RawOutput r = new Raw.RawOutput(d);
        try {
            w.write(r);
            d.flush();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return b.toByteArray();
    }
}

